<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class DIMA_CategoryGrid {
	public function __construct() {
		add_shortcode( 'dima_category_grid', array( $this, 'dima_shortcode_category_grid' ) );
	}
	function dima_shortcode_category_grid( $atts ) {
		extract(
			shortcode_atts(
				array(
					'post_type'                   => 'posts',
					'product_category'            => '',
					'blog_category'               => '',
					'text_content_alignment'      => 'top_left',
					'subtext'                     => 'none',
					'orderby'                     => '',
					'order'                       => '',
					'grid_item_spacing'           => '10px',
					'columns'                     => '4',
					'enable_masonry'              => '',
					'color_overlay'               => '',
					'color_overlay_opacity'       => '',
					'color_overlay_hover_opacity' => '',
					'text_color'                  => 'dark',
					'text_color_hover'            => 'dark',
					'custom_subtext'              => '',
					'subtext_visibility'          => 'always',
					'shadow_on_hover'             => '',
					'text_style'                  => 'default',

				),
				$atts
			)
		);
		ob_start();
		echo '<div class="dima-category-grid flex flex-wrap" data-columns="' . esc_attr( $columns ) . '" data-text-style="' . esc_attr( $text_style ) . '" data-grid-spacing="' . esc_attr( $grid_item_spacing ) . '" data-alignment="' . esc_attr( $text_content_alignment ) . '" data-text-color="' . esc_attr( $text_color ) . '" data-text-hover-color="' . esc_attr( $text_color_hover ) . '" data-masonry="' . esc_attr( $enable_masonry ) . '">';

		// Posts
		if ( $post_type === 'posts' ) {

			// All categories.
			if ( $blog_category === 'all' || $blog_category === '' ) {

				$categories = get_categories();

				foreach ( $categories as $temp_cat_obj_holder ) {

					echo dima_grid_item_markup( $temp_cat_obj_holder, $atts );

				} //loop

			} //end post category all conditional

			else {

				if ( empty( $blog_category ) ) {
					return;
				}

				$category_slug_list = explode( ',', $blog_category );

				foreach ( $category_slug_list as $k => $slug ) {

					$temp_cat_obj_holder = get_term_by( 'slug', $slug, 'category' );
					echo dima_grid_item_markup( $temp_cat_obj_holder, $atts );

				} //loop

			}
		} //end blog post type

		elseif ( $post_type === 'products' ) {

			// All categories.
			if ( $product_category == 'all' || $product_category === '' ) {

				$grid_query = array(
					'taxonomy' => 'product_cat',
				);

				$categories = get_categories( $grid_query );

				foreach ( $categories as $temp_cat_obj_holder ) {

						  echo dima_grid_item_markup( $temp_cat_obj_holder, $atts );

				} //loop

			} //end product category all conditional

			else {

				if ( empty( $product_category ) ) {
					return;
				}

				$category_slug_list = explode( ',', $product_category );

				foreach ( $category_slug_list as $k => $slug ) {

					$temp_cat_obj_holder = get_term_by( 'slug', $slug, 'product_cat' );
					echo dima_grid_item_markup( $temp_cat_obj_holder, $atts );

				} //loop

			}// end selected category conditional
		}// end product post type

		echo '</div>';
		return ob_get_clean();
	}
}
new DIMA_CategoryGrid();
// ==== END!


/**
	 * Category grid display helper.
	 *
	 * @since 1.0
	 */
if ( ! function_exists( 'dima_grid_item_markup' ) ) {

	function dima_grid_item_markup( $temp_cat_obj_holder, $atts ) {
		wp_enqueue_style( 'dima-element-category-grid' );
		$markup = '';

		if ( $temp_cat_obj_holder ) {

			$temp_cat_obj_holder->term_id;
			$temp_cat_obj_holder->name;

			// grab cat image.
			$bg_style_markup = '';

			if ( $atts['post_type'] === 'posts' ) {
				$thumbnail_id = get_post_thumbnail_id( $temp_cat_obj_holder->term_id );
				$image_bg     = get_term_meta( $temp_cat_obj_holder->term_id, '_dima_category_thumbnail_image' );
				if ( ! empty( $image_bg ) && is_array( $image_bg ) ) {
					$bg_style_markup = ( ! empty( $image_bg ) ) ? 'style="background-image:url(' . $image_bg[0] . ');"' : '';
				}
			} elseif ( $atts['post_type'] === 'products' ) {
						  $thumbnail_id    = get_term_meta( $temp_cat_obj_holder->term_id, 'thumbnail_id', true );
						  $image_bg        = wp_get_attachment_image_src( $thumbnail_id, 'large' );
						  $bg_style_markup = ( ! empty( $image_bg ) ) ? 'style="background-image:url(' . $image_bg[0] . ');"' : '';
			}

			$bg_overlay_markup = ( ! empty( $atts['color_overlay'] ) ) ? 'style=" background-color: ' . $atts['color_overlay'] . ';"' : '';

			$markup .= '<div class="dima-category-grid-item" data-shadow-hover="' . esc_attr( $atts['shadow_on_hover'] ) . '"> <div class="inner"> <a class="dima-category-grid-link" href="' . get_term_link( $temp_cat_obj_holder->term_id ) . '"></a>';
			$markup .= '<div class="dima-category-grid-item-bg" ' . $bg_style_markup . '></div>';
			$markup .= '<div class="bg-overlay opacity-' . $atts['color_overlay_opacity'] . '" ' . $bg_overlay_markup . ' data-hover-opacity="' . $atts['color_overlay_hover_opacity'] . '"></div>';
			$markup .= '<div class="content" data-subtext-vis="' . $atts['subtext_visibility'] . '" data-subtext="' . $atts['subtext'] . '" ><h3>' . $temp_cat_obj_holder->name . '</h3>';

			if ( $atts['subtext'] === 'cat_item_count' ) {

				$subtext_count_markup = '';

				if ( $atts['post_type'] === 'posts' ) {

					if ( $temp_cat_obj_holder->count == 1 ) {
									$subtext_count_markup = '<span class="subtext">' . $temp_cat_obj_holder->count . ' ' . esc_html__( 'post', 'noor-assistant' ) . '</span>';
					} else {
								$subtext_count_markup = '<span class="subtext">' . $temp_cat_obj_holder->count . ' ' . esc_html__( 'posts', 'noor-assistant' ) . '</span>';
					}
				} elseif ( $atts['post_type'] === 'products' ) {

					if ( $temp_cat_obj_holder->count == 1 ) {
									$subtext_count_markup = '<span class="subtext">' . $temp_cat_obj_holder->count . ' ' . esc_html__( 'product', 'noor-assistant' ) . '</span>';
					} else {
								$subtext_count_markup = '<span class="subtext">' . $temp_cat_obj_holder->count . ' ' . esc_html__( 'products', 'noor-assistant' ) . '</span>';
					}
				}

					$markup .= $subtext_count_markup;

			} elseif ( $atts['subtext'] === 'custom' ) {
				$markup .= '<span class="subtext">' . $atts['custom_subtext'] . '</span>';
			}

			$markup .= '</div>';
			$markup .= '</div></div>';
		}

		return $markup;

	}
}
