<?php
/*
Plugin Name: DIMA-Shortcodes
Plugin URI: http://pixeldima.com/
Version: 1.0.0
Author: PixelDima
Author URI: http://pixeldima.com/
Text Domain: dima-shortcodes

*/


/**
 * Class and Function List:
 * Function list:
 * - dima_shortcode_blog()
 * Classes list:
 */


class DIMA_RecentPosts {
	private $query     = '';
	private $is_paging = true;

	public function __construct() {
		add_shortcode( 'blog', array( $this, 'dima_shortcode_blog' ) );
	}

	function dima_shortcode_blog( $atts ) {

		extract(
			shortcode_atts(
				array(
					'id'                              => '',
					'post_class'                      => '',
					'style'                           => '',
					'blog_style'                      => 'standard',
					'post_title_above'                => 'true',
					'count'                           => 3,
					'column'                          => 3,
					'show_meta'                       => '',
					'blog_remove_post_comment_number' => '',
					'blog_remove_post_category'       => '',
					'blog_remove_post_date'           => '',
					'blog_remove_post_author'         => '',
					'img_hover'                       => '',
					'elm_hover'                       => '',
					'words'                           => '',
					'items_margin'                    => 'false',
					'dark'                            => '',
					'category'                        => '',
					'dots'                            => '',
					'tag'                             => '',
					'offset'                          => '',
					'filters'                         => 'no',
					'paging'                          => 'false',
					'order'                           => '',
					'show_image'                      => 'true',
				),
				$atts,
				'blog'
			)
		);

		$id                              = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
		$style                           = ( $style != '' ) ? 'style="' . $style . '"' : '';
		$post_class                      = ( $post_class != '' ) ? ' ' . esc_attr( $post_class ) : '';
		$category                        = ( $category != '' ) ? $category : '';
		$tag                             = ( $tag != '' ) ? $tag : '';
		$elm_hover                       = ( $elm_hover != '' ) ? $elm_hover : '';
		$img_hover                       = ( $img_hover != '' ) ? $img_hover : '';
		$show_image                      = dima_helper::dima_am_i_true( $show_image );
		$show_meta                       = ( $show_meta == 'false' ) ? '0' : '1';
		$blog_remove_post_comment_number = ( $blog_remove_post_comment_number == 'false' ) ? '0' : '1';
		$blog_remove_post_category       = ( $blog_remove_post_category == 'false' ) ? '0' : '1';
		$blog_remove_post_author         = ( $blog_remove_post_author == 'false' ) ? '0' : '1';
		$blog_remove_post_date           = ( $blog_remove_post_date == 'false' ) ? '0' : '1';
		$items_margin                    = ( $items_margin == 'false' ) ? false : true;
		$post_title_above                = ( $post_title_above == 'false' ) ? false : true;
		$paging                          = ( $paging != 'true' ) ? false : true;
		$dots                            = ( $dots != 'true' ) ? false : true;
		$words                           = ( $words != '' ) ? $words : '150';
		$column                          = ( $column != '' ) ? $column : 3;
		$count                           = ( $count != '' ) ? $count : 3;
		$order                           = ( $order != '' ) ? $order : '';

		$this->is_paging = $paging;

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' ); } elseif ( get_query_var( 'page' ) ) {
					  $paged = get_query_var( 'page' ); } else {
				$paged = 1; }

						if ( $offset != '' && $paging == true ) {
							$offset = ( $paged - $offset ) * $count;}

						switch ( $order ) {
							case 'top-view':
								$order_array = array(
									'meta_key' => 'dima_post_views_count',
									'orderby'  => 'meta_value_num',
									'order'    => 'DESC',
								);
								break;
							case 'popular':
								$order_array = array(
									'orderby' => 'comment_count',
									'order'   => 'DESC',
								);
								break;
							default:
								$order_array = array( 'orderby' => 'date' );
								break;
						}
						$filters_array = array(
							'filters'  => $filters,
							'category' => $category,
						);

		if ( ! empty( $category ) ) {
			$category = dima_helper::dima_get_slug_by_ids( $category, 'term_id', 'category' );
		}

		if ( ! empty( $tag ) ) {
			$tag = dima_helper::dima_get_slug_by_ids( $tag, 'term_id', 'post_tag' );
		}

		// Search
		if ( isset( $_GET['post_type'] ) ) {
			$post_type   = array( 'post_type' => 'post' );
			$order_array = array_merge( $order_array, $post_type );
		}

		if ( isset( $_GET['s'] ) ) {
			$array_query = array(
				's'             => "{$_GET['s']}",
				'paged'         => "{$paged}",
				'offset'        => "{$offset}",
				'category_name' => "{$category}",
				'tag'           => "{$tag}",
			);
			$merge       = array_merge( $array_query, $order_array );
			$dima_query  = new WP_Query( $merge );
		} elseif ( $paging ) {
			$array_query = array(
				'post_type'      => 'post',
				'posts_per_page' => "{$count}",
				'paged'          => "{$paged}",
				'offset'         => "{$offset}",
				'category_name'  => "{$category}",
				'tag'            => "{$tag}",
			);
			$merge       = array_merge( $array_query, $order_array );
			$dima_query  = new WP_Query( $merge );
			$this->query = $dima_query;
		} else {
			$array_query = array(
				'post_type'      => 'post',
				'posts_per_page' => "{$count}",
				'offset'         => "{$offset}",
				'category_name'  => "{$category}",
				'tag'            => "{$tag}",
			);
			$merge       = array_merge( $array_query, $order_array );
			$dima_query  = new WP_Query( $merge );
			$this->query = $dima_query;
		}

		if ( is_archive() ) {
			global $wp_query;
			$dima_query = $wp_query;
		}

		$ARG_ARRAY = array(
			'show_meta'                       => $show_meta,
			'blog_remove_post_comment_number' => $blog_remove_post_comment_number,
			'blog_remove_post_category'       => $blog_remove_post_category,
			'blog_remove_post_date'           => $blog_remove_post_date,
			'blog_remove_post_author'         => $blog_remove_post_author,
			'show_image'                      => $show_image,
			'elm_hover'                       => $elm_hover,
			'img_hover'                       => $img_hover,
			'words'                           => $words,
			'blog_style'                      => $blog_style,
			'post_class'                      => $post_class,
			'post_title_above'                => $post_title_above,
			'animation'                       => 'transition.slideUpIn',
			'delay'                           => 30,
			'delay_offset'                    => '98%',
			'delay_duration'                  => 750,
			'data-dima-animate-item'          => '.post',
		);

		$clm = dima_helper::dima_get_clm( $column );

		$POST_ARRAY = array(
			'blog_style'   => $blog_style,
			'column'       => $column,
			'clm'          => $clm,
			'count'        => $count,
			'pagination'   => 'true',
			'dots'         => $dots,
			'auto_play'    => 'true',
			'navigation'   => 'false',
			'loop'         => 'false',
			'items'        => $column,
			'items_phone'  => '',
			'items_tablet' => '',
			'items_margin' => $items_margin,
			'dark'         => $dark,
		);
		ob_start();
		$this->Blog_Style( $POST_ARRAY, $dima_query, $ARG_ARRAY, $filters_array );
		return ob_get_clean();
	}

	public function Blog_Style( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {
		if ( empty( $wp_query ) ) {
			$wp_query = new WP_Query( array( 'orderby' => 'date' ) );
		}
		if ( $POST_ARRAY['blog_style'] != '' ) {
			if ( $POST_ARRAY['blog_style'] == 'grid' ) {
				$this->masonry( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array, 'dima-layout-grid' );
			} else {
				$this->{$POST_ARRAY['blog_style']}( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array );
			}
		} else {
			$this->standard( $POST_ARRAY, $wp_query, $ARG_ARRAY );
		}
	}

	function masonry( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array, $class_ = 'dima-layout-masonry' ) {
		$animation_data  = $id = '';
		$animation_data .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';
		$show_filters    = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';
		$classes         = array();

		$ARG_ARRAY['post_class'] .= ' article-separation';
		if ( is_archive() || is_search() || is_home() || ( is_singular() && is_page() ) ) {
			if ( $show_filters || $class_ == 'dima-layout-masonry' ) {
				 wp_enqueue_script( 'isotope.pkgd' );
				 $ARG_ARRAY['post_class'] .= ' isotope-item';
				 $classes[]                = 'dima-isotope-container';
				 $id                       = 'id=dima-isotope-container';
			}
		}

		$classes[] = 'dcl-m-' . $POST_ARRAY['column'];
		$classes[] = 'boxed-blog blog-list grid-masonry clearfix';
		$classes   = join( ' ', $classes );
		?>

	<div <?php esc_attr_e( $id ); ?> class="dima-isotope-wrapper clearfix <?php echo esc_attr( $class_ ); ?>">
		<?php
		if ( $show_filters ) {
			dima_portfolio_filters( $filters_array, 'blog' );
		}
		?>
	<div class="<?php echo esc_attr( $classes ); ?>" <?php echo $animation_data; ?>>
	  <div class="dima-blocks dima-justify-start flex-wrap flex">
		<?php
		if ( $wp_query->have_posts() ) :
			while ( $wp_query->have_posts() ) :
				 $wp_query->the_post();
				 dima_helper::dima_get_view_with_args( 'partials/contents', 'content', get_post_format(), $ARG_ARRAY );
		   endwhile;
			   wp_reset_postdata();
			   else :
					dima_helper::dima_get_view( 'partials/contents', 'content-none' );
			   endif;
				?>
	  </div>
	  </div>
	</div>
		<?php
		if ( $this->is_paging ) {
			ob_start();
			dima_pagination( $wp_query );
			$pagination = ob_get_contents();
			ob_get_clean();
			echo $pagination;
		}
		wp_reset_query();
	}

	function standard( $POST_ARRAY, $wp_query, $ARG_ARRAY ) {
		$animation_data           = '';
		$animation_data          .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';
		$ARG_ARRAY['post_class'] .= ' article-separation';
		?>
	<div class="boxed-blog blog-list dima-layout-standard" <?php echo $animation_data; ?>>
		<?php
		if ( $wp_query->have_posts() ) {

			while ( $wp_query->have_posts() ) :
				$wp_query->the_post();
				dima_helper::dima_get_view_with_args( 'partials/contents', 'content', get_post_format(), $ARG_ARRAY );
				endwhile;
			wp_reset_postdata();
		} else {
			dima_helper::dima_get_view( 'partials/contents', 'content-none' );
		}
		?>
	</div>
		<?php
		if ( $this->is_paging ) {
			  ob_start();
			  dima_pagination( $wp_query );
			  $pagination = ob_get_contents();
			  ob_get_clean();
			  echo $pagination;
		}
		wp_reset_query();
	}

	function minimal( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {
		$animation_data           = '';
		$animation_data          .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data          .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';
		$show_filters             = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';
		$classes                  = array();
		$id                       = '';
		$classes[]                = 'dima-minimal-style';
		$ARG_ARRAY['post_class'] .= $POST_ARRAY['clm'];
		$ARG_ARRAY['post_class'] .= ' article-separation';
		if ( is_archive() || is_home() || ( is_singular() && is_page() ) ) {
			if ( $show_filters ) {
				wp_enqueue_script( 'isotope.pkgd' );
					$ARG_ARRAY['post_class'] .= ' isotope-item';
					$classes[]                = 'dima-isotope-container';
					$id                       = 'id=dima-isotope-container';
			}
		}
		if ( ! empty( $ARG_ARRAY['no_margin'] ) ) {
			$classes[] = 'minimal_no_margin';
		}
		$classes = join( ' ', $classes );
		?>
	<div <?php esc_attr_e( $id ); ?> class="dima-isotope-wrapper clearfix">
		<?php
		if ( $show_filters ) {
			dima_portfolio_filters( $filters_array, 'blog' );
		}
		?>
		<div  class="boxed-blog blog-list grid-masonry dcl-m-<?php echo $POST_ARRAY['column'] . ' ' . $classes; ?>" <?php echo $animation_data; ?>>
			<div class="dima-blocks dima-justify-start flex-wrap flex">
			<?php
			if ( $wp_query->have_posts() ) {
				while ( $wp_query->have_posts() ) :
					$wp_query->the_post();
					dima_helper::dima_get_view_with_args( 'partials/contents', 'content', 'minimal-post-grid', $ARG_ARRAY );
				endwhile;
				wp_reset_postdata();
			} else {
				dima_helper::dima_get_view( 'partials/contents', 'content-none' );
			}
			?>
			</div>
		</div>
	</div>
		<?php
		if ( $this->is_paging ) {
			  ob_start();
			  dima_pagination( $wp_query );
			  $pagination = ob_get_contents();
			  ob_get_clean();
			  echo $pagination;
		}
		wp_reset_query();
	}

	function minimal_no_margin( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {

		$animation_data  = '';
		$animation_data .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';
		$classes         = array();
		$show_filters    = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';
		$id              = '';

		$root_class               = ' dima-minimal-style minimal_no_margin';
		$ARG_ARRAY['post_class'] .= $POST_ARRAY['clm'];
		if ( $show_filters ) {
			wp_enqueue_script( 'isotope.pkgd' );
			$classes[] = 'dima-isotope-container';
			$id        = 'id=dima-isotope-container';
		}
		$classes = join( ' ', $classes );
		?>
	 <div <?php esc_attr_e( $id ); ?> class="dima-isotope-wrapper clearfix">
			<?php
			if ( $show_filters ) {
				dima_portfolio_filters( $filters_array, 'blog' );
			}
			?>
	<div class="<?php echo $root_class . ' clm-' . $POST_ARRAY['column'] . ' ' . $classes; ?> boxed-blog blog-list" <?php echo $animation_data; ?>>
	 <div class="dima-blocks dima-justify-start flex-wrap flex">
		<?php
		if ( $wp_query->have_posts() ) {
			while ( $wp_query->have_posts() ) :
				$wp_query->the_post();
				dima_helper::dima_get_view_with_args( 'partials/contents', 'content', 'minimal-post-grid', $ARG_ARRAY );
			endwhile;
			wp_reset_postdata();
		} else {
			dima_helper::dima_get_view( 'partials/contents', 'content-none' );
		}
		?>
	</div>
	</div>
	</div>
		<?php
		if ( $this->is_paging ) {
			  ob_start();
			  dima_pagination( $wp_query );
			  $pagination = ob_get_contents();
			  ob_get_clean();
			  echo $pagination;
		}
		wp_reset_query();

	}

	function minimalslide( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {
		$animation_data  = '';
		$animation_data .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';

		wp_enqueue_script( 'slick.min' );

		$js_data      = array(
			'dots'         => ( $POST_ARRAY['dots'] == 'true' ),
			'autoplay'     => ( $POST_ARRAY['auto_play'] == 'false' ),
			'arrows'       => false,
			'infinite'     => ( $POST_ARRAY['loop'] == 'true' ),
			'slidesToShow' => ( $POST_ARRAY['items'] == '' ) ? 1 : $POST_ARRAY['items'],
			'items_phone'  => ( $POST_ARRAY['items_phone'] == '' ) ? 1 : $POST_ARRAY['items_phone'],
			'items_tablet' => ( $POST_ARRAY['items_tablet'] == '' ) ? 2 : $POST_ARRAY['items_tablet'],
			'rtl'          => is_rtl(),
		);
		 $slick_class = '';
		if ( $POST_ARRAY['dark'] ) {
			$slick_class .= 'slick-darck';
		}
		 $data = dima_creat_data_attributes( 'slick_slider', $js_data );

		if ( $POST_ARRAY['items_margin'] ) {
			$slick_class .= ' slick-no-margin';
		} else {
			$slick_class .= ' slick-with-margin';
		}
		?>

	<div class="<?php echo $slick_class . ' clm-' . $POST_ARRAY['column']; ?> dima-minimal-style boxed-blog blog-list" <?php echo "$data"; ?> <?php echo $animation_data; ?>>
		<?php
		if ( $wp_query->have_posts() ) {
			while ( $wp_query->have_posts() ) :
				$wp_query->the_post();
				dima_helper::dima_get_view_with_args( 'partials/contents', 'content', 'minimal-post-grid', $ARG_ARRAY );
			endwhile;
			wp_reset_postdata();
		} else {
			dima_helper::dima_get_view( 'partials/contents', 'content-none' );
		}
		?>
	</div>
		<?php
		if ( $this->is_paging ) {
			  ob_start();
			  dima_pagination( $wp_query );
			  $pagination = ob_get_contents();
			  ob_get_clean();
			  echo $pagination;
		}
		wp_reset_query();

	}

	function slide( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {

		$js_data = array(
			'dots'         => ( $POST_ARRAY['dots'] == 'true' ),
			'autoplay'     => ( $POST_ARRAY['auto_play'] == 'false' ),
			'arrows'       => false,
			'infinite'     => ( $POST_ARRAY['loop'] == 'true' ),
			'slidesToShow' => ( $POST_ARRAY['items'] == '' ) ? 1 : $POST_ARRAY['items'],
			'items_phone'  => ( $POST_ARRAY['items_phone'] == '' ) ? 1 : $POST_ARRAY['items_phone'],
			'items_tablet' => ( $POST_ARRAY['items_tablet'] == '' ) ? 2 : $POST_ARRAY['items_tablet'],
			'rtl'          => is_rtl(),
		);

		 $slick_class = '' . $POST_ARRAY['dark'] . ' ';
		 $data        = dima_creat_data_attributes( 'slick_slider', $js_data );

		if ( $POST_ARRAY['items_margin'] ) {
			$slick_class .= ' slick-no-margin';
		} else {
			$slick_class .= ' slick-with-margin';
		}
		?>
	<div class="<?php echo $slick_class; ?> boxed-blog blog-lis dima-layout-slide" <?php echo "$data"; ?>>
		<?php
		if ( $wp_query->have_posts() ) {
			while ( $wp_query->have_posts() ) :
				$wp_query->the_post();
				 dima_helper::dima_get_view_with_args( 'partials/contents', 'content', get_post_format(), $ARG_ARRAY );
			endwhile;
			wp_reset_postdata();
		} else {
			dima_helper::dima_get_view( 'partials/contents', 'content-none' );
		}
		?>
	</div>
		<?php
		if ( $this->is_paging ) {
			  ob_start();
			  dima_pagination( $wp_query );
			  $pagination = ob_get_contents();
			  ob_get_clean();
			  echo $pagination;
		}
		wp_reset_query();

	}

	function timeline( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {
		$animation_data  = '';
		$animation_data .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';

		?>
  <div class="dima-timeline clearfix dima-timeline-blog boxed-blog blog-list" <?php echo $animation_data; ?>>
  <div class="h-line"></div>
		<?php
		if ( $wp_query->have_posts() ) :
			$i = 2;
			while ( $wp_query->have_posts() ) :
				$wp_query->the_post();
				if ( $i % 2 == 0 ) :
					?>
		<div class="timeline_element_start">
					<?php else : ?>
		  <div class="timeline_element_end">
		<?php endif ?>
				<?php
				dima_helper::dima_get_view_with_args( 'partials/contents', 'content', 'minimal-post', $ARG_ARRAY );
				?>
	  </div>
				<?php
				$i++;
		endwhile;
			wp_reset_postdata();
			?>
	  </div>
			<?php
		  else :
				dima_helper::dima_get_view( 'partials/contents', 'content-none' );
		  endif;
			if ( $this->is_paging ) {
				ob_start();
				dima_pagination( $wp_query );
				$pagination = ob_get_contents();
				ob_get_clean();
				echo $pagination;
			}
			wp_reset_query();
	}

	/**
	 @param $POST_ARRAY
	 @param $wp_query
	 @param $ARG_ARRAY
	 * We use it in popular widget.
	 */
	function small_pos_tslist( $POST_ARRAY, $wp_query, $ARG_ARRAY ) {
		?>
	<div class="vertical-posts-list boxed-blog blog-list">
		<?php
		if ( $wp_query->have_posts() ) {
			?>
		 <ul class="posts-list no-box with-border first">
			<?php
			while ( $wp_query->have_posts() ) :
				$wp_query->the_post();
				dima_helper::dima_get_view_with_args( 'partials/contents', 'content', 'list', $ARG_ARRAY );
				endwhile;
			?>
		 </ul>
			<?php
				wp_reset_postdata();
		} else {
			dima_helper::dima_get_view( 'partials/contents', 'content-none' );
		}
		?>
	</div>
		<?php
		if ( $this->is_paging ) {
			  ob_start();
			  dima_pagination( $wp_query );
			  $pagination = ob_get_contents();
			  ob_get_clean();
			  echo $pagination;
		}
		wp_reset_query();
	}

}
new DIMA_RecentPosts();
