<?php
/**
 * Setup : Include all admin pages
 *
 * @package Dima_Framework
 * @subpackage admin
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 * @copyright    (c) Copyright by PixelDima
 */


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$theme_settings_path = DIMA_TEMPLATE_PATH . '/framework/functions/admin/pixeldima-setup';

// Require Files.
require_once $theme_settings_path . '/framework-notices.php';
require_once $theme_settings_path . '/framework-activate.php';
require_once $theme_settings_path . '/framework-home.php';
require_once $theme_settings_path . '/framework-customizer-backup.php';
require_once $theme_settings_path . '/framework-plugins.php';
require_once $theme_settings_path . '/framework-system-status.php';

/**
 * Setup Menu
 *
 * @return void
 */
function dima_sc_setup_add_menu() {
	$plugins_callback = 'dima_setup_plugins';
	if ( isset( $_GET['tgmpa-install'] ) || isset( $_GET['tgmpa-update'] ) ) {
		remove_action( 'admin_notices', array( $GLOBALS['tgmpa'], 'notices' ) );
		$plugins_callback = array( $GLOBALS['tgmpa'], 'install_plugins_page' );
	}
	add_menu_page( 'NOOR: Home', DIMA_THEME_NAME, 'manage_options', 'pixel-dima-dashboard', 'dima_setup_page_home', null, 3 );
	add_submenu_page( 'pixel-dima-dashboard', '' . DIMA_THEME_NAME . ': Home', esc_html__( 'Help & Guides', 'noor-assistant' ), 'manage_options', 'pixel-dima-dashboard', 'dima_setup_page_home' );
	add_submenu_page( 'pixel-dima-dashboard', '' . DIMA_THEME_NAME . ': License', esc_html__( 'Theme License', 'noor-assistant' ), 'manage_options', 'pixel-dima-license', 'dima_setup_page_activate' );
	add_submenu_page( 'pixel-dima-dashboard', '' . DIMA_THEME_NAME . ': Plugins', esc_html__( 'Install Plugins', 'noor-assistant' ), 'manage_options', 'pixeldima-setup-plugins', $plugins_callback );
	add_submenu_page( 'pixel-dima-dashboard', '' . DIMA_THEME_NAME . ': backup', esc_html__( 'Customizer Backup', 'noor-assistant' ), 'manage_options', 'pixeldima-customizer-backup', 'dima_page_customizer_backup' );
	add_submenu_page( 'pixel-dima-dashboard', '' . DIMA_THEME_NAME . ': cache', esc_html__( 'Delete Cache', 'noor-assistant' ), 'manage_options', 'pixeldima-delete-cache', 'dima_page_delete_cache' );
	if ( ! defined( 'ENVATO_HOSTED_SITE' ) ) {
		add_submenu_page( 'pixel-dima-dashboard', '' . DIMA_THEME_NAME . ': system', esc_html__( 'System Status', 'noor-assistant' ), 'manage_options', 'pixeldima-customizer-system', 'dima_setup_page_system_status' );
	}

}

add_action( 'admin_menu', 'dima_sc_setup_add_menu' );

function dima_sc_get_link_plugins() {
	return admin_url( 'admin.php?page=pixeldima-setup-plugins' );
}
