<?php
/**
 * Functions pertaining to content output.
 *
 * @package global
 * @subpackage 1-content
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

/**
 * @param       $element
 * @param array   $params
 *
 * @return string
 */
function dima_creat_data_attributes( $element, $params = array() ) {
	$data = 'data-dima-element="' . $element . '"';

	if ( ! empty( $params ) ) {
		$params_json = htmlspecialchars( json_encode( $params ), ENT_QUOTES, 'UTF-8' );

		$data .= ' data-dima-params="' . $params_json . '"';
	}

	return $data;
}

/**
 * Undocumented function
 *
 * @param [type] $text
 * @return void
 */
function dima_short_remove_white_space( $text ) {
	$text = preg_replace( '/[\t\n\r\0\x0B]/', '', $text );
	$text = preg_replace( '/([\s])\1+/', ' ', $text );
	$text = trim( $text );

	return $text;
}

/**
 * @param $output
 *
 * @return array
 */
function dima_shortcodes_add_body_class( $output ) {

	$version = str_replace( '.', '_', DIMA_NOUR_ASSISTANT_VERSION );

	$output[] = 'dima-shortcodes-version' . $version;

	return $output;

}

add_filter( 'body_class', 'dima_shortcodes_add_body_class', 9999 );

// Allow shortcodes in widgets.
add_filter( 'widget_text', 'do_shortcode' );

/**
 * Undocumented function
 *
 * @return void
 */
function dima_get_admin_media_post() {
	$id        = vc_post_param( 'content' );
	$back_post = get_post( $id );
	if ( $back_post == '' ) {
		return;
	}
	$post_mime = $back_post->post_mime_type;

	$back_url = $back_icon = $img_name = $img_path = '';
	if ( strpos( $post_mime, 'image/' ) !== false ) {
		$background_url = wp_get_attachment_thumb_url( $id );
		$back_url       = ( $background_url != '' ) ? 'background-image: url(' . $background_url . ');' : '';
		$img_name       = get_the_title( $id );
		$img_path       = $background_url;
	} elseif ( strpos( $post_mime, 'pattern/' ) !== false ) {
		$background_url = wp_get_attachment_thumb_url( $id );
		$back_url       = ( $background_url != '' ) ? 'background-image: url(' . $background_url . ');' : '';
		$img_name       = get_the_title( $id );
		$img_path       = $background_url;
	} elseif ( strpos( $post_mime, 'video/' ) !== false ) {
		$back_icon = '<i class="fa fa-media-play" />';
	} else {
		switch ( $post_mime ) {
			case 'oembed/flickr':
			case 'oembed/instagram':
			case 'oembed/Imgur':
			case 'oembed/photobucket':
				$back_oembed = wp_oembed_get( $back_post->guid );
				preg_match_all( '/src="([^"]*)"/i', $back_oembed, $img_src );
				$back_url = ( isset( $img_src[1][0] ) ) ? 'background-image: url(' . str_replace( '"', '', $img_src[1][0] ) . ');' : '';
				break;

			case 'oembed/vimeo':
			case 'oembed/youtube':
				$back_icon = '<i class="fa fa-social-' . str_replace( 'oembed/', '', $post_mime ) . '" />';
				break;
		}
	}

	echo json_encode(
		array(
			'back_url'  => $back_url,
			'img_name'  => $img_name,
			'img_path'  => $img_path,
			'back_icon' => $back_icon,
			'back_mime' => $post_mime,
		)
	);
	die();
}

add_action( 'wp_ajax_dima_get_media_post', 'dima_get_admin_media_post' );

if ( ! function_exists( 'dima_is_gradient_stop_transparent' ) ) {
	function dima_is_gradient_stop_transparent( $color ) {
		if ( strpos( $color, 'rgba' ) !== false ) {
			$var = $color;
			$var = str_replace( 'rgba(', '', $var );
			$var = str_replace( ')', '', $var );
			$var = explode( ',', $var );

			if ( floatval( $var[3] ) > 0.05 ) {
				return false;
			}

			return true;
		}

		return false;
	}
}

/**
 * Get template parts from shortcodes folder
 *
 * @param string  $slug
 * @param string  $name
 * @param boolean $return
 *
 * @return object
 */
if ( ! function_exists( 'dima_get_shortcode_view' ) ) {
	function dima_get_shortcode_view( $shortcode_name, $name = '', $return = false, $view_params = array() ) {
		if ( $return ) {
			ob_start();
			dima_get_template_part( plugin_dir_path( __DIR__ ) . '/include/shortcodes/' . $shortcode_name . '/' . $name, $view_params );

			return ob_get_clean();
		} else {
			dima_get_template_part( plugin_dir_path( __DIR__ ) . '/include/shortcodes/' . $shortcode_name . '/' . $name, $view_params );
		}

	}
}

/**
 * Like get_template_part() put lets you pass args to the template file
 * Args are available in the tempalte as $view_params array
 *
 * @param string filepart
 * @param mixed wp_args style argument list
 *
 * @since 5.0.0
 * @since 5.9.1 Refactored the function to improve performance.
 */
if ( ! function_exists( 'dima_get_template_part' ) ) {
	function dima_get_template_part( $file, $view_params = array() ) {
		global $post;

		if ( file_exists( $file . '.php' ) ) {

			$file_path = ( $file . '.php' );

		} elseif ( file_exists( $file . '.php' ) ) {

			$file_path = realpath( $file . '.php' );

		}

		wp_parse_args( $view_params );
		ob_start();
		require $file_path;
		$output = ob_get_clean();

		echo $output;

	}
}

if ( ! function_exists( 'dima_add_contact_methods' ) ) :
	function dima_add_contact_methods( $user_contactmethods ) {

		unset( $user_contactmethods['yim'] );
		unset( $user_contactmethods['aim'] );
		unset( $user_contactmethods['jabber'] );

		$user_contactmethods['facebook']   = esc_html__( 'Facebook Profile', 'noor-assistant' );
		$user_contactmethods['twitter']    = esc_html__( 'Twitter Profile', 'noor-assistant' );
		$user_contactmethods['googleplus'] = esc_html__( 'Google+ Profile', 'noor-assistant' );
		$user_contactmethods['linkedin']   = esc_html__( 'Linkedin Profile', 'noor-assistant' );
		$user_contactmethods['instagram']  = esc_html__( 'Instagram Profile', 'noor-assistant' );

		$user_contactmethods['flickr']    = esc_html__( 'Flickr Profile', 'noor-assistant' );
		$user_contactmethods['youtube']   = esc_html__( 'YouTube Profile', 'noor-assistant' );
		$user_contactmethods['pinterest'] = esc_html__( 'Pinterest Profile', 'noor-assistant' );
		$user_contactmethods['behance']   = esc_html__( 'Behance Profile', 'noor-assistant' );
		$user_contactmethods['dribbble']  = esc_html__( 'Dribbble Profile', 'noor-assistant' );

		return $user_contactmethods;

	}

	add_filter( 'user_contactmethods', 'dima_add_contact_methods' );
endif;

if ( dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_remove_ver_params' ) ) ) {
	/**
	 * Remove Query Strings From Static Resources.
	 *
	 * @param $src
	 *
	 * @return mixed
	 */
	function dima_remove_script_version( $src ) {
		$parts = explode( '?ver', $src );

		return $parts[0];
	}

	function dima_remove_script_version_and( $src ) {
		$parts = explode( '&ver', $src );

		return $parts[0];
	}

	if ( ! is_admin() ) {
		 add_filter( 'script_loader_src', 'dima_remove_script_version', 15, 1 );
		 add_filter( 'style_loader_src', 'dima_remove_script_version', 15, 1 );
		 add_filter( 'script_loader_src', 'dima_remove_script_version_and', 15, 1 );
		 add_filter( 'style_loader_src', 'dima_remove_script_version_and', 15, 1 );
	}
}

/**
 * Undocumented function
 *
 * @param [type] $wp_admin_bar
 * @return void
 */
function dima_modify_admin_bar( $wp_admin_bar ) {

	list( $plugin_updates, $updates_notification ) = dima_get_plugin_updates_requires();

	$icon = '<i class="wp-menu-image dashicons-before dashicons-admin-generic dima-admin-bar-menu"></i>';

	// Add Admin Bar Menu Links.
	$wp_admin_bar->add_menu(
		array(
			'id'    => 'dima-menu-options',
			'title' => $icon . wp_get_theme() . $updates_notification,
			'href'  => is_admin() ? home_url() : admin_url( 'admin.php?page=dima_options' ),
			'meta'  => array( 'target' => is_admin() ? '_blank' : '_self' ),
		)
	);

	$wp_admin_bar->add_menu(
		array(
			'parent' => 'dima-menu-options',
			'id'     => 'dima-menu-options-theme',
			'title'  => esc_html__( 'Help & Guides', 'noor' ),
			'href'   => admin_url( 'admin.php?page=pixel-dima-dashboard' ),
		)
	);

	$wp_admin_bar->add_menu(
		array(
			'parent' => 'dima-menu-options',
			'id'     => 'dima-custom-css',
			'title'  => esc_html__( 'Install Plugins', 'noor' ),
			'href'   => admin_url( 'admin.php?page=pixeldima-setup-plugins' ),
		)
	);

	if ( $plugin_updates > 0 ) {
		$wp_admin_bar->add_menu(
			array(
				'parent' => 'dima-menu-options',
				'id'     => 'install-plugins',
				'title'  => 'Update Plugins' . $updates_notification,
				'href'   => admin_url( 'themes.php?page=pixeldima-setup-plugins' ),
			)
		);
	}

	$wp_admin_bar->add_menu(
		array(
			'parent' => 'dima-menu-options',
			'id'     => 'dima-customizer-content',
			'title'  => 'Customizer Backup',
			'href'   => admin_url( 'admin.php?page=pixeldima-customizer-backup' ),
		)
	);

	$wp_admin_bar->add_menu(
		array(
			'parent' => 'dima-menu-options',
			'id'     => 'dima-help',
			'title'  => 'System Status',
			'href'   => admin_url( 'admin.php?page=pixeldima-customizer-system' ),
		)
	);
	$wp_admin_bar->add_menu(
		array(
			'parent' => 'dima-menu-options',
			'id'     => 'setup-wizard',
			'title'  => 'Setup Wizard',
			'href'   => admin_url( 'admin.php?page=dima' ),
		)
	);
}

add_action( 'admin_bar_menu', 'dima_modify_admin_bar', 10000 );

if ( ! function_exists( 'dima_login_form' ) ) {
	/**
	 * Login Form
	 *
	 * @param integer $login_only
	 * @return void
	 */
	function dima_login_form( $login_only = 0 ) {
		global $user_ID, $user_identity;

		if ( $user_ID ) : ?>
			<?php if ( empty( $login_only ) ) : ?>
			<div id="dima-user-login">
				<span class="dima-author-avatar">
					<?php echo get_avatar( $user_ID, $size = '90' ); ?>
				</span>
				<div class="dima-user-login-content">
					<h5 class="welcome-text"><?php echo esc_html__( 'Welcome', 'noor' ); ?>
						: <?php echo esc_attr( $user_identity ); ?></h5>
					<ul>
						<li>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>/wp-admin/"><?php echo esc_html__( 'Dashboard', 'noor' ); ?> </a>
						</li>
						<li>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>/wp-admin/profile.php"><?php echo esc_html__( 'Your Profile', 'noor' ); ?> </a>
						</li>
						<li>
							<a href="<?php echo wp_logout_url(); ?>"><?php echo esc_html__( 'Logout', 'noor' ); ?> </a>
						</li>
					</ul>
				</div>
			</div>
		<?php endif; ?>
		<?php else : ?>
		<div id="dima-login-form">
			<form name="loginform" id="loginform" action="<?php echo esc_url( home_url( '/' ) ); ?>/wp-login.php"
				  method="post"
				  class="login">
				<p id="form-row-wide">
					<input type="text" name="log" id="log"
						   value="<?php echo esc_html__( 'Username', 'noor' ); ?>"
						   onfocus="if (this.value == ' <?php echo esc_html__( 'Username', 'noor' ); ?>') {this.value = '';}"
						   onblur="if (this.value == '') {this.value = '<?php echo esc_html__( 'Username', 'noor' ); ?>';}"/>
				</p>
				<p id="form-row-wide">
					<input type="password" name="pwd" id="pwd"
						   value="<?php echo esc_html__( 'Password', 'noor' ); ?>"
						   onfocus="if (this.value == '<?php echo esc_html__( 'Password', 'noor' ); ?>') {this.value = '';}"
						   onblur="if (this.value == '') {this.value = '<?php echo esc_html__( 'Password', 'noor' ); ?>';}"/>
				</p>
				<input type="submit" name="submit" value="<?php echo esc_html__( 'Login', 'noor' ); ?>"
					   class="button"/>
				<label for="rememberme"><input name="rememberme" id="login-rememberme" type="checkbox"
											   checked="checked"
											   value="forever"/> <?php echo esc_html__( 'Remember Me', 'noor' ); ?>
				</label>
				<input type="hidden" name="redirect_to"
					   value="<?php echo esc_url( $_SERVER['REQUEST_URI'] ); ?>"/>
			</form>
			<ul class="login-links">
				<?php
				if ( get_option( 'users_can_register' ) ) :
					?>
					<?php echo wp_register(); ?><?php endif; ?>
				<li>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>/wp-login.php?action=lostpassword"><?php echo esc_html__( 'Lost your password?', 'noor' ); ?></a>
				</li>
			</ul>
		</div>
			<?php
		endif;
	}
}

/**
 * Return list of all posts tags
 *
 * @return array
 */
function dima_get_blog_tag_list() {
	$is_admin     = is_admin();
	$blog_types   = ( $is_admin ) ? get_tags() : array( 'All' => '' );
	$blog_options = array( 'All' => '' );

	if ( $is_admin ) {
		foreach ( $blog_types as $type ) {
			if ( isset( $type->name ) && isset( $type->slug ) ) {
				$blog_options[ htmlspecialchars( $type->name ) ] = htmlspecialchars( $type->slug );
			}
		}
	} else {
		$blog_options['All'] = '';
	}
	return $blog_options;
}
/**
 * Return list of all posts category
 *
 * @return array
 */
function dima_get_blog_category_list() {
	$is_admin     = is_admin();
	$blog_types   = ( $is_admin ) ? get_categories() : array( 'All' => '' );
	$blog_options = array( 'All' => '' );

	if ( $is_admin ) {
		foreach ( $blog_types as $type ) {
			if ( isset( $type->name ) && isset( $type->slug ) ) {
				$blog_options[ htmlspecialchars( $type->name ) ] = htmlspecialchars( $type->slug );
			}
		}
	} else {
		$blog_options['All'] = '';
	}
	return $blog_options;
}
/**
 * Return list of all posts category
 *
 * @return array
 */


 /**
  * Return list of all texonmy category
  *
  * @param string $term
  * @return void
  */
function dima_get_terms_list( $term = 'portfolio-category' ) {
	$is_admin     = is_admin();
	$terms        = get_terms( $term );
	$term_types   = ( $is_admin ) ? $terms : array( 'All' => '' );
	$term_options = array( 'All' => '' );

	if ( $is_admin && ! is_wp_error( $terms ) ) {
		if ( $term_types && ! is_wp_error( $terms ) ) {
			foreach ( $terms as $term ) {
				$term_options[ $term->name ] = $term->slug;
			}
		}
	} else {
		$term_options['All'] = '';
	}

	return $term_options;
}

/**
 * Return list of all products category
 *
 * @return array
 */
function dima_get_woo_category_list() {
	$is_admin = is_admin();

	$woo_args = array(
		'taxonomy' => 'product_cat',
	);

	global $woocommerce;

	if ( $woocommerce ) {

		$woo_types   = ( $is_admin ) ? get_categories( $woo_args ) : array( 'All' => '' );
		$woo_options = array( 'All' => '' );

		if ( $is_admin ) {
			foreach ( $woo_types as $type ) {
				$woo_options[ $type->name ] = $type->slug;
			}
		} else {
			$woo_options['All'] = '';
		}
	} else {
		$woo_options['All'] = '';
	}

	return $woo_options;
}
