<?php



// Only load shortcode logic on front when needed.
$is_admin = is_admin();


if ( function_exists( 'vc_add_shortcode_param' ) ) {
	/**
	 * Create multi dropdown param type.
	 *
	 * @since 1.0
	 */
	vc_add_shortcode_param( 'dropdown_multi', 'dropdown_multi_settings_field' );
	function dropdown_multi_settings_field( $param, $value ) {

		 $param_line  = '';
		 $param_line .= '<select multiple name="' . esc_attr( $param['param_name'] ) . '" class="wpb_vc_param_value wpb-input wpb-select ' . esc_attr( $param['param_name'] ) . ' ' . esc_attr( $param['type'] ) . '">';
		foreach ( $param['value'] as $text_val => $val ) {
			if ( is_numeric( $text_val ) && ( is_string( $val ) || is_numeric( $val ) ) ) {
				$text_val = $val;
			}

			$selected = '';

			if ( ! is_array( $value ) ) {
				$param_value_arr = explode( ',', $value );
			} else {
				$param_value_arr = $value;
			}

			if ( $value !== '' && in_array( $val, $param_value_arr ) ) {
				$selected = ' selected="selected"';
			}
			$param_line .= '<option class="' . $val . '" value="' . $val . '"' . $selected . '>' . $text_val . '</option>';
		}
		$param_line .= '</select>';

		return $param_line;
	}

	/**
	 * Create full width section BG image param.
	 *
	 * @since 1.0
	 */
	vc_add_shortcode_param( 'fws_image', 'fws_image_settings_field' );
	function fws_image_settings_field( $param, $value ) {
			$param_line  = '';
			$param_line .= '<input type="hidden" class="wpb_vc_param_value gallery_widget_attached_images_ids ' . esc_attr( $param['param_name'] ) . ' ' . esc_attr( $param['type'] ) . '" name="' . esc_attr( $param['param_name'] ) . '" value="' . esc_attr( $value ) . '"/>';

			$param_line .= '<div class="gallery_widget_attached_images">';
			$param_line .= '<ul class="gallery_widget_attached_images_list">';

		if ( strpos( $value, 'http://' ) !== false || strpos( $value, 'https://' ) !== false ) {
			$param_line .= '<li class="added">
					<img src="' . esc_attr( $value ) . '" />
					<a href="#" class="vc_icon-remove"><i class="vc-composer-icon vc-c-icon-close"></i></a>
				</li>';
		} else {
			$param_line .= ( $value != '' ) ? fieldAttachedImages( explode( ',', esc_attr( $value ) ) ) : '';
		}

			$param_line .= '</ul>';
			$param_line .= '</div>';
			$param_line .= '<div class="gallery_widget_site_images">';
			$param_line .= '</div>';
			$param_line .= '<a class="gallery_widget_add_images" href="#" use-single="true" title="' . esc_html__( 'Add image', 'js_composer' ) . '">' . esc_html__( 'Add image', 'js_composer' ) . '</a>';// class: button

			return $param_line;
	}

	/**
	 * Create radio image param.
	 *
	 * @since 1.0
	 */
	vc_add_shortcode_param( 'dima_radio_image', 'dima_radio_images_settings_field' );
	function dima_radio_images_settings_field( $param, $value ) {
			$rnd_id  = uniqid();
			$options = isset( $param['options'] ) ? $param['options'] : '';

			$param_line  = '';
			$param_line .= '<input type="hidden" id="dima-radio-image-' . $rnd_id . '" class="wpb_vc_param_value ' . esc_attr( $param['param_name'] ) . ' ' . esc_attr( $param['type'] ) . '" name="' . esc_attr( $param['param_name'] ) . '" value="' . esc_attr( $value ) . '"/>';
			$param_line .= '<div class="dima-radio-image" data-grp-id="' . $rnd_id . '">';
			$param_line .= '<ul class="dima_radio_images_list">';

		foreach ( $options as $k => $v ) {

			foreach ( $v as $name => $image_src ) {

				if ( $value == $k ) {
					$checked = 'checked';
				} else {
					$checked = '';
				}

				$param_line .= '<li><label>
						<input type="radio" class="n_radio_image_val" value="' . $k . '" name="n_radio_image_' . $rnd_id . '" ' . $checked . ' />
						<span class="n_radio_image_src"><img src="' . $image_src . '" alt="' . $name . '" /></span>
						<span class="n_radio_image_title">' . $name . '</span>
					</label></li>';
			}
		}

			$param_line .= '</ul>';
			$param_line .= '</div>';

			return $param_line;
	}


	/**
	 * Create hotspot image preview param.
	 *
	 * @since 1.0
	 */
	vc_add_shortcode_param( 'hotspot_image_preview', 'hotspot_image_preview_field' );
	function hotspot_image_preview_field( $settings, $value ) {

		$image_output = null;
		if ( ! empty( $value ) ) {
			$image_output = '<img src="' . esc_attr( $value ) . '" alt="preview" />';
		}

		return '<div id="dima_image_with_hotspots_preview"><input name="' . esc_attr( $settings['param_name'] ) . '" type="hidden" class="wpb_vc_param_value ' . esc_attr( $settings['param_name'] ) . '" value="' . $value . '" /> ' . $image_output . '</div>';
	}
}
