<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
* Add-on Name: dima woo
*/

class WPBakeryShortCode_Woo extends WPBakeryShortCode {
}

$category_list = dima_get_woo_category_list();
/**
 * Woo
 */
vc_map(
	array(
		'base'        => 'dima_woo',
		'name'        => esc_html__( 'Noor Products', 'noor-assistant' ),
		'weight'      => 490,
		'class'       => 'dima-vc-element dima-vc-element-portfolio',
		'icon'        => 'shopping',
		'category'    => esc_html__( 'PixelDima', 'noor-assistant' ),
		'description' => esc_html__( 'Show multiple products', 'noor-assistant' ),
		'params'      => array(
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Product Type', 'noor-assistant' ),
				'param_name'  => 'product_type',
				'value'       => array(
					esc_html__( 'All', 'noor-assistant' ) => 'all',
					esc_html__( 'Sale Only', 'noor-assistant' ) => 'sale',
					esc_html__( 'Featured Only', 'noor-assistant' ) => 'featured',
					esc_html__( 'Best Selling Only', 'noor-assistant' ) => 'best_selling',
				),
				'save_always' => true,
				'description' => esc_html__( 'Please select the type of products you would like to display.', 'noor-assistant' ),
			),

			array(
				'param_name'  => 'woo_style',
				'heading'     => esc_html__( 'Product Style', 'noor-assistant' ),
				'description' => esc_html__( 'Choose your style.', 'noor-assistant' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'value'       => array(
					esc_html__( '- Select Option -', 'noor-assistant' ) => '',
					esc_html__( 'Grid', 'noor-assistant' ) => 'grid',
					esc_html__( 'List', 'noor-assistant' ) => 'list_style',
					esc_html__( 'Slide', 'noor-assistant' ) => 'slide',
				),
			),
			array(
				'param_name'  => 'woo_elm_hover',
				'heading'     => esc_html__( 'Element hover', 'noor-assistant' ),
				'description' => esc_html__( 'Select the element hover style', 'noor-assistant' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'dependency'  => array(
					'element' => 'woo_style',
					'value'   => array( 'grid', 'list_style' ),
				),
				'value'       => array(
					esc_html__( '- Select Option -', 'noor-assistant' ) => '',
					esc_html__( 'default', 'noor-assistant' )           => '',
					esc_html__( 'Inside', 'noor-assistant' )            => 'op_vc_inside',
				),
			),
			array(
				'param_name'  => 'dark',
				'heading'     => esc_html__( 'Dark background', 'noor-assistant' ),
				'description' => esc_html__( 'Check if you use dark background section', 'noor-assistant' ),
				'type'        => 'checkbox',
				'holder'      => 'div',
				'dependency'  => array(
					'element' => 'woo_style',
					'value'   => array( 'slide' ),
				),
				'value'       => array(
					'' => 'false',
				),
			),
			array(
				'param_name'  => 'auto_play',
				'heading'     => esc_html__( 'AutoPlay', 'noor-assistant' ),
				'description' => esc_html__( 'Check to animate the slides automatically', 'noor-assistant' ),
				'type'        => 'checkbox',
				'holder'      => 'div',
				'dependency'  => array(
					'element' => 'woo_style',
					'value'   => array( 'slide' ),
				),
				'value'       => array(
					'' => 'true',
				),
			),
			array(
				'param_name'  => 'slide_pagination',
				'heading'     => esc_html__( 'Hide Slider Bullets', 'noor-assistant' ),
				'description' => esc_html__( 'Check to remove slider Bullets', 'noor-assistant' ),
				'type'        => 'checkbox',
				'holder'      => 'div',
				'dependency'  => array(
					'element' => 'woo_style',
					'value'   => array( 'slide' ),
				),
				'value'       => array(
					'' => 'false',
				),
			),
			array(
				'param_name'  => 'count',
				'heading'     => esc_html__( 'Products Count', 'noor-assistant' ),
				'description' => esc_html__( 'Select how many products display.', 'noor-assistant' ),
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '6',
			),
			array(
				'param_name'  => 'column',
				'heading'     => esc_html__( 'Product Columns', 'noor-assistant' ),
				'description' => esc_html__( 'Select columns number', 'noor-assistant' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'value'       => array(
					esc_html__( '- Select Option -', 'noor-assistant' ) => '2',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				),
			),

			array(
				'type'       => 'dima_radio_advanced',
				'heading'    => esc_html__( 'Show Filters', 'noor-assistant' ),
				'param_name' => 'filters',
				'value'      => 'no',
				'dependency' => array(
					'element' => 'woo_style',
					'value'   => array( 'grid' ),
				),
				'options'    => array(
					esc_html__( 'Yes', 'noor-assistant' ) => 'yes',
					esc_html__( 'Yes without -All-', 'noor-assistant' ) => 'yes-all',
					esc_html__( 'No', 'noor-assistant' )  => 'no',
				),
			),

			array(
				'param_name'  => 'category',
				'heading'     => esc_html__( 'Category', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'dropdown_multi',
				'value'       => $category_list,
				'holder'      => 'div',
			),

			array(
				'param_name'  => 'paging',
				'heading'     => esc_html__( 'Pagination', 'noor-assistant' ),
				'description' => esc_html__( 'Check to activate pagination', 'noor-assistant' ),
				'type'        => 'checkbox',
				'holder'      => 'div',
				'dependency'  => array(
					'element' => 'woo_style',
					'value'   => array( 'list_style', 'grid' ),
				),
				'value'       => array(
					'' => 'true',
				),
			),
			array(
				'param_name'  => 'orderby',
				'heading'     => esc_html__( 'Order By', 'noor-assistant' ),
				'description' => sprintf( __( 'Select how to sort retrieved products. More at %s.', 'noor-assistant' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'value'       => array(
					esc_html__( '- Select Option -', 'noor-assistant' ) => '',
					esc_html__( 'Date', 'noor-assistant' ) => 'date',
					esc_html__( 'ID', 'noor-assistant' )   => 'ID',
					esc_html__( 'Author', 'noor-assistant' ) => 'author',
					esc_html__( 'Title', 'noor-assistant' ) => 'title',
					esc_html__( 'Modified', 'noor-assistant' ) => 'modified',
					esc_html__( 'Random', 'noor-assistant' ) => 'rand',
					esc_html__( 'Comment count', 'noor-assistant' ) => 'comment_count',
					esc_html__( 'Menu order', 'noor-assistant' ) => 'menu_order',
				),
			),
			array(
				'param_name'  => 'order',
				'heading'     => esc_html__( 'Sort order', 'noor-assistant' ),
				'description' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'noor-assistant' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'value'       => array(
					esc_html__( '- Select Option -', 'noor-assistant' ) => '',
					esc_html__( 'ASC ', 'noor-assistant' ) => 'asc',
					esc_html__( 'DESC', 'noor-assistant' ) => 'desc',
				),
			),

			array(
				'param_name'  => 'post_class',
				'heading'     => esc_html__( 'Class', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique class name.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name' => 'tutorials',
				'type'       => 'dima_doc_link_param',
				'heading'    => '<span class="tippy dima-help dima-vc-toolip">' . dima_get_svg_icon( 'ic_help' )
								 . '<span class="dima-vc-tooltip-text">'
								 . esc_html__( 'Video tutorial and theme documentation article', 'noor-assistant' ) . '</span></span>'
								 . esc_html__( 'Tutorial', 'noor-assistant' ),
				'doc_link'   => '',
				'video_link' => 'https://www.youtube.com/watch?v=oaz-w7908VY',
				// 'doc_example' => 'https://noor.pixeldima.com/shop-three-columns-right-sidebar/',
			),
		),
	)
);
