<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
* Add-on Name: List
*/

class WPBakeryShortCode_List extends WPBakeryShortCodesContainer {
}

/**
 * List
 */
vc_map(
	array(
		'base'            => 'list',
		'name'            => esc_html__( 'List', 'noor-assistant' ),
		'weight'          => 780,
		'class'           => 'dima-vc-element dima-vc-element-list',
		'icon'            => 'dima-list',
		'category'        => esc_html__( 'PixelDima', 'noor-assistant' ),
		'description'     => esc_html__( 'Include a list in your content', 'noor-assistant' ),
		'as_parent'       => array( 'only' => 'list_item' ),
		'content_element' => true,
		'js_view'         => 'VcColumnView',
		'params'          => array(
			array(
				'param_name'  => 'type',
				'heading'     => esc_html__( 'List Style', 'noor-assistant' ),
				'description' => esc_html__( 'Choose icon for list item', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'dropdown',
				'value'       => array(
					esc_html__( 'Inherit', 'noor-assistant' ) => 'circle_list',
					esc_html__( 'Star', 'noor-assistant' ) => 'stars',
					esc_html__( 'Angle', 'noor-assistant' ) => 'angle',
					esc_html__( 'Check', 'noor-assistant' ) => 'check',
					esc_html__( 'Thumb-tack', 'noor-assistant' ) => 'thumb-tack',
				),
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'id',
				'heading'     => esc_html__( 'ID', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique ID.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'class',
				'heading'     => esc_html__( 'Class', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique class name.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'style',
				'heading'     => esc_html__( 'Style', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter inline CSS.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			// **************Animation***************//
			array(
				'param_name'  => 'animation',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'Animation', 'noor-assistant' ),
				'description' => esc_html__( 'Select the type of animation you want to use.', 'noor-assistant' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'value'       => $dima_vc->dima_animate_list_velocity,
			),

			array(
				'param_name'  => 'delay',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'Delay Animation', 'noor-assistant' ),
				'description' => esc_html__( 'Set when the animation start (milliseconds)', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '',
			),

			array(
				'param_name'  => 'delay_duration',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'duration Animation', 'noor-assistant' ),
				'description' => esc_html__( 'Animation duration of each element  (milliseconds).', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '',
			),

			array(
				'param_name'  => 'delay_offset',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'Delay Animation Offset', 'noor-assistant' ),
				'description' => esc_html__( 'Set the number ( px,%..) from the top of the viewport where the animation start.', 'noor-assistant' ) . "<a href='http://imakewebthings.com/waypoints/api/offset-option/' target='_blank' >" . esc_html__( 'Read More', 'noor-assistant' ) . '</a>',
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '',
			),
			// **************!Animation***************//
			array(
				'param_name'  => 'tutorials',
				'type'        => 'dima_doc_link_param',
				'heading'     => '<span class="tippy dima-help dima-vc-toolip">' . dima_get_svg_icon( 'ic_help' )
								 . '<span class="dima-vc-tooltip-text">'
								 . esc_html__( 'Video tutorial and theme documentation article', 'noor-assistant' ) . '</span></span>'
								 . esc_html__( 'Tutorial', 'noor-assistant' ),
				'doc_link'    => '',
				'video_link'  => 'https://www.youtube.com/watch?v=WI2_gJgjeE0',
				//'doc_example' => 'https://noor.pixeldima.com/lists/',
			),
		),
	)
);

/**
 * list item
 */
vc_map(
	array(
		'base'            => 'list_item',
		'name'            => esc_html__( 'List Item', 'noor-assistant' ),
		'weight'          => 770,
		'class'           => 'dima-vc-element dima-vc-element-protect',
		'icon'            => 'icon-list',
		'category'        => esc_html__( 'PixelDima', 'noor-assistant' ),
		'description'     => esc_html__( 'Include an icon list item in your icon list', 'noor-assistant' ),
		'as_child'        => array( 'only' => 'list' ),
		'content_element' => true,
		'params'          => array(
			array(
				'param_name'  => 'content',
				'heading'     => esc_html__( 'Text', 'noor-assistant' ),
				'description' => esc_html__( 'Enter your text.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textarea_html',
				'holder'      => 'div',
				'value'       => '',
			),
			array(
				'param_name'  => 'id',
				'heading'     => esc_html__( 'ID', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique ID.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'class',
				'heading'     => esc_html__( 'Class', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique class name.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'style',
				'heading'     => esc_html__( 'Style', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter inline CSS.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'tutorials',
				'type'        => 'dima_doc_link_param',
				'heading'     => '<span class="tippy dima-help dima-vc-toolip">' . dima_get_svg_icon( 'ic_help' )
								 . '<span class="dima-vc-tooltip-text">'
								 . esc_html__( 'Video tutorial and theme documentation article', 'noor-assistant' ) . '</span></span>'
								 . esc_html__( 'Tutorial', 'noor-assistant' ),
				'doc_link'    => '',
				'video_link'  => 'https://youtu.be/WI2_gJgjeE0?t=94',
				//'doc_example' => 'https://noor.pixeldima.com/lists/',
			),

		),
	)
);
