<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPBakeryShortCode_Dima_category_grid extends WPBakeryShortCode {
}


$post_types   = array( 'Posts' => 'posts' );
$blog_options = dima_get_blog_category_list();
global $woocommerce;
if ( $woocommerce ) {
	$post_types['Products'] = 'products';
}
$woo_options = dima_get_woo_category_list();
vc_map(
	array(
		'name'        => __( 'Category Grid', 'noor-assistant' ),
		'base'        => 'dima_category_grid',
		'icon'        => 'section_block',
		'category'    => esc_html__( 'PixelDima', 'noor-assistant' ),
		'description' => esc_html__( 'Show categories in a stylish grid', 'noor-assistant' ),
		'params'      => array(
			array(
				'type'        => 'dropdown',
				'heading'     => __( 'Post Type', 'noor-assistant' ),
				'param_name'  => 'post_type',
				'value'       => $post_types,
				'save_always' => true,
				'admin_label' => true,
				'description' => esc_html__( 'Select the post type you wish to display the categories from.', 'noor-assistant' ),
			),
			array(
				'type'        => 'dropdown_multi',
				'heading'     => esc_html__( 'Product Categories', 'noor-assistant' ),
				'param_name'  => 'product_category',
				'admin_label' => true,
				'value'       => $woo_options,
				'save_always' => true,
				'dependency'  => array(
					'element' => 'post_type',
					'value'   => 'products',
				),
				'description' => esc_html__( 'Please select the categories you would like to display in the grid. You can select multiple categories too (ctrl + click on PC and command + click on Mac).', 'noor-assistant' ),
			),
			array(
				'type'        => 'dropdown_multi',
				'heading'     => esc_html__( 'Blog Categories', 'noor-assistant' ),
				'param_name'  => 'blog_category',
				'admin_label' => true,
				'value'       => $blog_options,
				'save_always' => true,
				'dependency'  => array(
					'element' => 'post_type',
					'value'   => 'posts',
				),
				'description' => esc_html__( 'Please select the categories you would like to display for your blog. You can select multiple categories too (ctrl + click on PC and command + click on Mac).', 'noor-assistant' ),
			),


			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Text Content Alignment', 'noor-assistant' ),
				'param_name'  => 'text_content_alignment',
				'value'       => array(
					esc_html__( 'Top Left', 'noor-assistant' ) => 'top_left',
					esc_html__( 'Top Middle', 'noor-assistant' ) => 'top_middle',
					esc_html__( 'Top Right', 'noor-assistant' ) => 'top_right',
					esc_html__( 'Middle', 'noor-assistant' )   => 'middle',
					esc_html__( 'Bottom Left', 'noor-assistant' ) => 'bottom_left',
					esc_html__( 'Bottom Middle', 'noor-assistant' ) => 'bottom_middle',
					esc_html__( 'Bottom Right', 'noor-assistant' ) => 'bottom_right',
				),
				'save_always' => true,
				'description' => esc_html__( 'Select the alignment of your text content.', 'noor-assistant' ),
			),

			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Subtext', 'noor-assistant' ),
				'param_name'  => 'subtext',
				'value'       => array(
					esc_html__( 'None', 'noor-assistant' ) => 'none',
					esc_html__( 'Category Item Count', 'noor-assistant' ) => 'cat_item_count',
					esc_html__( 'Custom', 'noor-assistant' ) => 'custom',
				),
				'save_always' => true,
				'description' => esc_html__( 'Select what will display under the category names.', 'noor-assistant' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Text Content', 'noor-assistant' ),
				'param_name'  => 'custom_subtext',
				'admin_label' => true,
				'dependency'  => array(
					'element' => 'subtext',
					'value'   => 'custom',
				),
				'description' => esc_html__( 'Enter custom text that will be shown below each category title', 'noor-assistant' ),
			),


			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Columns', 'noor-assistant' ),
				'param_name'  => 'columns',
				'value'       => array(
					'4' => '4',
					'3' => '3',
					'2' => '2',
					'1' => '1',
				),
				'std'         => '4',
				'save_always' => true,
			),

			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Grid Item Spacing', 'noor-assistant' ),
				'param_name'  => 'grid_item_spacing',
				'save_always' => true,
				'value'       => array(
					'None' => 'none',
					'1px'  => '1px',
					'5px'  => '5px',
					'10px' => '10px',
					'15px' => '15px',
					'25px' => '25px',
				),
				'description' => esc_html__( 'Please select the spacing you would like between your items. ', 'noor-assistant' ),
			),

			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Masonry Layout', 'noor-assistant' ),
				'param_name'  => 'enable_masonry',
				'description' => esc_html__( 'This will allow your portfolio items to display in a masonry layout as opposed to a fixed grid', 'noor-assistant' ),
				'value'       => array( esc_html__( 'Yes, please', 'noor-assistant' ) => 'yes' ),
			),


			array(
				'type'        => 'colorpicker',
				'class'       => '',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'heading'     => 'Color Overlay',
				'param_name'  => 'color_overlay',
				'value'       => '',
				'description' => esc_html__( 'Use this to set a BG color that will be overlaid on your grid items', 'noor-assistant' ),
			),

			array(
				'type'        => 'dropdown',
				'class'       => '',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'save_always' => true,
				'heading'     => esc_html__( 'Color Overlay Opacity', 'noor-assistant' ),
				'param_name'  => 'color_overlay_opacity',
				'value'       => array(
					'0'  => '0',
					'25' => '25',
					'50' => '50',
					'75' => '75',
					'1'  => '1',
				),
				'std'         => '25',
			),

			array(
				'type'        => 'dropdown',
				'class'       => '',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'save_always' => true,
				'heading'     => esc_html__( 'Color Overlay Hover Opacity', 'noor-assistant' ),
				'param_name'  => 'color_overlay_hover_opacity',
				'value'       => array(
					'0'  => '0',
					'25' => '25',
					'50' => '50',
					'75' => '75',
					'1'  => '1',
				),
				'std'         => '50',
			),


			array(
				'type'        => 'dropdown',
				'class'       => '',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'save_always' => true,
				'heading'     => esc_html__( 'Text Color', 'noor-assistant' ),
				'param_name'  => 'text_color',
				'value'       => array(
					'Dark'  => 'dark',
					'Light' => 'light',
				),
				'std'         => 'light',
			),

			array(
				'type'        => 'dropdown',
				'class'       => '',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'save_always' => true,
				'heading'     => 'Text Color Hover',
				'param_name'  => 'text_color_hover',
				'value'       => array(
					'Dark'  => 'dark',
					'Light' => 'light',
				),
				'std'         => 'light',
			),

			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Shadow on Hover', 'noor-assistant' ),
				'param_name'  => 'shadow_on_hover',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'description' => esc_html__( 'This will add a shadow effect on hover to your grid items', 'noor-assistant' ),
				'value'       => array( esc_html__( 'Yes, please', 'noor-assistant' ) => 'yes' ),
			),

			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Subtext Visibility', 'noor-assistant' ),
				'param_name'  => 'subtext_visibility',
				'group'       => esc_html__( 'Style', 'noor-assistant' ),
				'value'       => array(
					'Always Shown'   => 'always',
					'Shown on Hover' => 'on_hover',
				),
				'save_always' => true,
			),


		),
	)
);
