<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
* Add-on Name: Custom heading
*/

class WPBakeryShortCode_Custom_Heading extends WPBakeryShortCode {
}

/**
 * Custom heading
 */
vc_map(
	array(
		'base'        => 'custom_heading',
		'name'        => esc_html__( 'Custom heading', 'noor-assistant' ),
		'weight'      => 530,
		'class'       => 'dima-vc-element dima-vc-element-heading',
		'icon'        => 'heading',
		'category'    => esc_html__( 'PixelDima', 'noor-assistant' ),
		'description' => esc_html__( 'Include a custom headline in your content', 'noor-assistant' ),
		'params'      => array(

			array(
				'type'             => 'dima_heading_vc',
				'text'             => esc_html__( 'Heading', 'noor-assistant' ),
				'param_name'       => 'sizing',
				'edit_field_class' => 'dima-heading-param-wrapper no-top-margin vc_column vc_col-sm-12',
			),

			array(
				'param_name'  => 'content',
				'heading'     => esc_html__( 'Text', 'noor-assistant' ),
				'description' => esc_html__( 'Enter your text', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textarea_html',
				'holder'      => 'div',
				'value'       => '',
			),
			array(
				'param_name'  => 'level',
				'heading'     => esc_html__( 'Heading Level', 'noor-assistant' ),
				'description' => esc_html__( 'Select which level to use for your heading.', 'noor-assistant' ),
				'type'        => 'dropdown',
				'value'       => array(
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
				),
			),

			array(
				'type'             => 'dima_heading_vc',
				'text'             => esc_html__( 'Style', 'noor-assistant' ),
				'param_name'       => 'sizing',
				'edit_field_class' => 'dima-heading-param-wrapper no-top-margin vc_column vc_col-sm-12',
			),

			array(
				'type'       => 'colorpicker',
				'heading'    => __( 'Heading Color', 'noor-assistant' ),
				'param_name' => 'dima_heading_color',
				'value'      => '',
			),
			array(
				'type'       => 'colorpicker',
				'heading'    => __( 'Heading Hover Color', 'noor-assistant' ),
				'param_name' => 'dima_hover_heading_color',
				'value'      => '',
			),

			array(
				'param_name'  => 'float',
				'heading'     => esc_html__( 'Heading Alignment', 'noor-assistant' ),
				'description' => esc_html__( 'Select heading alignment.', 'noor-assistant' ),
				'type'        => 'dropdown',
				'value'       => array(
					'Start'  => 'start',
					'Center' => 'center',
					'End'    => 'end',
				),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Icons library', 'noor-assistant' ),
				'value'       => array(
					esc_html__( 'Font Awesome', 'noor-assistant' )                                     => 'fontawesome',
					esc_html__( 'Custom Font', 'noor-assistant' )                                      => 'customfont',
					esc_html__( 'SVG Icons (Stroke Gap Icons And Material Icons) ', 'noor-assistant' ) => 'svgicon',
				),
				'param_name'  => 'icon_type',
				'description' => esc_html__( 'Select icons library.', 'noor-assistant' ),
			),

			array(
				'param_name'  => 'icon_svg',
				'heading'     => esc_html__( 'Icon SVG', 'noor-assistant' ),
				'description' => esc_html__( 'Enter SVG Icon name', 'noor-assistant' ),
				'value'       => '',
				'dependency'  => array(
					'element' => 'icon_type',
					'value'   => 'svgicon',
				),
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'icon',
				'heading'     => esc_html__( 'Icon Class', 'noor-assistant' ),
				'description' => esc_html__( 'Enter Icon Class from Font Awesome or Simple Line Icons.', 'noor-assistant' ),
				'value'       => 'simple-icon-user',
				'dependency'  => array(
					'element' => 'icon_type',
					'value'   => 'customfont',
				),
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'type'        => 'iconpicker',
				'heading'     => esc_html__( 'Icon', 'noor-assistant' ),
				'param_name'  => 'icon_fontawesome',
				'value'       => '', // default value to backend editor admin_label
				'settings'    => array(
					'emptyIcon'    => true,
					'value'        => 'fontawesome',
					'iconsPerPage' => 4000,
				),
				'dependency'  => array(
					'element' => 'icon_type',
					'value'   => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'noor-assistant' ),
			),
			array(
				'type'             => 'dima_heading_vc',
				'text'             => esc_html__( 'General', 'noor-assistant' ),
				'param_name'       => 'sizing',
				'edit_field_class' => 'dima-heading-param-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'param_name'  => 'id',
				'heading'     => esc_html__( 'ID', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique ID.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'class',
				'heading'     => esc_html__( 'Class', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter a unique class name.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			array(
				'param_name'  => 'style',
				'heading'     => esc_html__( 'Style', 'noor-assistant' ),
				'description' => esc_html__( '(Optional) Enter inline CSS.', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
			),
			// **************Animation***************//
			array(
				'param_name'  => 'animation',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'Animation', 'noor-assistant' ),
				'description' => esc_html__( 'Select the type of animation you want to use.', 'noor-assistant' ),
				'type'        => 'dropdown',
				'holder'      => 'div',
				'value'       => $dima_vc->dima_animate_list_velocity,
			),

			array(
				'param_name'  => 'delay',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'Delay Animation', 'noor-assistant' ),
				'description' => esc_html__( 'Set when the animation start (milliseconds)', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '',
			),

			array(
				'param_name'  => 'delay_duration',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'duration Animation', 'noor-assistant' ),
				'description' => esc_html__( 'Animation duration of each element  (milliseconds).', 'noor-assistant' ),
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '',
			),

			array(
				'param_name'  => 'delay_offset',
				'group'       => esc_html__( 'Animation', 'noor-assistant' ),
				'heading'     => esc_html__( 'Delay Animation Offset', 'noor-assistant' ),
				'description' => esc_html__( 'Set the number ( px,%..) from the top of the viewport where the animation start.', 'noor-assistant' ) . "<a href='http://imakewebthings.com/waypoints/api/offset-option/' target='_blank' >" . esc_html__( 'Read More', 'noor-assistant' ) . '</a>',
				'save_always' => true,
				'type'        => 'textfield',
				'holder'      => 'div',
				'value'       => '',
			),
			// **************!Animation***************//
			array(
				'param_name' => 'tutorials',
				'type'       => 'dima_doc_link_param',
				'heading'    => '<span class="tippy dima-help dima-vc-toolip">' . dima_get_svg_icon( 'ic_help' )
								 . '<span class="dima-vc-tooltip-text">'
								 . esc_html__( 'Video tutorial and theme documentation article', 'noor-assistant' ) . '</span></span>'
								 . esc_html__( 'Tutorial', 'noor-assistant' ),
				'doc_link'   => '',
				'video_link' => 'https://www.youtube.com/watch?v=_Ru4_sMqBpM',
				// 'doc_example' => 'https://noor.pixeldima.com/headings/',
			),

		),
	)
);
