<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
* Add-on Name: Counter
*/

class WPBakeryShortCode_Dima_Text_Autotype extends WPBakeryShortCode {
}

$default_text = '<h2>Hi there! *This is Noor Theme;Developed by PixelDima;Do you like it?*</h2>';

/**
 * Counter.
 */
vc_map(
	array(
		'base'        => 'dima_text_autotype',
		'name'        => esc_html__( 'Auto Type', 'noor-assistant' ),
		'weight'      => 960,
		'class'       => 'dima-vc-element dima-vc-element-item_icon',
		'icon'        => 'autotype',
		'category'    => esc_html__( 'PixelDima', 'noor-assistant' ),
		'description' => esc_html__( 'Add an animated text typing', 'noor-assistant' ),
		'params'      => array(
			array(
				'param_name'  => 'typed_text',
				'heading'     => esc_html__( 'Content', 'noor-assistant' ),
				'value'       => $default_text,
				'description' =>
					wp_kses(
						'
				Enter the content to display with typing text. You can apply HTML markup too.
				<br>
				<small>Text within <u>*</u> will be animated, example: <strong>*Sample text*</strong>.
				<br>
				Text separator is ; (semicolon), example: <strong>*First sentence; second sentence*</strong>
				<br>
				Pausing inside texts: <u>^1000</u> in milliseconds unit, example: <strong>*Hey, ^800 how are you?;Well, ^2000 I am Fine!*</strong>
				</small>',
						array(
							'br'     => array(),
							'small'  => array(),
							'strong' => array(),
							'u'      => array(),
						)
					),
				'save_always' => true,
				'type'        => 'textarea_safe',
				'holder'      => 'div',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Show more options', 'noor-assistant' ),
				'param_name'  => 'typed_show_options',
				'std'         => 'no',
				'value'       => array(
					'Yes' => 'yes',
					'No'  => 'no',
				),
				'description' => esc_html__( 'Configure animation options.', 'noor-assistant' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Character for cursor', 'noor-assistant' ),
				'value'       => '|',
				'description' => esc_html__( 'Leave empty to remove the blinking cursor.', 'noor-assistant' ),
				'param_name'  => 'typed_options_cursorchar',
				'dependency'  => array(
					'element' => 'typed_show_options',
					'value'   => array( 'yes' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Iteration loop', 'noor-assistant' ),
				'value'       => '',
				'description' => esc_html__( 'Leave empty for single loop only. Set -1 for infinite loop.', 'noor-assistant' ),
				'param_name'  => 'typed_options_loopcount',
				'dependency'  => array(
					'element' => 'typed_show_options',
					'value'   => array( 'yes' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Type speed', 'noor-assistant' ),
				'value'       => '10',
				'description' => esc_html__( 'Type of speed when entering the text. (Unit is milliseconds)', 'noor-assistant' ),
				'param_name'  => 'typed_options_typespeed',
				'dependency'  => array(
					'element' => 'typed_show_options',
					'value'   => array( 'yes' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Back speed', 'noor-assistant' ),
				'value'       => '20',
				'description' => esc_html__( 'Back speed when deleting the text. (Unit is milliseconds)', 'noor-assistant' ),
				'param_name'  => 'typed_options_backspeed',
				'dependency'  => array(
					'element' => 'typed_show_options',
					'value'   => array( 'yes' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Start delay', 'noor-assistant' ),
				'value'       => '0',
				'description' => esc_html__( 'Set delay before starting text typing. (Unit is milliseconds)', 'noor-assistant' ),
				'param_name'  => 'typed_options_startdelay',
				'dependency'  => array(
					'element' => 'typed_show_options',
					'value'   => array( 'yes' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Back delay', 'noor-assistant' ),
				'value'       => '500',
				'description' => esc_html__( 'Set back delay after text is typed. (Unit is milliseconds)', 'noor-assistant' ),
				'param_name'  => 'typed_options_backdelay',
				'dependency'  => array(
					'element' => 'typed_show_options',
					'value'   => array( 'yes' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Extra class name', 'noor-assistant' ),
				'param_name'  => 'class',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'noor-assistant' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			),
		),
	)
);
