<?php
/**
 * DIMA Framework
 * WARNING: This file is part of the DIMA Core Framework.
 * Do not edit the core files.
 *
 * @package Dima Framework
 * @subpackage Extensions
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */


if ( ! function_exists( 'dima_vc_backend_styles' ) ) :
	function dima_vc_backend_styles() {
		wp_register_script( 'dima-vc-admin-js', DIMA_NOUR_ASSISTANT_URL . '/js/js_vc_backend_extend.js', array( 'jquery' ), DIMA_NOUR_ASSISTANT_VERSION, true );
		wp_enqueue_script( 'dima-vc-admin-js' );
	}
endif;

add_action( 'vc_backend_editor_render', 'dima_vc_backend_styles' );



if ( ! function_exists( 'dima_vc_back_and_frontend_styles' ) ) :
	function dima_vc_back_and_frontend_styles() {

		wp_register_script( 'dima-vc-all-admin-js', DIMA_NOUR_ASSISTANT_URL . '/js/js_dima_vc.js', array( 'jquery' ), DIMA_NOUR_ASSISTANT_VERSION, true );
		wp_enqueue_script( 'dima-vc-all-admin-js' );

		wp_register_script( 'dima-vc-admin-global-js', DIMA_NOUR_ASSISTANT_URL . '/js/js_vc_global.js', array( 'jquery' ), DIMA_NOUR_ASSISTANT_VERSION, true );
		wp_enqueue_script( 'dima-vc-admin-global-js' );
		wp_deregister_script( 'vc_waypoints' );
		if ( DIMA_VISUAL_COMOPSER_IS_ACTIVE ) {
			if ( is_rtl() ) {
				wp_enqueue_style( 'dima-visual-composer', DIMA_NOUR_ASSISTANT_URL . '/css/visual-composer_rtl.css', null, DIMA_NOUR_ASSISTANT_VERSION, 'all' );
			} else {
				wp_enqueue_style( 'dima-visual-composer', DIMA_NOUR_ASSISTANT_URL . '/css/visual-composer.css', null, DIMA_NOUR_ASSISTANT_VERSION, 'all' );
			}
		}
	}
endif;
add_action( 'vc_frontend_editor_render', 'dima_vc_back_and_frontend_styles' );
add_action( 'vc_backend_editor_render', 'dima_vc_back_and_frontend_styles' );


if ( ! function_exists( 'dima_vc_frontend_styles' ) ) :
	function dima_vc_frontend_styles() {
		if ( DIMA_VISUAL_COMOPSER_IS_ACTIVE ) {
			if ( is_rtl() ) {
				wp_enqueue_style( 'dima-vc-frontend-css', DIMA_NOUR_ASSISTANT_URL . '/css/vc_admin_frontend_rtl.css', false, DIMA_NOUR_ASSISTANT_VERSION, 'all' );
			} else {
				wp_enqueue_style( 'dima-vc-frontend-css', DIMA_NOUR_ASSISTANT_URL . '/css/vc_admin_frontend.css', array(), DIMA_NOUR_ASSISTANT_VERSION );
			}
		}
	}
endif;

add_action( 'vc_frontend_editor_render', 'dima_vc_frontend_styles', 999 );
add_action( 'vc_inline_editor_page_view', 'dima_vc_frontend_styles', 999 );
