jQuery(document).ready($ => {
    window.DimaRowView = window.VcRowView.extend({
        buildDesignHelpers() {
            const color = this.model.getParam('cover_color');
            const image = this.model.getParam('di_bg_image');
            const video = this.model.getParam('di_bg_video');
            const $column_toggle = this.$el.find('> .vc_controls .column_toggle');
            let $color = '';

            this.$el.find('> .controls .vc_row_color').remove();
            this.$el.find('> .controls .vc_row_image').remove();
            if (color) {
                $color = $(`<span class="vc_row_color" style="background-color:${color}"></span>`);
                $color.insertAfter($column_toggle);
            }
            if (video) {
                if ($color == '') {
                    $color = $('<span class="vc_row_color"></span>');
                    $color.insertAfter($column_toggle);
                }
                if (video.includes("youtube")) {
                    $color.addClass('image_viewer').html($('<span class="vc_row_image" style=""><i class="fa fa-youtube"/></span>'));
                } else {
                    $color.addClass('image_viewer').html($('<span class="vc_row_image" style=""><i class="fa fa-vimeo"/></span>'));
                }

            }

            if (image) {
                $.ajax({
                    type: 'POST',
                    url: window.ajaxurl,
                    data: {
                        action: 'dima_get_media_post',
                        content: image
                    },
                    dataType: 'JSON'
                }).done(data => {
                    if ($color == '') {
                        $color = $('<span class="vc_row_color"></span>');
                        $color.insertAfter($column_toggle);
                    }
                    if (data.back_url != '') $color.addClass('image_viewer').html($(`<span class="vc_row_image" style="${data.back_url}"></span>`));
                    if (data.back_icon != '') $color.html($(`<span class="vc_row_image" title="${(data.back_mime).replace("oembed/", "")}">${data.back_icon}</span>`));
                });
            }
        },
        ready(e) {
            window.DimaRowView.__super__.ready.call(this, e);
            if (this.$content.closest('.wpb_dima_slider').length) {
                const row_inner = this.$content.closest('.wpb_vc_row_inner.wpb_sortable');
                row_inner.prepend("<h3>Slide</h3>");
            }
            return this;
        }
    });

    window.DimaColumnView = window.VcColumnView.extend({
        buildDesignHelpers() {
            const color = this.model.getParam('cover_color');
            const image = this.model.getParam('di_bg_image');
            const video = this.model.getParam('di_bg_video');
            const column_layout = this.model.getParam('column_layout');
            const $column = this.$el.find('> .wpb_element_wrapper');
            const $column_add = this.$el.find('> .bottom-controls .column_add');
            const $column_edit = this.$el.find('> .vc_controls .column_edit');
            const $column_delete = this.$el.find('> .vc_controls .column_delete');
            const $column_toggle = this.$el.find('> .vc_controls .column_toggle');
            let $color = '';

            $column_edit.insertAfter($column_add);
            $column_delete.insertAfter($column_edit);
            this.$el.find('> .bottom-controls .vc_column_color').remove();
            this.$el.find('> .bottom-controls .vc_column_image').remove();

            if (column_layout !== '') {
                if (column_layout === 'main_end_content' || column_layout === 'main_start_content') {
                    $column.css('background-color', '#a5d6a7')
                } else {
                    $column.css('background-color', '#40c4ff')
                }
            } else {
                if (color) {
                    $color = $(`<span class="vc_control vc_column_color" style="background-color:${color}"></span>`);
                    $color.insertAfter($column_delete);
                }
                if (video) {
                    if ($color === '') {
                        $color = $('<span class="vc_row_color"></span>');
                        $color.insertAfter($column_toggle);
                    }

                    if (video.includes("youtube")) {
                        $color = $(`<span class="vc_control vc_column_color image_viewer" style="background-color:${color}"><i class="fa fa-youtube"/></span>`);
                        $color.insertAfter($column_delete);
                    } else {
                        $color = $(`<span class="vc_control vc_column_color image_viewer" style="background-color:${color}"><i class="fa fa-vimeo"/></span>`);
                        $color.insertAfter($column_delete);
                    }
                }
                if (image) {
                    $.ajax({
                        type: 'POST',
                        url: window.ajaxurl,
                        data: {
                            action: 'dima_get_media_post',
                            content: image
                        },
                        dataType: 'JSON'
                    }).done(data => {
                        if ($color === '') {
                            $color = $('<span class="vc_control vc_column_color"></span>');
                            $color.insertAfter($column_delete);
                        }
                        if (data.back_url !== '') $color.addClass('image_viewer').html($(`<span class="vc_column_image" style="${data.back_url}"></span>`));
                        if (data.back_icon !== '' && data.back_mime !== undefined) $color.html($(`<span class="vc_column_image" title="${(data.back_mime).replace("oembed/", "")}">${data.back_icon}</span>`));
                    });
                }
            }
        }
    });

    window.DimaBlockView = vc.shortcode_view.extend({
        changeShortcodeParams(model) {
            window.DimaBlockView.__super__.changeShortcodeParams.call(this, model);
            const wrap = this.$el.closest('.wpb_element_wrapper');
            const container = this.$el.find('.wpb_element_wrapper');
            const row = this.$el.closest('.wpb_vc_row');
            wrap.css('padding', '0');
            container.css('backgroundColor', '#fffbb2');
            row.find('.vc_row_layouts').hide();
            row.find('.vc_column-edit').hide();
            row.find('.vc_control-column').hide();
        }
    });

    window.DimaImageView = vc.shortcode_view.extend({
        changeShortcodeParams(model) {
            window.DimaImageView.__super__.changeShortcodeParams.call(this, model);
            const image = this.model.getParam('src');
            const $wpb_element_title = this.$el.find('.wpb_element_title');
            const $wpb_img = this.$el.find('.vc_general.vc_element-icon.image');
            if (image) {
                $.ajax({
                    type: 'POST',
                    url: window.ajaxurl,
                    data: {
                        action: 'dima_get_media_post',
                        content: image
                    },
                    dataType: 'JSON'
                }).done(data => {
                    if (data.img_name !== '') {
                        $color = $(`<span class="dima-vc-image-name">${data.img_name}</span>`);
                        $color.insertAfter($wpb_element_title);
                    }
                    if (data.img_path !== '') {
                        $wpb_img.css('background-image', `url(${data.img_path})`);
                    }

                });
            }
        }
    });
});