"use strict";

//shortcode
(function ($) {
    /**
     * Google Maps
     */
    var map = function map(selected, params) {
        var _ID = selected.attr("id");
        var _lat = params.lat;
        var _lng = params.lng;
        var _ZoomControl = params.zoomControl;
        var _Coordinates = new google.maps.LatLng(_lat, _lng);
        var _drag = params.drag;
        var _height = params.height;
        var _width = params.width;
        var _map_style = params.map_style;
        var _zoom = parseInt(params.zoom);

        var Styles = [];
        switch (_map_style) {
            case "dark":
                Styles = [{ "elementType": "geometry", "stylers": [{ "color": "#212121" }] }, {
                    "elementType": "labels.icon",
                    "stylers": [{ "visibility": "off" }]
                }, {
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#757575" }]
                }, {
                    "elementType": "labels.text.stroke",
                    "stylers": [{ "color": "#212121" }]
                }, {
                    "featureType": "administrative",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#757575" }]
                }, {
                    "featureType": "administrative.country",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#9e9e9e" }]
                }, {
                    "featureType": "administrative.land_parcel",
                    "stylers": [{ "visibility": "off" }]
                }, {
                    "featureType": "administrative.locality",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#bdbdbd" }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#757575" }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#181818" }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#616161" }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "labels.text.stroke",
                    "stylers": [{ "color": "#1b1b1b" }]
                }, {
                    "featureType": "road",
                    "elementType": "geometry.fill",
                    "stylers": [{ "color": "#2c2c2c" }]
                }, {
                    "featureType": "road",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#8a8a8a" }]
                }, {
                    "featureType": "road.arterial",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#373737" }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#3c3c3c" }]
                }, {
                    "featureType": "road.highway.controlled_access",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#4e4e4e" }]
                }, {
                    "featureType": "road.local",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#616161" }]
                }, {
                    "featureType": "transit",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "color": "#757575" }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#000000" }]
                }, { "featureType": "water", "elementType": "labels.text.fill", "stylers": [{ "color": "#3d3d3d" }] }];
                break;
            case "silver":
                Styles = [{
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#f5f5f5"
                    }]
                }, {
                    "elementType": "labels.icon",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#616161"
                    }]
                }, {
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#f5f5f5"
                    }]
                }, {
                    "featureType": "administrative.land_parcel",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#bdbdbd"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#eeeeee"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#757575"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#e5e5e5"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#9e9e9e"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#ffffff"
                    }]
                }, {
                    "featureType": "road.arterial",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#757575"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#dadada"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#616161"
                    }]
                }, {
                    "featureType": "road.local",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#9e9e9e"
                    }]
                }, {
                    "featureType": "transit.line",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#e5e5e5"
                    }]
                }, {
                    "featureType": "transit.station",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#eeeeee"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#c9c9c9"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#9e9e9e"
                    }]
                }];
                break;
            case "retro":
                Styles = [{
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#ebe3cd"
                    }]
                }, {
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#523735"
                    }]
                }, {
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#f5f1e6"
                    }]
                }, {
                    "featureType": "administrative",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#c9b2a6"
                    }]
                }, {
                    "featureType": "administrative.land_parcel",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#dcd2be"
                    }]
                }, {
                    "featureType": "administrative.land_parcel",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#ae9e90"
                    }]
                }, {
                    "featureType": "landscape.natural",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#dfd2ae"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#dfd2ae"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#93817c"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "geometry.fill",
                    "stylers": [{
                        "color": "#a5b076"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#447530"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#f5f1e6"
                    }]
                }, {
                    "featureType": "road.arterial",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#fdfcf8"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#f8c967"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#e9bc62"
                    }]
                }, {
                    "featureType": "road.highway.controlled_access",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#e98d58"
                    }]
                }, {
                    "featureType": "road.highway.controlled_access",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#db8555"
                    }]
                }, {
                    "featureType": "road.local",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#806b63"
                    }]
                }, {
                    "featureType": "transit.line",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#dfd2ae"
                    }]
                }, {
                    "featureType": "transit.line",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#8f7d77"
                    }]
                }, {
                    "featureType": "transit.line",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#ebe3cd"
                    }]
                }, {
                    "featureType": "transit.station",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#dfd2ae"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry.fill",
                    "stylers": [{
                        "color": "#b9d3c2"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#92998d"
                    }]
                }];
                break;
            case "night":
                Styles = [{
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#242f3e"
                    }]
                }, {
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#746855"
                    }]
                }, {
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#242f3e"
                    }]
                }, {
                    "featureType": "administrative.locality",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#d59563"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#d59563"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#263c3f"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#6b9a76"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#38414e"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#212a37"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#9ca5b3"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#746855"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#1f2835"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#f3d19c"
                    }]
                }, {
                    "featureType": "transit",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#2f3948"
                    }]
                }, {
                    "featureType": "transit.station",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#d59563"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#17263c"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#515c6d"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#17263c"
                    }]
                }];
                break;
            case "aubergine":
                Styles = [{
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#1d2c4d"
                    }]
                }, {
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#8ec3b9"
                    }]
                }, {
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#1a3646"
                    }]
                }, {
                    "featureType": "administrative.country",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#4b6878"
                    }]
                }, {
                    "featureType": "administrative.land_parcel",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#64779e"
                    }]
                }, {
                    "featureType": "administrative.province",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#4b6878"
                    }]
                }, {
                    "featureType": "landscape.man_made",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#334e87"
                    }]
                }, {
                    "featureType": "landscape.natural",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#023e58"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#283d6a"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#6f9ba5"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#1d2c4d"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "geometry.fill",
                    "stylers": [{
                        "color": "#023e58"
                    }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#3C7680"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#304a7d"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#98a5be"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#1d2c4d"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#2c6675"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#255763"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#b0d5ce"
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#023e58"
                    }]
                }, {
                    "featureType": "transit",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#98a5be"
                    }]
                }, {
                    "featureType": "transit",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "color": "#1d2c4d"
                    }]
                }, {
                    "featureType": "transit.line",
                    "elementType": "geometry.fill",
                    "stylers": [{
                        "color": "#283d6a"
                    }]
                }, {
                    "featureType": "transit.station",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#3a4762"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#0e1626"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#4e6d70"
                    }]
                }];
                break;

            case "gray":
                Styles = [{
                    "featureType": "all",
                    "elementType": "labels.text.fill",
                    "stylers": [{ "saturation": "36" }, { "color": "#838687" }, { "lightness": "0" }]
                }, {
                    "featureType": "all",
                    "elementType": "labels.text.stroke",
                    "stylers": [{ "visibility": "on" }, { "color": "#ffffff" }, { "lightness": 16 }]
                }, {
                    "featureType": "all",
                    "elementType": "labels.icon",
                    "stylers": [{ "visibility": "off" }]
                }, {
                    "featureType": "administrative",
                    "elementType": "geometry.fill",
                    "stylers": [{ "color": "#fefefe" }, { "lightness": 20 }]
                }, {
                    "featureType": "administrative",
                    "elementType": "geometry.stroke",
                    "stylers": [{ "color": "#fefefe" }, { "lightness": 17 }, { "weight": 1.2 }]
                }, {
                    "featureType": "landscape",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#f5f8f9" }, { "lightness": 20 }]
                }, {
                    "featureType": "poi",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#dbdfe1" }, { "lightness": 21 }]
                }, {
                    "featureType": "poi.park",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#dbdfe1" }, { "lightness": 21 }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.fill",
                    "stylers": [{ "color": "#ffffff" }, { "lightness": 17 }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.stroke",
                    "stylers": [{ "color": "#ffffff" }, { "lightness": 29 }, { "weight": 0.2 }]
                }, {
                    "featureType": "road.arterial",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#ffffff" }, { "lightness": 18 }]
                }, {
                    "featureType": "road.local",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#ffffff" }, { "lightness": 16 }]
                }, {
                    "featureType": "transit",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#f2f2f2" }, { "lightness": 19 }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [{ "color": "#ebeeef" }, { "lightness": 17 }]
                }];
                break;
            case "legacy_north":
                Styles = [{
                    "featureType": "all",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "saturation": 36
                    }, {
                        "color": "#000000"
                    }, {
                        "lightness": 40
                    }]
                }, {
                    "featureType": "all",
                    "elementType": "labels.text.stroke",
                    "stylers": [{
                        "visibility": "on"
                    }, {
                        "color": "#000000"
                    }, {
                        "lightness": 16
                    }]
                }, {
                    "featureType": "all",
                    "elementType": "labels.icon",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "administrative",
                    "elementType": "geometry.fill",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 20
                    }]
                }, {
                    "featureType": "administrative",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 17
                    }, {
                        "weight": 1.2
                    }]
                }, {
                    "featureType": "landscape",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 20
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 21
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.fill",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 17
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "geometry.stroke",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 29
                    }, {
                        "weight": 0.2
                    }]
                }, {
                    "featureType": "road.arterial",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 18
                    }]
                }, {
                    "featureType": "road.local",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 16
                    }]
                }, {
                    "featureType": "transit",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 19
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [{
                        "color": "#000000"
                    }, {
                        "lightness": 17
                    }]
                }];
                break;
            default:
                Styles = [];
                break;
        }

        $(selected).css({
            paddingBottom: _height,
            width: _width,
            margin: '0 auto'
        });

        var mapOptions = {
            scrollwheel: false,
            draggable: _drag === true,
            zoomControl: _ZoomControl === true,
            disableDoubleClickZoom: false,
            disableDefaultUI: true,
            zoom: _zoom,
            center: _Coordinates,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        var _MapStyle = new google.maps.StyledMapType(Styles, {
            name: 'Styled Map'
        });
        var _Map = new google.maps.Map(document.getElementById(_ID), mapOptions);
        _Map.mapTypes.set('map_style', _MapStyle);
        _Map.setMapTypeId('map_style');
        var G_ID = $("#" + _ID).parent().attr('id');
        if ($("#" + G_ID + " .dima-gmap-marker").length > 0) {
            _marker(_Map, G_ID);
        }
    };
    var _marker = function _marker(_Map, _ID) {
        $("#" + _ID + " .dima-gmap-marker").each(function (index, elm) {
            var params = $(elm).data('dima-params');
            var _markers = void 0;
            var _infoWindows = void 0;
            _markers = new google.maps.Marker({
                map: _Map,
                position: new google.maps.LatLng(params.lat, params.lng),
                infoWindowIndex: index,
                icon: params.image
            });
            _infoWindows = new google.maps.InfoWindow({
                content: params.info,
                maxWidth: 200
            });
            google.maps.event.addListener(_markers, 'click', function () {
                if (params.info !== '') {
                    _infoWindows.open(_Map, this);
                }
            });
        });
    };

    //flex slide
    var _slider = function _slider(element, params) {
        jQuery(element).css('height', 'auto').flexslider({
            selector: '.slides > .slide-item',
            animation: params.animation,
            controlNav: params.controlNav,
            directionNav: params.directionNav,
            slideshowSpeed: params.slideshowSpeed,
            animationSpeed: params.animationSpeed,
            slideshow: params.slideshow,
            randomize: params.random,
            pauseOnHover: true,
            useCSS: true,
            touch: true,
            video: true,
            //smoothHeight: true,
            easing: 'easeInOutExpo'
        });
    };

    var _slick = function _slick(element, params) {
        var _elm = jQuery(element);

        var _ = $(this);
        var dataSettings = void 0;
        _.defaults = {
            accessibility: true,
            adaptiveHeight: false,
            appendArrows: $(element),
            appendDots: $(element),
            arrows: true,
            asNavFor: null,
            prevArrow: '<button type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button">Previous</button>',
            nextArrow: '<button type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button">Next</button>',
            autoplay: false,
            autoplaySpeed: 3000,
            centerMode: false,
            centerPadding: '50px',
            cssEase: 'ease',
            customPaging: function customPaging(slider, i) {
                return $('<button type="button" data-role="none" role="button" tabindex="0" />').text(i + 1);
            },

            dots: false,
            dotsClass: 'slick-dots',
            draggable: true,
            easing: 'linear',
            edgeFriction: 0.35,
            fade: false,
            focusOnSelect: false,
            infinite: true,
            initialSlide: 0,
            lazyLoad: 'ondemand',
            mobileFirst: false,
            pauseOnHover: true,
            pauseOnFocus: true,
            pauseOnDotsHover: false,
            respondTo: 'window',
            responsive: null,
            rows: 1,
            rtl: false,
            slide: '',
            slidesPerRow: 1,
            slidesToShow: 1,
            slidesToScroll: 1,
            speed: 500,
            swipe: true,
            swipeToSlide: false,
            touchMove: true,
            touchThreshold: 5,
            useCSS: true,
            useTransform: true,
            variableWidth: false,
            vertical: false,
            verticalSwiping: false,
            waitForAnimate: true,
            zIndex: 1000
        };
        _.initials = {
            animating: false,
            dragging: false,
            autoPlayTimer: null,
            currentDirection: 0,
            currentLeft: null,
            currentSlide: 0,
            direction: 1,
            $dots: null,
            listWidth: null,
            listHeight: null,
            loadIndex: 0,
            $nextArrow: null,
            $prevArrow: null,
            scrolling: false,
            slideCount: null,
            slideWidth: null,
            $slideTrack: null,
            $slides: null,
            sliding: false,
            slideOffset: 0,
            swipeLeft: null,
            swiping: false,
            $list: null,
            touchObject: {},
            transformsEnabled: false,
            unslicked: false
        };
        $.extend(_, _.initials);
        dataSettings = params || {};
        _.options = $.extend({}, _.defaults, params, dataSettings);

        if (typeof _.options.slidesToScroll === "undefined") {
            _.options.slidesToScroll = 1;
        }

        _elm.slick({
            slidesToShow: parseInt(_.options.slidesToShow),
            slidesToScroll: parseInt(_.options.slidesToScroll),
            centerMode: _.options.centerMode,
            variableWidth: _.options.variableWidth,
            centerPadding: _.options.centerPadding,
            adaptiveHeight: _.options.adaptiveHeight,
            dots: _.options.dots,
            arrows: _.options.arrows,
            autoplay: _.options.autoplay,
            infinite: _.options.infinite,
            fade: _.options.fade,
            lazyLoad: _.options.lazyLoad,
            draggable: _.options.draggable,
            mobileFirst: _.options.mobileFirst,
            pauseOnFocus: _.options.pauseOnFocus,
            pauseOnHover: _.options.pauseOnHover,
            vertical: _.options.vertical,
            verticalSwiping: _.options.verticalSwiping,
            speed: _.options.speed,
            autoplaySpeed: _.options.autoplaySpeed,
            asNavFor: _.options.asNavFor,
            focusOnSelect: _.options.focusOnSelect,
            smartSpeed: 500,
            dotsSpeed: 400,
            rtl: _.options.rtl,
            accessibility: true,
            pauseOnDotsHover: true,
            responsive: [{
                breakpoint: 250,
                settings: {
                    slidesToShow: _.options.items_phone
                }
            }, {
                breakpoint: 480,
                settings: {
                    slidesToShow: _.options.items_phone
                }
            }, {
                breakpoint: 768,
                settings: {
                    slidesToShow: _.options.items_tablet
                }
            }, {
                breakpoint: 979,
                settings: {
                    slidesToShow: _.options.items_tablet
                }
            }, {
                breakpoint: 1199,
                settings: {
                    slidesToShow: _.options.slidesToShow
                }
            }]

        });
    };

    $(document).ready(function () {
        //google maps
        $('[data-dima-element="google_map"]').each(function (index, element) {
            var elm = $(element).find(".dima-gmap-in");
            var params = $(element).data('dima-params') || {};
            map(elm, params);
        });
        //Flex Slide
        $('[data-dima-element="slider"]').each(function (index, element) {
            var params = $(element).data('dima-params') || {};
            _slider(element, params);
        });

        //slick Slide
        $('[data-dima-element="slick_slider"]').each(function (index, element) {
            var params = $(element).data('dima-params') || {};
            _slick(element, params);
        });
        $('[data-dima-element="slick_slider_nav"]').each(function (index, element) {
            var params = $(element).data('dima-params') || {};
            _slick(element, params);
        });
    });
})(jQuery);