<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Testimonial
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_testimonial( $atts, $content = null ) { // 1
	extract(
		shortcode_atts(
			array(
				'id'                 => '',
				'class'              => '',
				'style'              => '',
				'author'             => '',
				'job'                => '',
				'image'              => '',
				'image_circle'       => '',
				'icon'               => '',
				'url'                => '',
				'target'             => '',
				'border'             => '',
				'bg_color'           => '',
				'icon_color'         => '',
				'meta_color'         => '',
				'padding_top_bottom' => '',
				'padding_left_right' => '',
				'dima_vc_add_shadow' => '',
				'icon_float'         => '',
				'text_alignment'     => '',
				'float'              => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'testimonial'
		)
	);

	$id                 = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$style              = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$image              = ( $image != '' ) ? $image : '';
	$author             = ( $author != '' ) ? $author : '';
	$text_alignment     = ( $text_alignment != '' ) ? $text_alignment : '';
	$image_circle       = ( $image_circle == 'true' ) ? ' circle' : '';
	$_class[]           = ( $class != '' ) ? ' ' . esc_attr( $class ) : '';
	$icon_color         = ( $icon_color != '' ) ? 'style="color:' . $icon_color
	                                              . ';"' : '';
	$meta_color         = ( $meta_color != '' ) ? 'style="color:' . $meta_color
	                                              . ';"' : '';
	$padding_left_right = ( $padding_left_right != '' )
		? "padding-left: $padding_left_right ;padding-right:$padding_left_right;"
		: '';
	$padding_top_bottom = ( $padding_top_bottom != '' )
		? "padding-top: $padding_top_bottom ;padding-bottom:$padding_top_bottom;"
		: '';
	$job                = ( $job != '' ) ? '<span><span> - </span>' . $job . '</span>' : '';
	$_class[]           = ( $dima_vc_add_shadow == 'true' ) ? 'box-with-shadow'
		: '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	$bg_color_with_shadow = "";
	if ( ( $dima_vc_add_shadow == 'true' ) ) {
		if ( $bg_color != '' ) {
			$bg_color_with_shadow = 'data-bg-color="' . $bg_color . '"';
		}
		$bg_color = '';
	}
	$bg_color = ( $bg_color != '' ) ? "background: $bg_color ;" : '';

	if ( $bg_color != '' || $padding_left_right != ''
	     || $padding_top_bottom != ''
	) {
		$bg_color = 'style="' . $bg_color . $padding_left_right
		            . $padding_top_bottom . '"';
	}

	if ( is_numeric( $image ) ) {
		$bg_image_info = wp_get_attachment_image_src( $image, 'full' );
		$image         = $bg_image_info[0];
	}

	switch ( $icon_float ) {
		case 'end' :
			$_class[] = 'icon_quote_end';
			break;
		case 'start' :
			$_class[] = 'icon_quote_start';
			break;
	}

	switch ( $text_alignment ) {
		case 'end' :
			$_class[] = 'text-end';
			break;
		case 'start' :
			$_class[] = 'text-start';
			break;
		case 'center' :
			$_class[] = 'text-center';
			break;
	}

	if ( $text_alignment != '' ) {
		switch ( $float ) {
			case 'end' :
				$_class[] = 'quote-end';
				break;
			case 'start' :
				$_class[] = 'quote-start';
				break;
			case 'top-center' :
				$_class[] = 'quote-top-center-arrow';
				break;
			case 'top-start' :
				$_class[] = 'quote-start-top';
				break;
			case 'top-end' :
				$_class[] = 'quote-end-top';
				break;
			case 'bottom-center' :
				$_class[] = 'quote-bottom-center-arrow';
				break;
			case 'bottom-start' :
				$_class[] = 'quote-start-bottom';
				break;
			case 'bottom-end' :
				$_class[] = 'quote-end-bottom';
				break;
			default :
				$_class[] = 'quote-start';
		}
	} else {
		switch ( $float ) {
			case 'end' :
				$_class[] = 'quote-end text-end';
				break;
			case 'start' :
				$_class[] = 'quote-start text-start';
				break;
			case 'top-center' :
				$_class[] = 'quote-top-center-arrow text-center';
				break;
			case 'top-start' :
				$_class[] = 'quote-start-top text-start';
				break;
			case 'top-end' :
				$_class[] = 'quote-end-top text-end';
				break;
			case 'bottom-center' :
				$_class[] = 'quote-bottom-center-arrow text-center';
				break;
			case 'bottom-start' :
				$_class[] = 'quote-start-bottom text-start';
				break;
			case 'bottom-end' :
				$_class[] = 'quote-end-bottom text-end';
				break;
			default :
				$_class[] = 'quote-start';
		}
	}

	if ( ! empty( $url ) ) {
		$author = "<a  href=\"$url\" {$target}>$author</a>";
	}

	if ( $border == 'true' ) {
		$_class[] = " testimonial-side quote-text";
	} else {
		$_class[] = "no-arrow quote-text";
	}
	if ( ! empty( $image ) ) {
		$image
			= "<span data-element-bg=\"$image\" class=\"dima-testimonial-image{$image_circle}\">"
			  .
			  "</span>";
	} else {
		$_class[] = "no-arrow";
	}

	if ( $icon != 'false' ) {
		$icon = "<span {$icon_color}>" . dima_get_svg_icon( "ic_format_quote" )
		        . "</span>";
	} else {
		$icon = '';
	}

	if ( ! empty( $_class ) ) {
		$class = dima_short_remove_white_space( join( ' ', $_class ) );
	}
	if ( $float === "bottom-start" || $float === "bottom-end"
	     || $float === "bottom-center"
	) {
		$output
			= "<div {$id} {$bg_color_with_shadow} {$style} class=\"dima-testimonial {$class}\" {$animation_data}>"
			  .
			  "<blockquote {$bg_color}>" .
			  $icon .
			  "<div class=\"quote-content\">" .
			  "<p>" . do_shortcode( $content ) . "</p>" .
			  "<span class=\"dima-testimonial-meta\" {$meta_color}>" .
			  $author . " " . $job .
			  "</span>" .
			  "</div>" .
			  "</blockquote>" .
			  $image .
			  "</div>";

	} else {
		$output
			= "<div {$id} {$bg_color_with_shadow} {$style} class=\"dima-testimonial {$class}\" {$animation_data}>"
			  .
			  $image .
			  "<blockquote {$bg_color}>" .
			  $icon .
			  "<div class=\"quote-content\">" .
			  "<p>" . do_shortcode( $content ) . "</p>" .
			  "<span class=\"dima-testimonial-meta\" {$meta_color}>" .
			  $author . " " . $job .
			  "</span>" .
			  "</div>" .
			  "</blockquote>" .
			  "</div>";
	}

	return $output;
}

add_shortcode( 'testimonial', 'dima_shortcode_testimonial' );