<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function dima_shortcode_slick_slider( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'              => '',
				'class'           => '',
				'style'           => '',
				'pagination'      => '',
				'auto_play'       => '',
				'auto_play_speed' => '',
				'navigation'      => '',
				'dots_style'      => 'false',
				'inner'           => '',
				'loop'            => 'true',
				'centermode'      => '',
				'centerpadding'   => '',
				'adaptiveheight'  => '',
				'variablewidth'   => '',
				'_draggable'      => 'true',
				'lazyload'        => '',
				'mobilefirst'     => '',
				'pauseonfocus'    => '',
				'pauseonhover'    => '',
				'fade'            => '',
				'verticalswiping' => '',
				'_vertical'       => '',
				'speed'           => '',
				'dark'            => '',
				'items'           => '',
				'items_phone'     => '',
				'items_tablet'    => '',
				'slidestoscroll'  => 1,
				'items_margin'    => '',
			), $atts, 'slick_slider'
		)
	);

	static $count = 0;
	$count ++;
	wp_enqueue_script( 'dima-slick' );

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? esc_attr( $class ) : "slick-slider";
	$class .= ( $centermode == 'true' ) ? " center_zoom_opacity" : "";
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$js_data = array(
		'dots'            => ( $pagination == 'true' ),
		'autoplay'        => ( $auto_play == 'true' ),
		'arrows'          => ( $navigation == '1' ),
		'slidesToScroll'  => ( $slidestoscroll == '' ) ? 1 : $slidestoscroll,
		'infinite'        => ( $loop == 'true' ),
		'fade'            => ( $fade == 'true' ),
		'centerMode'      => ( $centermode == 'true' ),
		'centerPadding'   => ( $centerpadding == '' ) ? '50px' : $centerpadding,
		'variableWidth'   => ( $variablewidth == 'true' ),
		'draggable'       => ( $_draggable == 'true' ),
		'asNavFor'        => null,
		'adaptiveHeight'  => ( $adaptiveheight == 'true' ),
		'mobileFirst'     => ( $mobilefirst == 'true' ),
		'pauseOnHover'    => ( $pauseonhover == 'true' ),
		'pauseOnFocus'    => ( $pauseonfocus == 'true' ),
		'vertical'        => ( $_vertical == 'true' ),
		'verticalSwiping' => ( $verticalswiping == 'true' ),
		'slidesToShow'    => ( $items == '' ) ? 1 : $items,
		'speed'           => ( $speed == '' ) ? '300' : $speed,
		'autoplaySpeed'   => ( $auto_play_speed == '' ) ? '3000'
			: $auto_play_speed,
		'lazyLoad'        => ( $lazyload == '' ) ? 'Ondemand' : $lazyload,
		'items_phone'     => ( $items_phone == '' ) ? 1 : $items_phone,
		'items_tablet'    => ( $items_tablet == '' ) ? 1 : $items_tablet,
		'rtl'             => is_rtl()
	);

	$data = dima_creat_data_attributes( 'slick_slider', $js_data );

	if ( $dark == "true" ) {
		$dark = " slick-darck";
	} else {
		$dark = "";
	}

	if ( $dots_style == "true" ) {
		$class .= " slick_side_dots";
	}

	if ( $items_margin == "true" ) {
		$dark .= " slick-with-margin";
	} else {
		$dark .= "";
	}

	$output = "<div {$id} class=\" {$class}\" {$style}>"
	          . "<div class=\"{$dark}\" {$data}>"
	          . do_shortcode( $content )
	          . "</div>"
	          . '</div>';

	return $output;
}

add_shortcode( 'slick_slider', 'dima_shortcode_slick_slider' );

function dima_shortcode_slick_slide( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'thumb' => '',
				'style' => ''
			), $atts, 'slick_slide'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'slick-item ' . esc_attr( $class ) : 'slick-item';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$thumb = ( $thumb != '' ) ? 'data-thumb="' . $thumb . '"' : '';

	$output = "<div {$thumb} {$id} class=\"{$class}\" {$style}>" . do_shortcode(
			$content
		) . "</div>";

	return $output;
}

add_shortcode( 'slick_slide', 'dima_shortcode_slick_slide' );