<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Share
 */

function dima_shortcode_share_post( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'          => '',
				'class'       => '',
				'style'       => '',
				'float'       => 'center',
				'size'        => '',
				'circle'      => '',
				'facebook'    => '',
				'twitter'     => '',
				'google_plus' => '',
				'linkedin'    => '',
				'pinterest'   => '',
				'reddit'      => '',
				'vk'          => '',
				'email'       => ''
			), $atts, 'share'
		)
	);

	$share_url        = urlencode( get_permalink() );
	$share_title      = urlencode( get_the_title() );
	$share_source     = urlencode( get_bloginfo( 'name' ) );
	$share_content    = urlencode( get_the_excerpt() );
	$share_image_info = wp_get_attachment_image_src(
		get_post_thumbnail_id(), 'full'
	);
	$share_image      = ( function_exists(
		'dima_helper::dima_get_featured_image_url'
	) )
		? urlencode( dima_helper::dima_get_featured_image_url() )
		: urlencode(
			$share_image_info[0]
		);

	$tooltip_attr = '';

	$id     = ( $id != '' ) ? 'id = "' . esc_attr( $id ) . '"' : '';
	$class  = ( $class != '' ) ? 'dima-share-icon ' . esc_attr( $class )
		: 'dima-share-icon';
	$size   = ( $size != '' ) ? ' social-' . esc_attr( $size )
		: ' social-small';
	$circle = ( $circle == true ) ? ' circle-social' : '';
	$style  = ( $style != '' ) ? 'style = "' . $style . '"' : '';

	$facebook    = ( $facebook == 'true' )
		? "<li><a href=\"#share\" {$tooltip_attr} onclick=\"window.open('http://www.facebook.com/sharer.php?u={$share_url}&amp;t={$share_title}', 'popupFacebook', 'width=650, height=270, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-facebook\"></i></a></li>"
		: '';
	$twitter     = ( $twitter == 'true' )
		? "<li><a href=\"#share\" {$tooltip_attr} onclick=\"window.open('https://twitter.com/intent/tweet?text={$share_title}&amp;url={$share_url}', 'popupTwitter', 'width=500, height=370, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-twitter\"></i></a></li>"
		: '';
	$google_plus = ( $google_plus == 'true' )
		? "<li><a href=\"#share\" {$tooltip_attr} onclick=\"window.open('https://plus.google.com/share?url={$share_url}', 'popupGooglePlus', 'width=650, height=226, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-google-plus\"></i></a></li>"
		: '';
	$linkedin    = ( $linkedin == 'true' )
		? "<li><a href=\"#share\" {$tooltip_attr} onclick=\"window.open('http://www.linkedin.com/shareArticle?mini=true&amp;url={$share_url}&amp;title={$share_title}&amp;summary={$share_content}&amp;source={$share_source}', 'popupLinkedIn', 'width=610, height=480, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-linkedin\"></i></a></li>"
		: '';
	$pinterest   = ( $pinterest == 'true' )
		? "<li><a href=\"#share\" {$tooltip_attr}  onclick=\"window.open('http://pinterest.com/pin/create/button/?url={$share_url}&amp;media={$share_image}&amp;description={$share_title}', 'popupPinterest', 'width=750, height=265, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-pinterest\"></i></a></li>"
		: '';
	$reddit      = ( $reddit == 'true' )
		? "<li><a href=\"#share\" {$tooltip_attr} onclick=\"window.open('http://www.reddit.com/submit?url={$share_url}', 'popupReddit', 'width=875, height=450, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-reddit\"></i></a></li>"
		: '';
	$vk          = ( $vk != 'true' ) ? "<li><a href=\"#share\" {$tooltip_attr} title=\"" . __( 'Share on Vk', 'noor-assistant' ) . "\" onclick=\"window.open('http://vk.com/share.php?url={$share_url}&amp;title={$share_title}&amp;description={$share_content}', 'popupVk', 'width=875, height=450, resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0'); return false;\"><i class=\"fa fa-vk\"></i></a></li>" : '';

	$email = ( $email == 'true' ) ? "<li><a href=\"mailto:?subject="
	                                . get_the_title() . "&amp;body=" . __(
		                                'Hey, thought you might enjoy this! Check it out when you have a chance:',
		                                'noor-assistant'
	                                ) . " " . get_permalink()
	                                . "\" {$tooltip_attr} class=\"email\" title=\"" . __(
		                                'Share via Email', 'noor-assistant'
	                                ) . "\"><span><i class=\"fa fa-envelope\"></i></span></a>" : '';


	switch ( $float ) {
		case 'end' :
			$float = ' text-end';
			break;
		case 'start' :
			$float = ' text-start';
			break;
		case 'center' :
			$float = ' text-center';
			break;
		default :
			$float = '';

	}

	//social-media text-start fill-icon dima_add_hover social-small circle-social
	$output = "<div {$id} class=\"{$class}\" {$style}>"
	          . "<div class=\"social-media fill-icon dima-social-post dima_add_hover{$size}{$circle}{$float}\">"
	          . "<ul class=\"inline clearfix\">"
	          . $facebook . $twitter . $google_plus . $linkedin . $vk . $pinterest . $reddit
	          . $email
	          . "</ul>"
	          . "</div>"
	          . "</div>";

	return $output;
}

add_shortcode( 'share', 'dima_shortcode_share_post' );