<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Protected Content
 *
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_protected( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => ''
			), $atts, 'protect'
		)
	);

	GLOBAL $user_login;

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'dima-protect ' . esc_attr( $class )
		: 'dima-protect';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	if ( is_user_logged_in() ) {
		$output = do_shortcode( $content );
	} else {
		$output = "<div {$id} class=\"box {$class}\" {$style}>"
		          . '<form action="' . esc_url( site_url( 'wp-login.php' ) )
		          . '" method="post" class="mbn">'
		          . '<h3>' . esc_html__( 'Restricted Content Login', 'noor-assistant' )
		          . '</h3>'
		          . '<p class="form-row-wide">'
		          . '<label for="username">' . esc_html__(
			          'Username or email address', 'noor-assistant'
		          ) . ' <span class="required">*</span></label>'
		          . '<input class="input-text" name="username" id="username" value="'
		          . esc_attr( $user_login ) . '" type="text">'
		          . '</p>'

		          . '<p class="form-row-wide">'
		          . '  <label for="password">' . esc_html__(
			          'Password', 'noor-assistant'
		          ) . ' <span class="required">*</span></label>'
		          . '  <input class="input-text" name="password" id="password" type="password">'
		          . '</p>'
		          . '<p class="form-row no-bottom-margin">'
		          . '<input type="hidden" name="redirect_to" value="' . esc_url(
			          get_permalink()
		          ) . '">'
		          . '<input class="button" name="login" value="' . esc_html__(
			          'Login', 'noor-assistant'
		          ) . '" type="submit">'
		          . '</p>'
		          . '</form>'
		          . '</div>';
	}

	return $output;
}

add_shortcode( 'protect', 'dima_shortcode_protected' );