<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function image_shortcode_image( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'                => '',
				'class'             => '',
				'style'             => '',
				'type'              => '',
				'width'             => '',
				'float'             => '',
				'src'               => '',
				'alt'               => '',
				'href'              => '',
				'shape'             => '',
				'title'             => '',
				'target'            => '',
				'popup_type'        => '',
				'popup_place'       => '',
				'popup_trigger'     => '',
				'popup_content'     => '',
				'hover'             => '',
				'lightbox'          => '',
				'is_gallert_item'   => 'false',
				'apply_gray'        => 'false',
				'dvc_source'        => 'media_library',
				'custom_srcs'       => '',
				'img_size'          => 'full',
				'external_img_size' => '',
				'animation'         => '',
				'delay'             => '',
				'delay_offset'      => '',
				'delay_duration'    => '',
			), $atts, 'image'
		)
	);

	$id         = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class      = ( $class != '' ) ? ' dima-img ' . esc_attr( $class )
		: 'dima-img ';
	$width      = ( $width != '' ) ? ' columns-' . esc_attr( $width ) : '';
	$style      = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$shape      = ( $shape != '' ) ? ' ' . $shape : '';
	$float      = ( $float != '' ) ? esc_attr( $float ) : '';
	$src        = ( $src != '' ) ? $src : '';
	$alt        = ( $alt != '' ) ? 'alt="' . $alt . '"' : 'alt=""';
	$title      = ( $title != '' ) ? 'title="' . $title . '"' : '';
	$target     = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';
	$apply_gray = ( $apply_gray == 'true' ) ? ' apply-gray' : '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	$caption = get_post( $src );

	if ( $caption != '' ) {
		$caption = ' data-caption = "' . $caption->post_excerpt . '" ';
	}

	if ( $lightbox != '' ) {
		switch ( $lightbox ) {
			case 'image':
				$lightbox = 'data-fancybox ' . $caption . '';
				break;
			case 'iframe_two':
				$lightbox = 'data-fancybox data-type="iframe" data-src="' . $href . '" ' . $caption . ' href="javascript:;"';
				break;
			default:
				$lightbox = 'data-fancybox ' . $caption . '';
				break;
		}
		if ( $is_gallert_item == 'true' ) {
			$lightbox = 'data-fancybox="gallery" ' . $caption . '';
			$class    .= ' dima-gallery-item';
		}
	}

	switch ( $dvc_source ) {
		case 'media_library':
			$img_id = preg_replace( '/[^\d]/', '', $src );
			if ( preg_match( '/_circle_2$/', $style ) ) {
				$style    = preg_replace( '/_circle_2$/', '_circle', $style );
				$img_size = $this->getImageSquareSize( $img_id, $img_size );
			}

			if ( ! $img_size ) {
				$img_size = 'medium';
			}

			$img = wpb_getImageBySize( array(
				'attach_id'  => $img_id,
				'thumb_size' => $img_size,
				'class'      => 'dima_image-img',
			) );

			$poster_info        = wp_get_attachment_image_src( $img_id, 'full' );
			$img['p_img_large'] = $poster_info[0];

			if ( ! empty( $lightbox ) ) {
				$href = ( $href == '' ) ? $img['p_img_large'] : $href;
			}

			break;

		case 'external_link':
			$dimensions = vcExtractDimensions( $external_img_size );
			$hwstring   = $dimensions ? image_hwstring( $dimensions[0], $dimensions[1] ) : '';
			$srcs       = $custom_srcs ? $custom_srcs : $default_src;

			$img = array(
				'thumbnail' => '<img ' . $alt . ' ' . $hwstring . ' src="' . $srcs . '" />',
			);
			if ( ! empty( $lightbox ) ) {
				$href = ( $href == '' ) ? $custom_srcs : $href;
			}

			break;

		default:
			$img = false;
	}

	if ( ! $img ) {
		$default_src      = vc_asset_url( 'vc/no_image.png' );
		$img['thumbnail'] = '<img src="' . $default_src . '" />';
	}

	$tooltip_attr = ( $popup_type != '' ) ? dima_helper::dima_tooltip_data(
		$popup_type, $popup_trigger, $popup_place, '', $popup_content
	) : '';

	$output = '';
	if ( ! empty( $href ) ) {
		if ( ! empty( $hover ) ) {

			if ( $hover == 'zoom-out' ) {
				$output
					= "<div class=\"effect-roxy\"><a {$lightbox} {$id} class=\"{$class} text-{$float}\" {$style} href=\"{$href}\" {$title} {$target} {$tooltip_attr}>{$img['thumbnail']}</a></div>";
			} elseif ( $hover == 'zoom-in' ) {
				$output
					= "<div class=\"effect-julia\"><a {$lightbox} {$id} class=\"{$class} text-{$float}\" {$style} href=\"{$href}\" {$title} {$target} {$tooltip_attr}>{$img['thumbnail']}</a></div>";
			} elseif ( $hover == 'effect-opacity' ) {
				$output
					= "<div class=\"gray-opacity\"><a {$lightbox} {$id} class=\"{$class} text-{$float}\" {$style} href=\"{$href}\" {$title} {$target} {$tooltip_attr}>{$img['thumbnail']}</a></div>";
			} elseif ( $hover == 'none' ) {
				$output
					= "<a {$lightbox} {$id} class=\"{$class} text-{$float}\" {$style} href=\"{$href}\" {$title} {$target} {$tooltip_attr}>{$img['thumbnail']}</a>";
			}

		} else {
			$output
				= "<a {$lightbox} {$id} class=\"overlay {$class} text-{$float}{$shape}\" {$style} href=\"{$href}\" {$title} {$target} {$tooltip_attr}>{$img['thumbnail']}</a>";
		}
	} else {
		$output = $img['thumbnail'];
	}

	return "<div class=\"column-item overflow-hidden text-{$float}{$width}{$apply_gray}{$shape}\" {$animation_data}>"
	       . $output . "</div>";
}

add_shortcode( 'image', 'image_shortcode_image' );