<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function dima_shortcode_iconbox_header( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'                 => '',
				'class'              => '',
				'style'              => '',
				'icon'               => '',
				'icon_svg'           => '',
				'icon_fontawesome'   => '',
				'image'              => '',
				'hover'              => '',
				'image_size'         => '',
				'alt'                => '',
				'size'               => '',
				'icon_bg'            => '',
				'icon_color'         => '',
				'shadow_color'       => '',
				'dima_vc_position'   => '',
				'dima_vc_gradient'   => '',
				'type'               => '',
				'icon_svg_size'      => '',
				'icon_svg_animation' => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'iconbox_header'
		)
	);


	$id                 = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[]           = ( $class != '' ) ? 'icon-box-header' . esc_attr( $class )
	                                         . '"' : 'icon-box-header';
	$style              = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$icon               = ( $icon != '' ) ? $icon : '';
	$icon_svg           = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$alt                = ( $alt != '' ) ? esc_attr( $alt ) : '';
	$icon_fontawesome   = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$type               = ( $type != '' ) ? ' box-' . $type : '';
	$hover              = ( $hover == 'none' ) ? '' : ' ' . $hover;
	$size               = ( $size != '' ) ? ' icon-box-' . $size
		: ' icon-box-medium';
	$image_size         = ( $image_size != '' ) ? ' ' . $image_size : ' medium';
	$icon_bg            = ( $icon_bg != '' ) ? $icon_bg : '';
	$_class[]           = ( $dima_vc_position != '' ) ? $dima_vc_position : '';
	$dima_vc_gradient   = ( $dima_vc_gradient != '' ) ? ' ' . $dima_vc_gradient
		: '';
	$icon_color         = ( $icon_color != '' ) ? $icon_color : '';
	$shadow_color       = ( $shadow_color != '' ) ? $shadow_color : '';
	$image              = ( $image != '' ) ? $image : '';
	$icon_svg_size      = ( $icon_svg_size != '' ) ? $icon_svg_size : '';
	$icon_svg_animation = ( $icon_svg_animation == 'on' ) ? 'svg_animated' : '';

	if ( $icon_svg_size != '' ) {
		$icon_svg_size = 'data-svg-size="' . $icon_svg_size . '"';
	}

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	$style_bg    = '';
	$style_color = '';
	$icon_style  = '';
	if ( empty( $type ) ) {
		$_class[] = "box-none";
	}

	if ( ! empty( $dima_vc_gradient ) ) {
		$_class[] = "dima_grd";
	}

	if ( ! empty( $icon_bg ) ) {
		$style_bg = "background-color:$icon_bg;";
	}
	if ( ! empty( $shadow_color ) ) {
		$style_bg .= "box-shadow: 0 0 0 2px $shadow_color;";
	}

	if ( ! empty( $icon_color ) ) {
		$style_color = "color:$icon_color;";
	}

	if ( ! empty( $style_bg ) || ! empty( $style_color ) ) {
		$icon_style = "style=\"$style_bg$style_color\"";
	}
	if ( $image != '' ) {
		if ( is_numeric( $image ) ) {
			$src_info   = wp_get_attachment_image_src( $image, 'full' );
			$image      = $src_info[0];
			$img_width  = 'width="' . $src_info[1] . '"';
			$img_height = 'height="' . $src_info[2] . '"';
		} else {
			$poster_info = dima_helper::dima_get_attachment_info_by_url( $image );
			$img_width   = 'width="' . $poster_info[1] . '"';
			$img_height  = 'height="' . $poster_info[2] . '"';
		}
	}

	$icon = ( $icon == '' ) ? $icon_fontawesome : $icon;

	if ( ! empty( $image ) ) {
		$icon = '<div class="image-cropper thumb ' . $image_size . ' ' . $type
		        . '' . $dima_vc_gradient . '' . $hover . ' " ' . $icon_style . '>'
		        . '<img class="background-image" src="' . $image . '" ' . $img_width
		        . ' ' . $img_height . ' alt="' . $alt . '">'
		        . '</div>';
	} else if ( ! empty( $icon_svg ) ) {
		$icon = '<span ' . $icon_style . ' class="svg_icon ' . $icon_svg_animation . '' . $icon . '' . $type . $size
		        . ' ' . $hover . '' . $dima_vc_gradient . '" ' . $icon_svg_size . '>'
		        . $icon_svg
		        . '</span>';
	} else {
		$i    = '<i class="' . $icon . '"></i>';
		$icon = '<span ' . $icon_style . ' class="' . $type . ' ' . $hover
		        . $size . '' . $dima_vc_gradient . '">'
		        . $i
		        . '</span>';
	}

	if ( ! empty( $_class ) ) {
		$class = join( ' ', $_class );
	}
	$output = '<header ' . $id . ' class="' . $class . '" ' . $animation_data . ' ' . $style . '>'
	          . $icon
	          . '</header>';

	return $output;

}

add_shortcode( 'iconbox_header', 'dima_shortcode_iconbox_header' );

function dima_shortcode_iconbox_content( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'          => '',
				'class'       => '',
				'style'       => '',
				'title'       => '',
				'title_color' => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'iconbox_content'
		)
	);

	$id             = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class          = ( $class != '' ) ? esc_attr( $class ) . ' ' : '';
	$style          = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$title          = ( $title != '' ) ? $title : '';
	$title_color    = ( $title_color != '' ) ? 'style="color:' . $title_color . ';"'
		: '';
	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	$output = '<div ' . $id . ' class="' . $class . 'features-content" ' . $animation_data . ' '
	          . $style . '>'
	          . '<h5 class="features-title" ' . $title_color . '>'
	          . $title
	          . '</h5><span class="dima-divider line-center line-hr small-line"></span>';
	$output .= do_shortcode( shortcode_unautop( $content ) );
	$output .= '</div>';

	return $output;
}

add_shortcode( 'iconbox_content', 'dima_shortcode_iconbox_content' );