<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * OK Grids
 *   1 Container
 *   2 Row
 *   3 Column
 */
/**
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_container( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'        => '',
				'class'     => '',
				'style'     => '',
				'no_margin' => '',
			), $atts, 'container'
		)
	);

	$id        = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class     = ( esc_attr( $class ) ) ? 'container inner-container ' . esc_attr( $class )
		: 'container inner-container';
	$style     = ( $style != '' ) ? 'style=' . $style : '';
	$no_margin = ( $no_margin == 'false' ) ? ' no-margin' : '';

	$output
		= "<div {$id} class=\"{$class}\" {$style}><div class=\"ok-row{$no_margin}\">"
		  . do_shortcode( $content ) . "</div></div>";

	return $output;
}

add_shortcode( 'container', 'dima_shortcode_container' );

function dima_shortcode_content_columns( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'             => '',
				'class'          => '',
				'style'          => '',
				'xld'            => '',
				'ld'             => '',
				'md'             => '',
				'sd'             => '6',
				'xsd'            => '12',
				'visibility_xld' => '',
				'visibility_ld'  => '',
				'visibility_md'  => '',
				'visibility_sd'  => '',
				'visibility_xsd' => '',
				'offset_xld'     => '',
				'offset_ld'      => '',
				'offset_md'      => '',
				'offset_sd'      => '',
				'offset_xsd'     => '',
				'animation'      => '',
				'delay'          => '',
				'offset'         => '',
				'bg_image'       => '',
			), $atts, 'column'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[] = ( esc_attr( $class ) ) ? esc_attr( $class ) : '';
	$_class[] = ( esc_attr( $xld ) ) ? 'ok-xld-' . esc_attr( $xld ) : '';
	$_class[] = ( esc_attr( $ld ) ) ? 'ok-ld-' . esc_attr( $ld ) : '';
	$_class[] = ( esc_attr( $md ) ) ? 'ok-md-' . esc_attr( $md ) : '';
	$_class[] = ( esc_attr( $sd ) ) ? 'ok-sd-' . esc_attr( $sd ) : '';
	$_class[] = ( esc_attr( $xsd ) ) ? 'ok-xsd-' . esc_attr( $xsd ) : '';

	if ( $visibility_xld != '' ) {
		$visibility_xld = explode( ',', $visibility_xld );
		$_class[]          = ( esc_attr( $visibility_xld[0] ) != '' ) ? ''. esc_attr( $visibility_xld[0] ) . '-xld' : '';
	}
	if ( $visibility_ld != '' ) {
		$visibility_ld = explode( ',', $visibility_ld );
		$_class[]         = ( esc_attr( $visibility_ld[0] ) != '' ) ? '' . esc_attr($visibility_ld[0]
			) . '-ld' : '';
	}
	if ( $visibility_md != '' ) {
		$visibility_md = explode( ',', $visibility_md );
		$_class[]         = ( esc_attr( $visibility_md[0] ) != '' ) ? '' . esc_attr($visibility_md[0]
			) . '-md' : '';
	}
	if ( $visibility_sd != '' ) {
		$visibility_sd = explode( ',', $visibility_sd );
		$_class[]         = ( esc_attr( $visibility_sd[0] ) != '' ) ? '' . esc_attr(
				$visibility_sd[0]
			) . '-sd' : '';
	}
	if ( $visibility_xsd != '' ) {
		$visibility_xsd = explode( ',', $visibility_xsd );
		$_class[]          = ( esc_attr( $visibility_xsd[0] ) != '' ) ? ''. esc_attr( $visibility_xsd[0] ) . '-xsd' : '';
	}

	$_class[]     = ( esc_attr( $offset_xld ) != '' ) ? 'ok-offset-xld-' . esc_attr(
			$offset_xld
		) : '';
	$_class[]     = ( esc_attr( $offset_ld ) != '' ) ? 'ok-offset-ld-' . esc_attr(
			$offset_ld
		) : '';
	$_class[]     = ( esc_attr( $offset_md ) != '' ) ? 'ok-offset-md-' . esc_attr(
			$offset_md
		) : '';
	$style     = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$animation = ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$delay     = ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$offset    = ( $offset != '' ) ? ' data-offset=' . $offset . '' : '';
	$bg_image  = ( $bg_image != '' ) ? $bg_image : '';
	$bg_holder = '';
	if ( ! empty( $bg_image ) ) {
		$bg_holder = '<div class="background-image-holder">'
		             . '<img src="' . $bg_image . '" alt="">'
		             . '</div>';
		$_class[]    = 'set-parent-height';
	}
	$row_class_no    = dima_helper::dima_remove_white_space( esc_attr( trim( implode( ' ', $_class ) ) ) );

	$output
		= "<div {$id} class=\"{$row_class_no}\" {$style} {$animation}{$delay}{$offset}>"
		  . $bg_holder
		  . do_shortcode( $content )
		  . "</div>";


	return $output;
}

add_shortcode( 'column', 'dima_shortcode_content_columns' );