<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Gallery
 *   1 Gallery Item (image)
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_gallery( $atts, $content = null ) { // 1
	extract(
		shortcode_atts(
			array(
				'id'     => '',
				'class'  => '',
				'column' => '',
				'style'  => ''
			), $atts, 'dima_gallery'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'dima-content-gallery ' . esc_attr( $class )
		: 'dima-content-gallery';
	$class .= ( $column != '' ) ? ' columns-' . esc_attr( $column ) : '';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output
		= "<div {$id} class=\"{$class}\" {$style}>"
		  . do_shortcode( $content )
		  . "</div>";

	return $output;
}

add_shortcode( 'dima_gallery', 'dima_shortcode_gallery' );