<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Dropcap
 *
 * @param $atts
 *
 * @return string
 */


function dima_shortcode_dropcap( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'        => '',
				'class'     => '',
				'character' => '',
				'type'      => '',//dropcap-1,dropcap-3,dropcap-3
				'style'     => ''
			), $atts, 'dropcap'
		)
	);

	$id        = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class     = ( $class != '' ) ? 'dropcap ' . esc_attr( $class ) : 'dropcap';
	$character = ( $character == '' ) ? '!' : esc_attr( $character );
	$type      = ( $type != '' ) ? ' ' . esc_attr( $type ) : ' dropcap-1';
	$style     = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output
		= "<span {$id} class=\"{$class}{$type}\" {$style}>{$character}</span>";

	return $output;
}

add_shortcode( 'dropcap', 'dima_shortcode_dropcap' );
