<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Line
 */
function dima_shortcode_line( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'type'  => '',//double,dashed
				'style' => ''
			), $atts, 'line'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'divider ' . esc_attr( $class ) : 'divider';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	if ( $type != '' ) {
		$output = "<div {$id} class=\"{$class}\" {$style}>"
		          . "<div class=\"{$type}\"></div>"
		          . "</div>";
	} else {
		$output = "<hr>";
	}

	return $output;
}

add_shortcode( 'line', 'dima_shortcode_line' );


function dima_shortcode_divider( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'icon'             => '',
				'icon_fontawesome' => '',
				'divider_style'    => '',
				'icon_svg'         => '',
				'icon_color'       => '',
				'line_color'       => '',
				'direction'        => '',
				'style'            => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'divider'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class            = ( $class != '' ) ? 'dima-divider ' . esc_attr( $class )
		: 'dima-divider ';
	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$icon_color       = ( $icon_color != '' ) ? 'style="color:' . $icon_color
	                                            . ';"' : '';
	$line_color       = ( $line_color != '' ) ? 'data-bg-color=' . $line_color
	                                            . '' : '';
	$_icon            = ( $icon != '' ) ? $icon : '';
	$divider_style    = ( $divider_style != '' ) ? $divider_style : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$_icon            = ( $_icon == '' ) ? $icon_fontawesome : $_icon;
	$output           = '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	if ( ! empty( $icon_svg ) ) {
		$_icon = '<span ' . $icon_color . '>' . $icon_svg . '<span>';
	} else if ( ! empty( $_icon ) ) {
		$_icon = '<i class="' . $_icon . '" ' . $icon_color . '></i>';
	}

	switch ( $divider_style ) {
		case 'line':
			$output
				= "<div {$id} class=\"{$class}  line-hr line-{$direction}\" {$animation_data} {$style} {$line_color}>"
				  . "</div>";
			break;

		case
		'noor_divider':
			$output
				= "<div {$id} class=\"noor-line {$class} noor-{$direction}\" {$animation_data} {$style}>"
				  . "</div>";
			break;
		case 'icon':
			$output = "<div {$id} class=\"{$class} topaz-line\" {$animation_data} {$style}>"
			          . "{$_icon}"
			          . "</div>";
			break;

	}

	return
		$output;
}

add_shortcode( 'divider', 'dima_shortcode_divider' );