<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function dima_shortcode_custom_heading( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'                 => '',
				'class'              => '',
				'style'              => '',
				'float'              => '',
				'level'              => '',
				'icon'               => '',
				'icon_svg'           => '',
				'icon_fontawesome'   => '',
				'dima_heading_color' => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'custom_heading'
		)
	);
	$uniq_id = uniqid();
	$id      = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class   = ( $class != '' ) ? 'dima-custom-heading ' . esc_attr( $class ) : 'dima-custom-heading';

	if ( $dima_heading_color != '' ) {
		$dima_heading_color = 'color:' . $dima_heading_color . '';
		$class              = ( $class != '' ) ? 'dima-custom-heading heading-' . $uniq_id . ' ' . esc_attr( $class ) : 'dima-custom-heading heading-' . $uniq_id . '';
		$el                 = '.heading-' . $uniq_id . '';
		DIMA_Style::dima_addCSS( $el . '{'
		                         . $dima_heading_color
		                         . '}', $uniq_id );
	}

	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon             = ( $icon != '' ) ? '<i  class="' . $icon . '"></i>' : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? '<i class="' . $icon_fontawesome . '"></i> ' : '';
	$icon             = ( $icon == '' ) ? $icon_fontawesome : $icon;

	if ( ! empty( $icon_svg ) ) {
		$icon = $icon_svg;
	}

	$level = ( $level != '' ) ? $level : 'h1';
	$float = ( $float != '' ) ? $float : '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	switch ( $float ) {
		case 'end' :
			$float = ' text-end';
			break;
		case 'start' :
			$float = ' text-start';
			break;
		case 'center' :
			$float = ' text-center';
			break;
		default :
			$float = '';
	}

	$output = "<{$level} {$id} class=\"{$class}{$float}\" {$style} {$animation_data} >{$icon}" . do_shortcode( $content ) . "</{$level}>";

	return $output;

}

add_shortcode( 'custom_heading', 'dima_shortcode_custom_heading' );