<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Counter
 */

function dima_shortcode_counter( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'style'            => '',
				'icon'             => '',
				'icon_fontawesome' => '',
				'icon_svg'         => '',
				'num_color'        => '',
				'text_color'       => '',
				'bg_color'         => '',
				'icon_color'       => '',
				'num_start'        => '',
				'num_end'          => '',
				'duration'        => '',
				'num_before'       => '',
				'num_after'        => '',
				'border'           => '',
				'dima_box_shadow'  => 'false',
				'float'            => 'center',
				'text'             => '',
				'formatter'        => ',',
				'decimal'          => '.',
				'decimals'         => 0,

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'counter'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class            = ( $class != '' ) ? 'countUp ' . esc_attr( $class )
		: 'countUp ';
	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$num_before       = ( $num_before != '' ) ? $num_before : '';
	$num_after        = ( $num_after != '' ) ? $num_after : '';
	$class            .= ( $float != '' ) ? 'text-' . $float : 'text-center';
	$num_color        = ( $num_color != '' ) ? 'style="color: ' . $num_color
	                                           . ';"' : '';
	$bg_color         = ( $bg_color != '' ) ? 'style="background: ' . $bg_color
	                                          . ';"' : '';
	$num_start        = ( $num_start != '' ) ? $num_start : 0;
	$num_end          = ( $num_end != '' ) ? $num_end : 0;
	$duration        = ( $duration != '' ) ? $duration : 2.5;
	$formatter        = ( $formatter != '' ) ? $formatter : '';
	$decimal          = ( $decimal != '' ) ? $decimal : '.';
	$decimals         = ( $decimals != '' ) ? $decimals : 0;
	$text_color       = ( $text_color != '' ) ? 'style="color: ' . $text_color
	                                            . ';"' : '';
	$icon_color       = ( $icon_color != '' ) ? 'style="color: ' . $icon_color
	                                            . ';"' : '';
	$class            .= ( $dima_box_shadow == 'true' ) ? ' dima-box-shadow' : '';
	$_icon            = ( $icon != '' ) ? $icon : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$_icon            = ( $_icon == '' ) ? $icon_fontawesome : $_icon;

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	if ( ! empty( $icon_svg ) ) {
		$_icon = '<sapn ' . $icon_color . '  class="icon-count">' . $icon_svg
		         . '</sapn>';
	} else if ( ! empty( $_icon ) ) {
		if ( ! empty( $icon_fontawesome ) ) {
			$_icon = '<sapn ' . $icon_color . '  class="icon-count">' .
			         '<i ' . $icon_color . ' class="' . $_icon . '"></i>' .
			         '</sapn>';
		} else {
			$_icon = '<i ' . $icon_color . ' class="icon-count ' . $_icon
			         . '"></i>';
		}
	}

	$text       = ( $text != '' ) ? '<div class="text" ' . $text_color . '>'
	                                . $text . '</div>' : '';
	$icon_class = ( $_icon != '' ) ? " with-icon" : '';
	$border     = ( $border == true ) ? " add-border" : '';

	$output
		= "<div {$id} {$animation_data} class=\"{$class}{$icon_class}{$border}\" {$style} {$bg_color}>"
		  . $_icon
		  . "<div class=\"number\" {$num_color}>"
		  . "$num_before"
		  . "<span class=\"number-count\" data-from=\"{$num_start}\" data-to=\"{$num_end}\" data-formatter=\"{$formatter}\" data-duration=\"{$duration}\" data-decimals=\"{$decimals}\" data-decimal=\"{$decimal}\">{$num_start}</span>"
		  . "$num_after"
		  . "<span class=\"dima-divider line-{$float} line-hr small-line\"></span>"
		  . $text
		  . '</div>'
		  . '</div>';

	return $output;
}

add_shortcode( 'counter', 'dima_shortcode_counter' );