<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * clients
 *   1 client
 */

function dima_shortcode_clients( $atts, $content = null ) { // 2
	extract(
		shortcode_atts(
			array(
				'id'      => '',
				'class'   => '',
				'columns' => '',//7,6,5,4,3
				'style'   => ''
			), $atts, 'clients'
		)
	);

	$id      = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class   = ( $class != '' ) ? 'clients-wrapper grid ' . esc_attr( $class )
		: 'clients-wrapper grid';
	$columns = ( $columns != '' ) ? '  client-clm-' . esc_attr( $columns )
		: ' client-clm-6';
	$style   = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<div {$id} class=\"{$class}{$columns}\" {$style}>"
	          . "<ul>" . do_shortcode( $content ) . "</ul>"
	          . "</div>";

	return $output;
}

add_shortcode( 'clients', 'dima_shortcode_clients' );

function dima_shortcode_client( $atts, $content = null ) { // 2
	extract(
		shortcode_atts(
			array(
				'id'     => '',
				'class'  => '',
				'href'   => '',
				'target' => '',
				'src'    => '',
				'alt'    => '',
				'style'  => ''
			), $atts, 'client'
		)
	);

	$id     = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class  = ( $class != '' ) ? 'slide-item ' . esc_attr( $class ) : 'slide-item';
	$style  = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$href   = ( $href != '' ) ? $href : '';
	$alt    = ( $alt != '' ) ? esc_attr( $alt ) : '';
	$src    = ( $src != '' ) ? $src : '';
	$target = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';

	if ( is_numeric( $src ) ) {
		$src_info = wp_get_attachment_image_src( $src, 'full' );
		$src      = $src_info[0];
	}

	if ( empty( $href ) ) {
		$output = "<li {$id} class=\"{$class}\" {$style}><img src=\"{$src}\" alt=\"{$alt}\"></li>";
	} else {
		$output = "<li {$id} class=\"{$class}\" {$style}><a href=\"$href\" {$target}><img src=\"{$src}\" alt=\"{$alt}\"></a></li>";
	}

	return $output;
}

add_shortcode( 'client', 'dima_shortcode_client' );