<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Post Author
 */

function dima_shortcode_author( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'        => '',
				'class'     => '',
				'style'     => '',
				'title'     => '',
				'author_id' => ''
			), $atts, 'author'
		)
	);

	$id        = ( $id != '' ) ? 'id = "' . esc_attr( $id ) . '"' : '';
	$class     = ( $class != '' ) ? 'dima-author-box clearfix ' . esc_attr( $class )
		: 'dima-author-box clearfix';
	$style     = ( $style != '' ) ? 'style = "' . $style . '"' : '';
	$title     = ( $title != '' ) ? $title : __( 'Author: ', 'noor-assistant' );
	$author_id = ( $author_id != '' ) ? $author_id : get_the_author_meta( 'ID' );

	$description  = get_the_author_meta( 'description', $author_id );
	$display_name = get_the_author_meta( 'display_name', $author_id );
	$facebook     = get_the_author_meta( 'facebook', $author_id );
	$instagram    = get_the_author_meta( 'instagram', $author_id );
	$linkedin     = get_the_author_meta( 'linkedin', $author_id );
	$twitter      = get_the_author_meta( 'twitter', $author_id );
	$googleplus   = get_the_author_meta( 'googleplus', $author_id );
	$flickr       = get_the_author_meta( 'flickr', $author_id );
	$youtube      = get_the_author_meta( 'youtube', $author_id );
	$pinterest    = get_the_author_meta( 'pinterest', $author_id );
	$behance      = get_the_author_meta( 'behance', $author_id );
	$dribbble     = get_the_author_meta( 'dribbble', $author_id );

	$facebook_output   = ( $facebook ) ? "<li><a href=\"{$facebook}\"  title=\"" . esc_attr__( 'Visit the Facebook Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-facebook\"></i></a></li>" : '';
	$twitter_output    = ( $twitter ) ? "<li><a href=\"{$twitter}\"  title=\"" . esc_attr__( 'Visit the Twitter Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-twitter\"></i></a></li>" : '';
	$googleplus_output = ( $googleplus ) ? "<li><a href=\"{$googleplus}\"  title=\"" . esc_attr__( 'Visit the Google+ Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-google-plus\"></i></a></li>" : '';
	$instagram_output  = ( $instagram ) ? "<li><a href=\"{$instagram}\"  title=\"" . esc_attr__( 'Visit the instagram Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-instagram\"></i></a></li>" : '';
	$linkedin_output   = ( $linkedin ) ? "<li><a href=\"{$linkedin}\"  title=\"" . esc_attr__( 'Visit the linkedin Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-linkedin\"></i></a></li>" : '';
	$flickr_output     = ( $flickr ) ? "<li><a href=\"{$flickr}\"  title=\"" . esc_attr__( 'Visit the flickr Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-flickr\"></i></a></li>" : '';
	$youtube_output    = ( $youtube ) ? "<li><a href=\"{$youtube}\"  title=\"" . esc_attr__( 'Visit the youtube Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-youtube\"></i></a></li>" : '';
	$pinterest_output  = ( $pinterest ) ? "<li><a href=\"{$pinterest}\"  title=\"" . esc_attr__( 'Visit the pinterest Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-pinterest\"></i></a></li>" : '';
	$behance_output    = ( $behance ) ? "<li><a href=\"{$behance}\"  title=\"" . esc_attr__( 'Visit the behance Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-behance\"></i></a></li>" : '';
	$dribbble_output   = ( $dribbble ) ? "<li><a href=\"{$dribbble}\"  title=\"" . esc_attr__( 'Visit the dribbble Profile for', 'noor-assistant' ) . " {$display_name}\" target=\"_blank\"><i class=\"fa fa-dribbble\"></i></a></li>" : '';

	$output = "<div {$id} class=\"{$class}\" {$style}>"
	          . "<div class=\"dima-about-image circle\">"
	          . get_avatar( $author_id, 150 )
	          . "</div>"
	          . "<div class=\"dima-author-info\">"
	          . "<h5 class=\"dima-author-name\">{$title}<a href=\""
	          . get_author_posts_url( get_the_author_meta( 'ID' ) )
	          . "\">{$display_name}</a></h5>"
	          . "<p>{$description}</p>"
	          . "<div class=\"social-media text-start fill-icon dima_add_hover social-small circle-social\">"
	          . "<ul class=\"inline clearfix\">"
	          . $facebook_output
	          . $twitter_output
	          . $googleplus_output
	          . $instagram_output
	          . $linkedin_output
	          . $flickr_output
	          . $youtube_output
	          . $pinterest_output
	          . $behance_output
	          . $dribbble_output
	          . "</ul>"
	          . "</div>"
	          . "</div >"
	          . "</section >";

	return $output;
}

add_shortcode( 'author', 'dima_shortcode_author' );