<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function dima_shortcode_audio_player( $atts ) { // 1
	extract(
		shortcode_atts(
			array(
				'id'       => '',
				'class'    => '',
				'style'    => '',
				'mp3'      => '',
				'oga'      => '',
				'preload'  => '',
				'autoplay' => '',

				'producers' => '',
				'author'    => '',

				'loop' => ''
			), $atts, 'dima_audio_player'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class    = ( $class != '' ) ? 'dima-audio player ' . esc_attr( $class )
		: 'dima-audio player';
	$style    = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$mp3      = ( $mp3 != '' ) ? '<source src="' . $mp3 . '" type="audio/mpeg">'
		: '';
	$oga      = ( $oga != '' ) ? '<source src="' . $oga . '" type="audio/ogg">'
		: '';
	$preload  = ( $preload != '' ) ? ' preload="' . $preload . '"'
		: ' preload="none"';
	$autoplay = ( $autoplay == 'true' ) ? ' autoplay' : '';
	$loop     = ( $loop == 'true' ) ? ' loop' : '';

	wp_enqueue_script( 'wp-mediaelement' );
	wp_enqueue_style( 'wp-mediaelement' );

	$data = dima_creat_data_attributes( 'audio-video' );

	$comp     = '';
	$producer = ( $producers != '' ) ? $producers : '';
	$author   = ( $author != '' ) ? $author : '';
	$out      = ( $author != '' ) ? "<span><h6>" . esc_attr( $author ) . "</h6></span>" : '';
	if ( $producer != '' && $author != '' ) {
		$out .= "<span class=\"sep\">|</span>";
	}
	$out .= ( $producer != '' ) ? "<span><h6>" . esc_attr( $producer ) . "</h6></span>" : '';
	if ( $out != '' ) {
		$comp = "<div class='clearfix dima-composition'>
        			 $out
    			 </div>";

	}

	$output
		= "<div {$id} class=\"{$class}{$autoplay}{$loop}\" {$data} {$style}>"
		  . "<audio class=\"audio-video\" {$preload} {$autoplay}{$loop}>"
		  . $mp3
		  . $oga
		  . '</audio>'
		  . '</div>'
		  . $comp;

	return $output;
}

add_shortcode( 'dima_audio_player', 'dima_shortcode_audio_player' );


function dima_shortcode_embed_audio( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => ''
			), $atts, 'dima_embed_audio'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'dima-audio embed ' . esc_attr( $class )
		: 'x-audio embed';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<div {$id} class=\"{$class}\" {$style}>{$content}</div>";

	return $output;
}

add_shortcode( 'dima_embed_audio', 'dima_shortcode_embed_audio' );



/**
 * Video
 *   1 Embed Video
 */

function dima_shortcode_video_player( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'            => '',
				'class'         => '',
				'style'         => '',
				'type'          => '',
				'm4v'           => '',
				'ogv'           => '',
				'webm'          => '',
				'poster_img'    => '',
				'preload'       => '',
				'hide_controls' => 'false',
				'autoplay'      => 'false',
				'loop'          => 'false',
				'muted'         => 'false',
			), $atts, 'dima_video_player'
		)
	);

	$id            = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class         = ( $class != '' ) ? 'dima-video player ' . esc_attr( $class )
		: 'dima-video player';
	$style         = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$type          = '';
	$m4v           = ( $m4v != '' ) ? '<source src="' . $m4v . '" type="video/mp4">' : '';
	$ogv           = ( $ogv != '' ) ? '<source src="' . $ogv . '" type="video/ogg">' : '';
	$webm          = ( $webm != '' ) ? '<source src="' . $webm . '" type="video/webm">' : '';
	$poster        = ( $poster_img != '' ) ? $poster_img : '';
	$preload       = ( $preload != '' ) ? ' preload="' . $preload . '"' : ' preload="none"';
	$hide_controls = ( $hide_controls != 'false' ) ? ' hide-controls' : '';
	$autoplay      = ( $autoplay != 'false' ) ? ' autoplay' : '';
	$loop          = ( $loop != 'false' ) ? ' loop' : '';
	$muted         = ( $muted != 'false' ) ? ' muted' : '';

	if ( is_numeric( $poster ) ) {
		$poster_info = wp_get_attachment_image_src( $poster, 'full' );
		$poster      = $poster_info[0];
	}
	$poster_attr = ( $poster != '' ) ? ' poster="' . $poster . '"' : '';

	wp_enqueue_script( 'wp-mediaelement' );
	wp_enqueue_style( 'wp-mediaelement' );

	$data = dima_creat_data_attributes( 'audio-video' );

	$output
		= "<div {$id} class=\"{$class}{$hide_controls}\" {$data} {$style}>"
		  . "<div class=\"dima-video-wrapper{$type}\">"
		  . "<video class=\"audio-video\"{$poster_attr}{$preload}{$autoplay}{$loop}{$muted}>"
		  . $m4v
		  . $ogv
		  . $webm
		  . '</video>'
		  . '</div>'
		  . '</div>';


	return $output;
}

add_shortcode( 'dima_video_player', 'dima_shortcode_video_player' );

function dima_shortcode_embed_video( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'     => '',
				'class'  => '',
				'style'  => '',
				'poster' => '',
			), $atts, 'dima_embed_video'
		)
	);

	$id     = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class  = ( $class != '' ) ? 'dima-video embed ' . esc_attr( $class ) : 'dima-video embed';
	$style  = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$poster = ( $poster != '' ) ? $poster : '';

	static $count = 0;
	$count ++;
	if ( ! empty( $poster ) ) {
		$output = "<div class='video-overlay' data-bg=\"{$poster}\">"
		          . "<div class='video-overlay-hover'>"
		          . "<a href='#' class='video-play-button'></a>"
		          . "</div>"
		          . "</div>"
		          . "<div {$id}  class=\"{$class}\" {$style}><div class=\"embed-responsive embed-responsive-16by9\">{$content}</div>"
		          . "</div>";
	} else {
		$output
			= "<div {$id}  class=\"{$class}\" {$style}><div class=\"embed-responsive embed-responsive-16by9\">{$content}</div>"
			  . "</div>";

	}

	return $output;
}

add_shortcode( 'dima_embed_video', 'dima_shortcode_embed_video' );
