<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Alert
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_alert( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'style'            => '',
				'alert_style'      => 'one',
				'type'             => '',
				'is_icon'          => '',
				'bg_color'         => '',
				'heading'          => '',
				'icon'             => '',
				'icon_fontawesome' => '',
				'icon_svg'         => '',
				'close'            => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'alert'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class            = ( $class != '' ) ? 'dima-alert ' . esc_attr( $class )
		: 'dima-alert';
	$style            = ( $bg_color != '' ) ? "background:$bg_color;" : '';
	$style            = ( $style != '' ) ? 'style="' . $style . '' . $bg_color
	                                       . '"' : '';
	$type             = ( $type != '' ) ? ' dima-alert-' . $type
		: ' dima-alert-info';
	$heading          = ( $heading != '' ) ?
		$heading = '<em class="header-alert">' . $heading . '</em>'
		: $heading = '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? '<i class="'
	                                                  . $icon_fontawesome . '"></i>' : '';
	$alert_style      = ( $alert_style != '' ) ? $alert_style : '';


	$_icon            = ( $icon != '' ) ? $icon : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$_icon            = ( $_icon == '' ) ? $icon_fontawesome : $_icon;

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	if ( ! empty( $icon_svg ) ) {
		$_icon = $icon_svg;
	}

	if ( $is_icon == 'true' ) {

		switch ( $type ) {
			case ' dima-alert-warning':
				$is_icon = dima_get_svg_icon( "ic_warning" );
				break;
			case ' dima-alert-info':
				$is_icon = dima_get_svg_icon( "ic_info" );
				break;
			case ' dima-alert-error':
				$is_icon = dima_get_svg_icon( "ic_error" );
				break;
			case ' dima-alert-success':
				$is_icon = dima_get_svg_icon( "ic_check_circle" );
				break;
			case ' dima-alert-custom':
				$is_icon = $_icon;
				break;
			default:
				$is_icon = "";
				break;
		}
	} else {
		$is_icon = '';
	}

	if ( $close == 'true' ) {
		$close     = ' fade in';
		$close_btn = '<button type="button" class="close" data-dismiss="alert">'
		             . dima_get_svg_icon( "ic_close" ) . '</button>';
	} else {
		$close     = ' alert-close-block';
		$close_btn = '';
	}
	if ( ( $alert_style == "two" || $alert_style == "three" ) && $is_icon != '' ) {
		$output
			= "<div class='dima_alert_side{$type}' {$animation_data}><span class='dima_alert_icon'>{$is_icon}</span><div {$id} class=\"alert_style_{$alert_style} {$class} {$type}{$close}\" {$style}>{$close_btn}{$heading}"
			  . do_shortcode( $content ) . "</div></div>";
	} else {
		$output
			= "<div {$id} class=\"alert_style_{$alert_style} {$class}{$type}{$close}\" {$animation_data} {$style}>{$is_icon}{$close_btn}{$heading}"
			  . do_shortcode( $content ) . "</div>";
	}

	return $output;
}

add_shortcode( 'alert', 'dima_shortcode_alert' );