<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * 1. Accordion.
 *   2. Accordion item.
 */
function dima_shortcode_accordion( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'model' => '',
				'open'  => '',
				'style' => '',

				'animation'              => '',
				'delay'                  => '',
				'delay_offset'           => '',
				'delay_duration'         => '',
				'data_dima_animate_item' => '',
			), $atts, 'accordion'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[] = ( $class != '' ) ? 'dima-accordion' . esc_attr( $class ) : 'dima-accordion';
	$model    = ( $model == '' ) ? '' : $model;
	$_class[] = ( $open == 'true' ) ? 'no-active-accordion' : '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : 'data-animate=transition.slideUpIn';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : ' data-delay="70"';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : ' data-offset="98%"';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';
	$animation_data .= ( $data_dima_animate_item ) ? ' data-dima-animate-item=' . $data_dima_animate_item . '' : ' data-dima-animate-item=".dima-accordion-group"';

	switch ( $model ) {
		case 'line':
			$_class[] = 'dima-acc-clear';
			break;
		case 'border':
			$_class[] = 'acc-with-border';
			break;
		default:
			$_class[] = 'acc-default';
	}
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$class = dima_helper::dima_remove_white_space( esc_attr( trim( implode( ' ', $_class ) ) ) );

	$output = "<ul {$id} class=\"{$class}\" {$animation_data} {$style}>" . do_shortcode( $content )
	          . "</ul>";

	return $output;
}

add_shortcode( 'accordion', 'dima_shortcode_accordion' );


function dima_shortcode_accordion_item( $atts, $content = null ) { // 2
	extract(
		shortcode_atts(
			array(
				'id'                   => '',
				'class'                => '',
				'style'                => '',
				'parent_id'            => '',
				'title'                => '',
				'icon'                 => '',
				'icon_svg'             => '',
				'icon_fontawesome'     => '',
				'icon_two'             => '',
				'icon_svg_two'         => '',
				'icon_fontawesome_two' => '',
				'bg_color'             => '',
				'icon_color'           => '',
				'open'                 => ''
			), $atts, 'accordion_item'
		)
	);

	$id                   = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[]             = ( $class != '' ) ? 'panel dima-accordion-group '
	                                           . esc_attr(
		                                           $class
	                                           ) : 'panel dima-accordion-group';
	$style                = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$parent_id            = ( $parent_id != '' ) ? 'data-parent="#' . $parent_id
	                                               . '"' : '';
	$title                = ( $title != '' ) ? '<span class="dima-accordion-title">' . $title . '</span>' : 'Make Sure to Set a Title';
	$open                 = ( $open == 'true' ) ? 'collapse in' : 'collapse';
	$_icon                = ( $icon != '' ) ? $icon : '';
	$icon_svg             = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg )
		: '';
	$icon_fontawesome     = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$bg_color             = ( $bg_color != '' ) ? 'background-color:' . $bg_color
	                                              . ';' : '';
	$icon_color           = ( $icon_color != '' ) ? 'color:' . $icon_color
	                                                . ';fill: ' . $icon_color . '' : '';
	$_icon_two            = ( $icon_two != '' ) ? $icon_two : '';
	$icon_svg_two         = ( $icon_svg_two != '' ) ? dima_get_svg_icon(
		$icon_svg_two
	) : '';
	$icon_fontawesome_two = ( $icon_fontawesome_two != '' )
		? $icon_fontawesome_two : '';
	static $count = 0;
	$count ++;
	$icon_style = '';
	if ( $bg_color != '' || $icon_color != '' ) {
		$icon_style = "style=\"$bg_color$icon_color\"";
	}

	$_icon = ( $_icon == '' ) ? $icon_fontawesome : $_icon;
	if ( ! empty( $icon_svg ) ) {
		$_icon = $icon_svg;
	} else if ( ! empty( $_icon ) ) {
		$_icon = '<i class="' . $_icon . '"></i>';
	}
	if ( ! empty( $_icon ) ) {
		$_icon = "<span class='icon_one' $icon_style>{$_icon}</span>";
	}

	$_icon_two = ( $_icon_two == '' ) ? $icon_fontawesome_two : $_icon_two;
	if ( ! empty( $icon_svg_two ) ) {
		$_icon_two = $icon_svg_two;
	} else if ( ! empty( $_icon_two ) ) {
		$_icon_two = '<i class="' . $_icon_two . '"></i>';
	}
	if ( ! empty( $_icon_two ) ) {
		$_icon_two = "<span class='icon_two' $icon_style>{$_icon_two}</span>";
	}
	if ( ! empty( $_icon_two ) && ! empty( $_icon_two ) ) {
		$_class[] = 'double_icon';
	}
	$class = dima_helper::dima_remove_white_space( esc_attr( trim( implode( ' ', $_class ) ) ) );
	if ( $open == 'collapse in' ) {
		$output = "<li {$id} class=\"{$class}\" {$style}>"
		          . '<div class="dima-accordion-header">'
		          . "<a class=\"dima-accordion-toggle\" data-toggle=\"collapse\" {$parent_id} href=\"#collapse-{$count}\">{$title}{$_icon}{$_icon_two}</a>"
		          . '</div>'
		          . "<div id=\"collapse-{$count}\" class=\"dima-accordion-content {$open}\">"
		          . '<div class="dima-accordion-inner">'
		          . wpb_js_remove_wpautop( $content, true )
		          . '</div>'
		          . '</div>'
		          . '</li>';

	} else {

		$output = "<li {$id} class=\"{$class}\" {$style}>"
		          . '<div class="dima-accordion-header">'
		          . "<a class=\"dima-accordion-toggle collapsed\" data-toggle=\"collapse\" {$parent_id} href=\"#collapse-{$count}\">{$title}{$_icon}{$_icon_two}</a>"
		          . '</div>'
		          . "<div id=\"collapse-{$count}\" class=\"dima-accordion-content {$open}\">"
		          . '<div class="dima-accordion-inner">'
		          . wpb_js_remove_wpautop( $content, true )
		          . '</div>'
		          . '</div>'
		          . '</li>';

	}

	return $output;
}

add_shortcode( 'accordion_item', 'dima_shortcode_accordion_item' );