<?php
/**
 * Functions pertaining to content output.
 *
 * @package global
 * @subpackage 1-content
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 *
 */

/**
 * @param       $element
 * @param array $params
 *
 * @return string
 */
function dima_creat_data_attributes( $element, $params = array() ) {
	$data = 'data-dima-element="' . $element . '"';

	if ( ! empty( $params ) ) {
		$params_json = htmlspecialchars( json_encode( $params ), ENT_QUOTES, 'UTF-8' );

		$data .= ' data-dima-params="' . $params_json . '"';
	}

	return $data;
}

function dima_short_remove_white_space( $text ) {
	$text = preg_replace( '/[\t\n\r\0\x0B]/', '', $text );
	$text = preg_replace( '/([\s])\1+/', ' ', $text );
	$text = trim( $text );

	return $text;
}

/**
 * @param $output
 *
 * @return array
 */
function dima_shortcodes_add_body_class( $output ) {

	$version = str_replace( '.', '_', DIMA_NOUR_ASSISTANT_VERSION );

	$output[] = 'dima-shortcodes-version' . $version;

	return $output;

}

add_filter( 'body_class', 'dima_shortcodes_add_body_class', 9999 );

// Allow shortcodes in widgets.
add_filter( 'widget_text', 'do_shortcode' );

function dima_get_admin_media_post() {
	$id        = vc_post_param( 'content' );
	$back_post = get_post( $id );
	if ( $back_post == '' ) {
		return;
	}
	$post_mime = $back_post->post_mime_type;

	$back_url = $back_icon = $img_name = $img_path = '';
	if ( strpos( $post_mime, 'image/' ) !== false ) {
		$background_url = wp_get_attachment_thumb_url( $id );
		$back_url       = ( $background_url != '' ) ? 'background-image: url(' . $background_url . ');' : '';
		$img_name       = get_the_title( $id );
		$img_path       = $background_url;
	} else if ( strpos( $post_mime, 'pattern/' ) !== false ) {
		$background_url = wp_get_attachment_thumb_url( $id );
		$back_url       = ( $background_url != '' ) ? 'background-image: url(' . $background_url . ');' : '';
		$img_name       = get_the_title( $id );
		$img_path       = $background_url;
	} else if ( strpos( $post_mime, 'video/' ) !== false ) {
		$back_icon = '<i class="fa fa-media-play" />';
	} else {
		switch ( $post_mime ) {
			case 'oembed/flickr':
			case 'oembed/instagram':
			case 'oembed/Imgur':
			case 'oembed/photobucket':
				$back_oembed = wp_oembed_get( $back_post->guid );
				preg_match_all( '/src="([^"]*)"/i', $back_oembed, $img_src );
				$back_url = ( isset( $img_src[1][0] ) ) ? 'background-image: url(' . str_replace( '"', '', $img_src[1][0] ) . ');' : '';
				break;

			case 'oembed/vimeo':
			case 'oembed/youtube':
				$back_icon = '<i class="fa fa-social-' . str_replace( 'oembed/', '', $post_mime ) . '" />';
				break;
		}
	}

	echo json_encode( array(
		'back_url'  => $back_url,
		'img_name'  => $img_name,
		'img_path'  => $img_path,
		'back_icon' => $back_icon,
		'back_mime' => $post_mime
	) );
	die();
}

add_action( 'wp_ajax_dima_get_media_post', 'dima_get_admin_media_post' );

if ( ! function_exists( 'dima_is_gradient_stop_transparent' ) ) {
	function dima_is_gradient_stop_transparent( $color ) {
		if ( strpos( $color, 'rgba' ) !== false ) {
			$var = $color;
			$var = str_replace( 'rgba(', '', $var );
			$var = str_replace( ')', '', $var );
			$var = explode( ',', $var );

			if ( floatval( $var[3] ) > 0.05 ) {
				return false;
			}

			return true;
		}

		return false;
	}
}

/**
 * Get template parts from shortcodes folder
 *
 * @param string  $slug
 * @param string  $name
 * @param boolean $return
 *
 * @return object
 *
 */
if ( ! function_exists( 'dima_get_shortcode_view' ) ) {
	function dima_get_shortcode_view( $shortcode_name, $name = '', $return = false, $view_params = array() ) {
		if ( $return ) {
			ob_start();
			dima_get_template_part( plugin_dir_path( __DIR__ ) . '/include/shortcodes/' . $shortcode_name . '/' . $name, $view_params );

			return ob_get_clean();
		} else {
			dima_get_template_part( plugin_dir_path( __DIR__ ) . '/include/shortcodes/' . $shortcode_name . '/' . $name, $view_params );
		}

	}
}

/**
 * Like get_template_part() put lets you pass args to the template file
 * Args are available in the tempalte as $view_params array
 *
 * @param string filepart
 * @param mixed wp_args style argument list
 *
 * @since 5.0.0
 * @since 5.9.1 Refactored the function to improve performance.
 */
if ( ! function_exists( 'dima_get_template_part' ) ) {
	function dima_get_template_part( $file, $view_params = array() ) {
		global $post;

		if ( file_exists( $file . '.php' ) ) {

			$file_path = ( $file . '.php' );

		} elseif ( file_exists( $file . '.php' ) ) {

			$file_path = realpath( $file . '.php' );

		}

		wp_parse_args( $view_params );
		ob_start();
		require( $file_path );
		$output = ob_get_clean();

		echo $output;


	}
}

if ( ! function_exists( 'dima_add_contact_methods' ) ) :
	function dima_add_contact_methods( $user_contactmethods ) {

		unset( $user_contactmethods['yim'] );
		unset( $user_contactmethods['aim'] );
		unset( $user_contactmethods['jabber'] );

		$user_contactmethods['facebook']   = esc_html__( 'Facebook Profile', 'noor' );
		$user_contactmethods['twitter']    = esc_html__( 'Twitter Profile', 'noor' );
		$user_contactmethods['googleplus'] = esc_html__( 'Google+ Profile', 'noor' );
		$user_contactmethods['linkedin']   = esc_html__( 'Linkedin Profile', 'noor' );
		$user_contactmethods['instagram']  = esc_html__( 'Instagram Profile', 'noor' );

		$user_contactmethods['flickr']    = esc_html__( 'Flickr Profile', 'noor' );
		$user_contactmethods['youtube']   = esc_html__( 'YouTube Profile', 'noor' );
		$user_contactmethods['pinterest'] = esc_html__( 'Pinterest Profile', 'noor' );
		$user_contactmethods['behance']   = esc_html__( 'Behance Profile', 'noor' );
		$user_contactmethods['dribbble']  = esc_html__( 'Dribbble Profile', 'noor' );

		return $user_contactmethods;

	}

	add_filter( 'user_contactmethods', 'dima_add_contact_methods' );
endif;

if ( ! dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_remove_ver_params' ) ) ) {
	/**
	 * Remove Query Strings From Static Resources
	 *
	 * @param $src
	 *
	 * @return mixed
	 */
	function dima_remove_script_version( $src ) {
		$parts = explode( '?ver', $src );

		return $parts[0];
	}

	function dima_remove_script_version_and( $src ) {
		$parts = explode( '&ver', $src );

		return $parts[0];
	}

	if ( ! is_admin() ) {
		add_filter( 'script_loader_src', 'dima_remove_script_version', 15, 1 );
		add_filter( 'style_loader_src', 'dima_remove_script_version', 15, 1 );
		add_filter( 'script_loader_src', 'dima_remove_script_version_and', 15, 1 );
		add_filter( 'style_loader_src', 'dima_remove_script_version_and', 15, 1 );
	}
}

function dima_js_async_attr( $tag ) {
	if ( is_admin() || ! dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_async_js' ) ) ) {
		return $tag;
	}

	$async_files = apply_filters( 'dima_js_async_files', array(
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/lazyload.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/load.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/init-es6.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/ie.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/bootstrap.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/bootstrap-transition.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/jquery.easing.1.3.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/countup.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/dropkick.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/headroom.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/hoverintent.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/layout-modes/vertical.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/layout-modes/fit-rows.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/layout-modes/masonry.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/jquery.knob.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/jquery.scrollto-min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/jquery.validate.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/perfect-scrollbar.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/jquery-ui.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/packery-mode.pkgd.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/skrollr.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/theia-sticky-sidebar.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/waves.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/module/waypoints.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/imagesloaded.pkgd.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/smoothscroll.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/respond.src.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/jquery.fancybox.min.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/video.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/bigvideo.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/okvideo.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/woocommerce-es6.js',
		DIMA_TEMPLATE_URL . '/framework/asset/site/js/main-es6.js',
	) );

	$add_async = false;
	foreach ( $async_files as $file ) {
		if ( strpos( $tag, $file ) !== false ) {
			$add_async = true;
			break;
		}
	}

	if ( $add_async ) {
		$tag = str_replace( ' src', ' async="async" src', $tag );
	}

	return $tag;
}

add_filter( 'script_loader_tag', 'dima_js_async_attr', 10 );

function dima_modify_admin_bar( $wp_admin_bar ) {

	list( $plugin_updates, $updates_notification ) = dima_get_plugin_updates_requires();

	$icon = '<i class="wp-menu-image dashicons-before dashicons-admin-generic dima-admin-bar-menu"></i>';

	// Add Admin Bar Menu Links
	$wp_admin_bar->add_menu( array(
		'id'    => 'dima-menu-options',
		'title' => $icon . wp_get_theme(),
		'href'  => is_admin() ? home_url() : admin_url( 'admin.php?page=dima_options' ),
		'meta'  => array( 'target' => is_admin() ? '_blank' : '_self' )
	) );

	$wp_admin_bar->add_menu( array(
		'parent' => 'dima-menu-options',
		'id'     => 'dima-menu-options-theme',
		'title'  => 'Welcome',
		'href'   => admin_url( 'admin.php?page=pixel-dima-dashboard' )
	) );

	$wp_admin_bar->add_menu( array(
		'parent' => 'dima-menu-options',
		'id'     => 'dima-menu-options-typolab',
		'title'  => 'Install Demos',
		'href'   => admin_url( 'admin.php?page=pixeldima-demo' )
	) );

	$wp_admin_bar->add_menu( array(
		'parent' => 'dima-menu-options',
		'id'     => 'dima-custom-css',
		'title'  => 'Plugins',
		'href'   => admin_url( 'admin.php?page=pixeldima-setup-plugins' )
	) );

	if ( $plugin_updates > 0 ) {
		$wp_admin_bar->add_menu( array(
			'parent' => 'dima-menu-options',
			'id'     => 'install-plugins',
			'title'  => 'Update Plugins' . $updates_notification,
			'href'   => admin_url( 'themes.php?page=install-required-plugins' )
		) );
	}

	$wp_admin_bar->add_menu( array(
		'parent' => 'dima-menu-options',
		'id'     => 'dima-demo-content',
		'title'  => 'Customizer Backup',
		'href'   => admin_url( 'admin.php?page=pixeldima-customizer-backup' )
	) );

	$wp_admin_bar->add_menu( array(
		'parent' => 'dima-menu-options',
		'id'     => 'dima-help',
		'title'  => 'System Status',
		'href'   => admin_url( 'admin.php?page=pixeldima-customizer-system' )
	) );

	$wp_admin_bar->add_menu( array(
		'parent' => 'dima-menu-options',
		'id'     => 'dima-themes',
		'title'  => 'Browse Our Themes',
		'href'   => 'https://themeforest.net/user/PixelDima/portfolio?ref=PixelDima',
		'meta'   => array( 'target' => '_blank' )
	) );
}

add_action( 'admin_bar_menu', 'dima_modify_admin_bar', 10000 );

