<?php
/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-customer.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see    https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="box">
    <header><h4 class="box-titel"><?php esc_html_e( 'Customer Details', 'noor' ); ?></h4></header>
    <table class="shop_table woocommerce-table woocommerce-table--customer-details shop_table customer_details">
		<?php if ( $order->get_customer_note() ) : ?>
            <tr>
                <th><?php esc_html_e( 'Note:', 'noor' ); ?></th>
                <td><?php echo wptexturize( $order->customer_note ); ?></td>
            </tr>
		<?php endif; ?>

		<?php if ( $order->get_billing_email() ) : ?>
            <tr>
                <th><?php esc_html_e( 'Email:', 'noor' ); ?></th>
                <td><?php echo esc_html( $order->billing_email ); ?></td>
            </tr>
		<?php endif; ?>

		<?php if ( $order->get_billing_phone() ) : ?>
            <tr>
                <th><?php esc_html_e( 'Telephone:', 'noor' ); ?></th>
                <td><?php echo esc_html( $order->get_billing_phone() ); ?></td>
            </tr>
		<?php endif; ?>

		<?php do_action( 'woocommerce_order_details_after_customer_details', $order ); ?>
    </table>
</div>
<?php if ( ! wc_ship_to_billing_address_only() && $order->needs_shipping_address() ) : ?>
    <div class="double-clear"></div>
<div class="col2-set addresses ok-row">

    <div class="col-1 ok-md-6">
        <div class="box">
			<?php endif; ?>

            <header class="title">
                <h4 class="box-titel"><?php esc_html_e( 'Billing Address', 'noor' ); ?></h4>
            </header>
            <address>
				<?php echo ( $address = $order->get_formatted_billing_address() ) ? $address : esc_html__( 'N/A', 'noor' ); ?>
            </address>

			<?php if ( ! wc_ship_to_billing_address_only() && $order->needs_shipping_address() ) : ?>

        </div><!-- /.col-1 -->
    </div>

    <div class="col-2 ok-md-6">
        <div class="box">
            <header class="title">
                <h4 class="box-titel"><?php esc_html_e( 'Shipping Address', 'noor' ); ?></h4>
            </header>
            <address>
				<?php echo ( $address = $order->get_formatted_shipping_address() ) ? $address : esc_html__( 'N/A', 'noor' ); ?>
            </address>
        </div><!-- /.col-2 -->
    </div>
</div><!-- /.col2-set -->

<?php endif; ?>
