<?php
/**
 * The template for displaying comments.
 *
 * @package Dima Framework.
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */
?>


<?php
/*------------------------------------------------------------*/
# If the current post is protected by a password and
# the visitor has not yet entered the password we will
# return early without loading the comments.
/*------------------------------------------------------------*/
if ( post_password_required() ) {
	return;
}

global $current_user;
wp_get_current_user();
?>

<div id="comments" class="dima-comments-list">

	<?php if ( have_comments() ) : ?>

        <h4 class="h-comment">
            <span>
                <small>(<?php echo number_format_i18n( get_comments_number() ); ?>)</small>
	            <?php esc_html_e( 'Comments', 'noor' ); ?>
            </span>
        </h4>

        <div class="dima-divider noor-line noor-start"></div>

        <ol class="dima-comment">
			<?php
			wp_list_comments( array(
				'callback' => 'dima_noor_comment',
				'style'    => 'ol'
			) );
			?>
        </ol>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav class="dima-comments-navigation">
                <h6><?php esc_html_e( 'Comment navigation', 'noor' ); ?></h6>
                <div class="text-start"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'noor' ) ); ?></div>
                <div class="text-end"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'noor' ) ); ?></div>
            </nav>
		<?php endif; ?>

	<?php endif; ?>

	<?php if ( ! comments_open() && '0' != get_comments_number() ) : ?>
        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'noor' ); ?></p>
	<?php endif; ?>
	<?php

	function dima_modify_comment_form_fields( $fields ) {
		$commenter   = wp_get_current_commenter();
		$req         = get_option( 'require_name_email' );
		$form_style  = dima_helper::dima_get_option( "dima_blog_comments_style" );
		$consent     = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';
		$row_class[] = "ok-row";
		if ( $form_style != "matrial_style" ) {
			$row_class[] = "ok-no-margin";
		}
		$class = dima_helper::dima_remove_white_space( join( ' ', $row_class ) );

		$fields['author'] ='<div class="' . esc_attr( $class ) . '"><div class="ok-md-4 ok-sd-6 ok-xsd-12"><div class="field"><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" placeholder="' . esc_html__( "Name*", 'noor' ) . '" ' . ( $req ? 'aria-required="true"' : '' ) . ' required="" aria-required="true"></div></div>';
		$fields['email'] ='<div class="ok-md-4 ok-sd-6 ok-xsd-12"><div class="field"><input type="text" name="email" id="email" value="' . esc_attr( $commenter['comment_author_email'] ) . '" placeholder="' . esc_html__( "Email*", 'noor' ) . '" size="22" tabindex="2" ' . ( $req ? 'aria-required="true"' : '' ) . ' required="" aria-required="true"/></div></div>';
		$fields['url'] ='<div class="ok-md-4 ok-sd-12 ok-xsd-12"><div class="field"><input type="text" name="url" id="url" value="' . esc_attr( $commenter['comment_author_url'] ) . '" placeholder="' . esc_html__( "Website", 'noor' ) . '" size="22" tabindex="3" class="input-website" /></div></div></div>';
		$fields['cookies'] = '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . $consent . ' /><label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'noor' ) . '</label></p>';

		return $fields;
	}

	add_filter( 'comment_form_default_fields', 'dima_modify_comment_form_fields' );

	/**
	 * @param $fields
	 * Change the order for comment & cookies field
	 * @return mixed
	 */
	function dima_move_comment_field_to_bottom( $fields ) {
		$comment_field = $fields['comment'];
		unset( $fields['comment'] );
		$fields['comment'] = $comment_field;

		$comment_field = $fields['cookies'];
		unset( $fields['cookies'] );
		$fields['cookies'] = $comment_field;

		return $fields;
	}

	add_filter( 'comment_form_fields', 'dima_move_comment_field_to_bottom' );


	$form_style = dima_helper::dima_get_option( "dima_blog_comments_style" );
	$form_class = "";
	if ( $form_style == "matrial_style" ) {
		$form_class = " matrial-form";
	}
	$comments_args = array(
		'comment_notes_after'  => '',
		'comment_notes_before' => '',
		'must_log_in'          => '<p class="must-log-in">' . sprintf( esc_html__( "You must be %slogged in%s to post a comment.", 'noor' ), '<a href="' . wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ) . '">', '</a>' ) . '</p>',
		'logged_in_as'         => '<p class="logged-in-as">' . esc_html__( "Logged in as", 'noor' ) . ' <a href="' . admin_url( "profile.php" ) . '">' . esc_attr( $current_user->user_login ) . '</a>. <a href="' . wp_logout_url( get_permalink() ) . '" title="' . esc_html__( "Log out of this account", 'noor' ) . '">' . esc_html__( "Log out &raquo;", 'noor' ) . '</a></p>',
		'cancel_reply_link'    => '<p class="cancel-reply text-end theme-color">' . sprintf( esc_html__( 'cancel reply', 'noor' ) ) . '</p>',
		'comment_field'        => '<div class="field"><textarea id="comment" name="comment" class="textarea" placeholder="' . esc_html__( "Comment...", 'noor' ) . '" required="" aria-required="true"></textarea></div>',
		'id_submit'            => 'entry-comment-submit',
		'class_submit'         => 'button fill',
		'label_submit'         => esc_html__( 'Post comment', 'noor' ),
		'title_reply_before'   => '<h4 id="reply-title" class="comment-reply-title">',
		'title_reply'          => esc_html__( 'Leave a Reply', 'noor' ),
		'title_reply_after'    => '</h4>',
		'submit_button'        => '<div class="text-start"><input name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s" /></div>'
	);
	ob_start();
	comment_form( $comments_args );
	echo str_replace( 'class="comment-form"', 'class="comment-form form-small form' . esc_attr( $form_class ) . '"', ob_get_clean() );
	?>

</div>