<?php
/**
 * Theme styles , include style bsed on demo name.
 * include google font url.
 *
 * @package Dima Framework
 * @subpackage Functions
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 *
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'dima_global_styles' ) ) :
	function dima_global_styles() {
		$dima_css_style_dir = '/framework/asset/site/css/styles/';
		$demo               = 'noor_main';
		$ext                = '';
		$min                = dima_helper::dima_get_option( 'dima_minified_files' ) ? '.min' : '';
		$rtl                = is_rtl() ? '-rtl' : '';

		//Register styles.
		wp_enqueue_style( DIMA_THEME_NAME . '-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/style' . $ext . $rtl . $min . '.css', array(), DIMA_VERSION );


		wp_register_style( 'fancybox-css', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/fancybox.css', array(), DIMA_VERSION, 'all' );
		wp_enqueue_style( 'fancybox-css' );

		wp_register_style( 'mediaelement-css', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/mediaelementplayer.css', array(), DIMA_VERSION, "all" );
		wp_enqueue_style( 'mediaelement-css' );

		if ( DIMA_CF_IS_ACTIVE ) {
			$style_includes = get_option( '_caldera_forms_styleincludes' );
			if ( ! $style_includes['alert'] ) {
				wp_register_style( 'calderaforms-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/calderaforms' . $ext . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
				wp_enqueue_style( 'calderaforms-style' );
			}
		}

		if ( DIMA_WC_IS_ACTIVE ) {
			wp_register_style( 'dima-woocommerce-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/woocommerce-style' . $ext . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
			if ( dima_is_wc_page() ) {
				wp_enqueue_style( 'dima-woocommerce-style' );
			}
		}
		if ( DIMA_YITH_WISHLIST_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-wishlist', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/wishlist' . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
		}

		if ( DIMA_BBPRESS_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-bbpress', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/bbpress-style' . $ext . $min . '.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_GRAVITY_FORMS_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-gravity-forms', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/gf-style' . $ext . $min . '.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_CONTACT_FORM_7_IS_ACTIVE ) {
			add_filter( 'wpcf7_load_css', '__return_false' );
		}
		if ( DIMA_KB_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-gravity-forms', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/kb-style' . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_CRYP_WIDGET_IS_ACTIVE || DIMA_ULTIMATE_CRYPTO_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-cryptocurrency-widget', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/cryptocurrency' . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
		}

		if ( DIMA_EDD_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-edd', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/edd' . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
		}

		if ( DIMA_THE_EVENTS_CALENDAR_ACTIVE ) {
			wp_enqueue_style( 'dima-theeventscalendar-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/dima-events-calenda' . $ext . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_GUTENBERG_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-blocks-common-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/block-common' . $ext . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
			wp_enqueue_style( 'dima-blocks-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/blocks' . $ext . $rtl . $min . '.css', null, DIMA_VERSION, 'all' );
		}
	}
endif;
add_action( 'wp_enqueue_scripts', 'dima_global_styles' );


if ( ! function_exists( 'dima_include_fonts' ) ) :
	function dima_include_fonts() {

		$is_custom_font       = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_custom_font' ) );
		$protocol             = is_ssl() ? 'https' : 'http';
		$custom_font_args_all = array();
		$dima_css_style_dir   = '/framework/asset/site/css/styles/';

		$body_font_weight      = dima_helper::dima_get_option( 'dima_body_weights_list' );
		$btn_font_weight       = dima_helper::dima_get_option( 'dima_btn_weights_list' );
		$heading_font_weight   = dima_helper::dima_get_option( 'dima_heading_weights_list' );
		$heading_font_weight_2 = dima_helper::dima_get_option( 'dima_heading_weights_list_2' );
		$heading_font_weight_3 = dima_helper::dima_get_option( 'dima_heading_weights_list_3' );
		$heading_font_weight_4 = dima_helper::dima_get_option( 'dima_heading_weights_list_4' );
		$heading_font_weight_5 = dima_helper::dima_get_option( 'dima_heading_weights_list_5' );
		$heading_font_weight_6 = dima_helper::dima_get_option( 'dima_heading_weights_list_6' );
		$logo_font_weight      = dima_helper::dima_get_option( 'dima_logo_weights_list' );
		$navbar_font_weight    = dima_helper::dima_get_option( 'dima_navbar_weights_list' );

		$subsets = dima_helper::dima_get_option( 'dima_body_subsets_list' );

		if ( is_rtl() && ! $is_custom_font ) {
			$body_font_family     = $navbar_font_family = $btn_font_family = 'Droid Arabic Naskh';
			$logo_font_family     = $navbar_font_family =
			$heading_font_family = $heading_font_family_2 =
			$heading_font_family_3 = $heading_font_family_4 =
			$heading_font_family_5 = $heading_font_family_6 = 'Droid Arabic Kufi';
			$custom_font_args_all = dima_get_font_and_wright( $body_font_family, $body_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $logo_font_family, $logo_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $navbar_font_family, $navbar_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $btn_font_family, $btn_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family, $heading_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_2, $heading_font_weight_2, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_3, $heading_font_weight_3, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_4, $heading_font_weight_4, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_5, $heading_font_weight_5, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_6, $heading_font_weight_6, $custom_font_args_all );
		} else {
			$body_font_family      = dima_helper::dima_get_option( 'dima_body_font_list' );
			$logo_font_family      = dima_helper::dima_get_option( 'dima_logo_font_list' );
			$btn_font_family       = dima_helper::dima_get_option( 'dima_btn_font_list' );
			$navbar_font_family    = dima_helper::dima_get_option( 'dima_navbar_font_list' );
			$heading_font_family   = dima_helper::dima_get_option( 'dima_heading_font_list' );
			$heading_font_family_2 = dima_helper::dima_get_option( 'dima_heading_font_list_2' );
			$heading_font_family_3 = dima_helper::dima_get_option( 'dima_heading_font_list_3' );
			$heading_font_family_4 = dima_helper::dima_get_option( 'dima_heading_font_list_4' );
			$heading_font_family_5 = dima_helper::dima_get_option( 'dima_heading_font_list_5' );
			$heading_font_family_6 = dima_helper::dima_get_option( 'dima_heading_font_list_6' );

			$custom_font_args_all = dima_get_font_and_wright( $body_font_family, $body_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $logo_font_family, $logo_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $navbar_font_family, $navbar_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $btn_font_family, $btn_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family, $heading_font_weight, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_2, $heading_font_weight_2, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_3, $heading_font_weight_3, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_4, $heading_font_weight_4, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_5, $heading_font_weight_5, $custom_font_args_all );
			$custom_font_args_all = dima_get_font_and_wright( $heading_font_family_6, $heading_font_weight_6, $custom_font_args_all );
		}

		if ( is_array( $custom_font_args_all ) && ! empty( $custom_font_args_all ) ) {
			$custom_font_args_all = implode( "|", $custom_font_args_all );
		} else {
			$custom_font_args_all = '';
		}

		$custom_font_args = array(
			'family' => $custom_font_args_all,
			'subset' => $subsets
		);


		$get_custom_font_family = add_query_arg( $custom_font_args, $protocol . '://fonts.googleapis.com/css' );
		wp_enqueue_style( 'dima-font-custom', $get_custom_font_family, null, DIMA_VERSION, 'all' );

		# No Google Font ----------------------
		dima_include_no_google_font( $body_font_family, 'dima-body-font-custom' );
		dima_include_no_google_font( $btn_font_family, 'dima-btn-font-custom' );
		dima_include_no_google_font( $logo_font_family, 'dima-logo-font-custom' );
		dima_include_no_google_font( $navbar_font_family, 'dima-navbar-font-custom' );
		dima_include_no_google_font( $heading_font_family, 'dima-headling-font-custom' );
		dima_include_no_google_font( $heading_font_family_2, 'dima-heading-font-custom_2' );
		dima_include_no_google_font( $heading_font_family_3, 'dima-heading-font-custom_3' );
		dima_include_no_google_font( $heading_font_family_4, 'dima-heading-font-custom_4' );
		dima_include_no_google_font( $heading_font_family_5, 'dima-heading-font-custom_5' );
		dima_include_no_google_font( $heading_font_family_6, 'dima-heading-font-custom_6' );
		# !No Google Font ----------------------

		# Font Awesome --------------------------------
		if ( dima_helper::dima_am_i_true( dima_helper::dima_get_option( "dima_fontawesome_five" ) ) ) {
			wp_enqueue_style( 'fontawesome', 'https://use.fontawesome.com/releases/v5.0.1/css/all.css', array(), DIMA_VERSION );
		} else {
			wp_enqueue_style( 'fontawesome', DIMA_TEMPLATE_URL . $dima_css_style_dir . '/font-awesome.min.css', array(), DIMA_VERSION );
		}
	}

	function dima_get_font_and_wright( $font_family, $font_weight, $custom_font_args_all = array() ) {
		if ( $font_family == 'Poppin' ) {
			$font_family = 'Poppins';
		}
		$font_args = $font_family . ':' . $font_weight;
		array_push( $custom_font_args_all, $font_args );

		return $custom_font_args_all;
	}
endif;

add_action( 'wp_enqueue_scripts', 'dima_include_fonts' );

if ( ! function_exists( 'dima_admin_styles' ) ) :
	function dima_admin_styles( $hook ) {
		$rtl = '';
		$rtl .= is_rtl() ? '-rtl' : '';
		//include global admin style for pixeldima
		wp_enqueue_style( 'pixeldima-global', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/pixeldima' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		wp_enqueue_style( 'pixeldima-global' );

		//include meta style
		if ( $hook == 'post.php' || $hook == 'post-new.php' || $hook == 'edit-tags.php' ) {
			wp_enqueue_style( 'dima-meta', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/meta' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}
		wp_enqueue_style( 'dima-tippy', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/tippy.min.css', null, DIMA_VERSION, 'all' );
	}
endif;

add_action( 'admin_enqueue_scripts', 'dima_admin_styles' );

if ( ! function_exists( 'customizer_controls' ) ) :
	/**
	 * [Add Style to customizer controls 'customizer-controls.css']
	 */
	function customizer_controls() {
		wp_enqueue_style( 'dima_global_styles', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/customizer-controls.min.css', array(), DIMA_VERSION, 'all' );
	}
endif;

add_action( 'customize_controls_print_styles', 'customizer_controls' );

if ( ! function_exists( 'dima_include_no_google_font' ) ) :
	function dima_include_no_google_font( $font_family, $handle ) {
		switch ( $font_family ) {
			case 'Noto Naskh Arabic' :
				$font_family = 'http://fonts.googleapis.com/earlyaccess/notonaskharabic.css';
				break;
			case 'Noto Kufi Arabic' :
				$font_family = 'http://fonts.googleapis.com/earlyaccess/notokufiarabic.css';
				break;
			case 'Noto Nastaliq Urdu' :
				$font_family = 'http://fonts.googleapis.com/earlyaccess/notonastaliqurdu.css';
				break;
			default:
				$font_family = '';
		}
		if ( $font_family != '' ) {
			wp_enqueue_style( $handle, $font_family, null, DIMA_VERSION, 'all' );
		}
	}
endif;