<?php
/**
 * DIMA Framework
 * WARNING: This file is part of the DIMA Core Framework.
 * Do not edit the core files.
 *
 * @package Dima Framework
 * @subpackage Extensions
 * @version   2.0.0
 * @since     2.0.0
 * @author    PixelDima <info@pixeldima.com>
 */


/**
 * Adds body classes for EDD pages
 *
 * @since 2.1
 *
 * @param array $class current classes
 *
 * @return array Modified array of classes
 */
function dima_edd_add_body_classes( $class ) {
	$classes = (array) $class;

	if ( edd_is_checkout() ) {
		$classes[] = 'edd-dima-checkout';
		$classes[] = 'edd-page';
	}

	if ( edd_is_success_page() ) {
		$classes[] = 'edd-success';
		$classes[] = 'edd-page';
	}

	if ( edd_is_failed_transaction_page() ) {
		$classes[] = 'edd-failed-transaction';
		$classes[] = 'edd-page';
	}

	if ( edd_is_purchase_history_page() ) {
		$classes[] = 'edd-purchase-history';
		$classes[] = 'edd-page';
	}

	if ( edd_is_test_mode() ) {
		$classes[] = 'edd-test-mode';
	}

	return array_unique( $classes );
}

add_filter( 'body_class', 'dima_edd_add_body_classes' );

/**
 * Cart
 */
if ( ! function_exists( 'dima_edd_navbar_cart' ) ) :
	function dima_edd_navbar_cart() {

		ob_start();

		$cart_output = '<li class="shopping-btn menu-item-has-children cart_wrapper">';

		$cart_output .= '<a  href="' . edd_get_checkout_uri() . '" class="start-border">';
		$number      = '<span class="badge-number edd-cart-quantity">' . edd_get_cart_quantity() . '</span>';

		$cart_output .= '<span class="shop-icon menu_icon_item">' . dima_get_svg_icon( "ic_shopping_basket" ) . $number . '</span><span class=" dima-menu-span">Shop</span></a>';

		return $cart_output . ob_get_clean();
	}
endif;

function filter_edd_checkout_image_size( $array ) {
	return array( 65, 65 );
}

add_filter( 'edd_checkout_image_size', 'filter_edd_checkout_image_size', 10, 1 );

/*-----------------------------------------------------------------------------------*/
# Dequeue Easy Digital Downloads Default Css files
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'dima_edd_dequeue_css' ) ) {

	add_action( 'wp_enqueue_scripts', 'dima_edd_dequeue_css', 10 );
	function dima_edd_dequeue_css() {

		if ( DIMA_EDD_IS_ACTIVE ) {
			wp_dequeue_style( 'edd-styles' );
			wp_dequeue_style( 'edd-styles-rtl' );
		}
	}

}

/**
 * Shop product thumbnails.
 */
function dima_edd_product_thumbnails() {
	$id               = get_the_ID();
	$thumb            = apply_filters( 'single_edd_catalog_thumbnail_size', 'dima-edd-image' );
	$elm_hover        = dima_helper::dima_get_option( 'dima_shop_elm_hover' );
	$attachment_image = '';
	$featurd_image    = get_the_post_thumbnail( $id, $thumb );

	$download = new EDD_Download( $id );
	if ( empty( $download->ID ) ) {
		return false;
	}

	?>
    <div class="dima-edd-img">

		<?php
		if ( empty( $featurd_image ) ) { ?>
            <figure>
				<?php echo( $attachment_image ) ?>
            </figure>
			<?php
		} else {
			?>
            <figure>
				<?php echo( $featurd_image ) ?>
            </figure>
		<?php }
		?>

		<?php if ( $elm_hover != "none" ) { ?>

            <a class="all-over-thumb-link" href="<?php echo get_the_permalink() ?>"></a>

            <div class="post-icon link_overlay">
                <ul class="icons-media">
                    <li>
                        <a href="<?php echo get_the_permalink() ?>">
							<?php
							if ( $download->is_free() ) {
								echo dima_get_svg_icon( "ic_file_download" );
							} else {
								echo dima_get_svg_icon( "ic_shopping_basket" );
							}
							?>
                        </a>
                    </li>
                </ul>
                <a class="default-link" href="<?php echo get_the_permalink() ?>">
                </a>
            </div>
		<?php } ?>
    </div>
	<?php
}

/**
 * Get the download details metabox content
 *
 * @since 2.0
 */
if ( ! function_exists( 'dima_edd_download_details' ) ) :
	function dima_edd_download_details( $post_id, $is_cat, $is_tag ) {
		if ( ! $post_id ) {
			$post_id = get_the_ID();
		}
		// Get the download details
		$dima_download_details = get_post_meta( $post_id, 'dima_download_details', false );

		// Get the download tags
		$download_tags = get_the_term_list( get_the_ID(), 'download_tag' );

		// Get the download categories
		$download_cats = get_the_term_list( get_the_ID(), 'download_category' );

		// If the details exist, show them on the single download sidebar
		if ( $dima_download_details || $download_cats || $download_tags ) {

			echo "<div class='download-details download-aside'>";

			if ( $dima_download_details ) {

				if ( ! is_array( $dima_download_details[0] ) ) {
					/**
					 * We likely got this data from FES repeating fields, which stores
					 * the data in a pipe-separated string.
					 */
					$dima_download_details = explode( '| ', $dima_download_details[0] );
				}

				echo "<div class='download-features'>";
				echo "<ul class='dima-style'>";
				foreach ( $dima_download_details as $key => $value ) {
					if ( is_array( $value ) ) {
						foreach ( $value as $string ) {
							if ( ! empty( $string['price_option'] ) && 'all' == $string['price_option'] ) {
								echo "<li class='all'>";
								echo $string['text'];
								echo "</li>";
							}
						}
					} else {
						echo "<li>";
						echo $value;
						echo "</li>";
					}

				}
				echo "</ul>";
				echo '</div><!-- .download-features -->';
			}

			if ( $download_cats || $download_tags ) { ?>
                <div class="post-meta tags">
                    <!-- Get the download categories -->
					<?php if ( $is_cat && $download_cats ) { ?>
                        <span class="meta-cat">
							<?php echo dima_get_svg_icon( "ic_folder" ); ?>
							<?php echo $download_cats; ?>
						</span>
					<?php } ?>

                    <!-- Get the download tags -->
					<?php if ( $is_tag && $download_tags ) { ?>
                        <span class="meta-tag">
							<?php echo dima_get_svg_icon( "ic_label" ); ?>
							<?php echo $download_tags; ?>
						</span>
					<?php } ?>
                </div><!-- .post-meta -->
			<?php }

			echo "</div>";
		}
	} endif;
add_action( 'dima_below_purchase_sidebar', 'dima_edd_download_details', 5, 3 );

/**
 * Custom image size for EDD Related Downloads.
 */
function isa_related_downloads_image_size( $post ) {
	return 'dima-related-image';
}

add_filter( 'edd_related_downloads_image_size', 'isa_related_downloads_image_size' );


function dima_action_get_edd_shortcode_search() {
	echo do_shortcode( '[dima_edd edd_style="grid" words="0" count="" column="2" filters="false" hide_all="false" paging="true" orderby="post__in" category="" ids="" post_class=""]' );
}

add_action( 'dima_action_get_edd_shortcode_search', 'dima_action_get_edd_shortcode_search', 10, 3 );


function dima__return_false( $string ) {
	return false;
}
add_filter( 'edd_add_schema_microdata', 'dima__return_false' );
