<?php
add_filter( 'cmb2_admin_init', 'dima_edd_metaboxes' );

function dima_edd_metaboxes() {
	$object_types = array( 'download' );
	$box_options  = array(
		'id'           => 'dima-meta-box-edd',
		'title'        => esc_html__( 'EDD Settings', 'noor' ),
		'description'  => esc_html__( 'Here you will find various options you can use to create different page styles.', 'noor' ),
		'object_types' => $object_types,
		'show_names'   => true,
		'cmb_styles'   => false,
		'priority'     => 'high',
		'tab_style'    => 'default',
	);

	// Setup meta box
	$cmb = new_cmb2_box( $box_options );

	// setting tabs
	$tabs_setting = array(
		'config' => $box_options,
		'layout' => 'vertical', // Default : horizontal
		'tabs'   => array()
	);
	/*------------------- * General Tabs * -----------------------*/
	$general_tab = dima_meta_data::dima_get_meta_general_settings();
	/*------------------- * !General Tabs * -----------------------*/

	/*--------------- Header Tabs  ---------------*/
	$header_tabs = dima_meta_data::dima_get_meta_header_settings();
	/*--------------- Header Tabs ----------------*/

	/*-------------- Details Tabs -------------*/
	$details_tabs = array(
		array(
			'name'            => esc_html__( 'Share icons', 'noor' ),
			'label_cb'        => 'dima_meta_add_tooltip_to_label',
			'tooltip_options' => array(
				'tooltip-class' => '',
				'desc'          => esc_html__( 'Check to display Share icons and Tags', 'noor' ),
			),
			'id'              => '_dima_download_shear_icon',
			'type'            => 'dima_buttonset',
			'options'         => array(
				'inherit' => esc_html__( 'Inherit', 'noor' ),
				'on'      => esc_html__( 'On', 'noor' ),
				'off'     => esc_html__( 'Off', 'noor' ),
			),
			'default'         => 'on',
		),
	);
	/*-------------- !Details Tabs -------------*/
	$tabs_setting['tabs'][] = array(
		'id'     => 'meta_tab_general',
		'title'  => esc_html__( 'General', 'noor' ),
		'svg'    => 'ic_settings',
		'fields' => $general_tab
	);

	$tabs_setting['tabs'][] = array(
		'id'     => 'meta_tab_header',
		'title'  => esc_html__( 'Header', 'noor' ),
		'svg'    => 'ic_web_asset',
		'fields' => $header_tabs
	);

	$tabs_setting['tabs'][] = array(
		'id'     => 'meta_tab_details',
		'title'  => esc_html__( 'Details', 'noor' ),
		'svg'    => 'ic_details',
		'fields' => $details_tabs
	);

	// set tabs
	$cmb->add_field( array(
		'id'   => '__tabs',
		'type' => 'tabs',
		'tabs' => $tabs_setting
	) );
}

require_once( 'edd_download_details.php' );
