jQuery(document).ready(function ($) {
    var video_target = $('a[href$="#meta_tab_video"]'),
        quote_target = $('a[href$="#meta_tab_quote"]'),
        link_target = $('a[href$="#meta_tab_link"]'),
        gallery_target = $('a[href$="#meta_tab_gallery"]'),
        post_gallery_target = $('#dima-sidebar-meta-box-gallery-post'),
        audio_target = $('a[href$="#meta_tab_audio"]');

    Hide_All_Meta_Boxes();

    var format = wp.data.select('core/editor').getEditedPostAttribute('format');
    wp.data.subscribe(function () {
        var newFormat = wp.data.select('core/editor').getEditedPostAttribute('format');
        var formatItChanged = newFormat !== format;
        format = newFormat;
        if (formatItChanged) {
            Hide_All_Meta_Boxes();
            switch (format) {
                case 'gallery':
                    post_gallery_target.css('display', 'block');
                    gallery_target.css('display', 'block');
                    break;
                case 'audio':
                    audio_target.css('display', 'block');
                    break;
                case 'video':
                    video_target.css('display', 'block');
                    break;
                case 'quote':
                    quote_target.css('display', 'block');
                    break;
                case 'link':
                    link_target.css('display', 'block');
                    break;
            }
        }
    });

    function Hide_All_Meta_Boxes() {
        video_target.css('display', 'none');
        quote_target.css('display', 'none');
        link_target.css('display', 'none');
        audio_target.css('display', 'none');
        gallery_target.css('display', 'none');
        post_gallery_target.css('display', 'none');
    }

});