<?php
global $product;

?>
<div class="product-block list" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
    <?php do_action( 'nika_content_product_item_before' ); ?>
	<?php
        /**
         * Hook: nika_woocommerce_before_shop_list_item.
         *
         * @hooked nika_remove_add_to_cart_list_product - 10
         */
        do_action('nika_woocommerce_before_shop_list_item');
    ?>
	<div class="product-content row">
		<div class="block-inner col-lg-3 col-4">
			<?php
                /**
                 * Hook: woocommerce_before_shop_loop_item.
                 *
                 * @hooked woocommerce_template_loop_product_link_open - 10
                 */
                do_action('woocommerce_before_shop_loop_item');
            ?>
			<figure class="image <?php nika_product_block_image_class(); ?>">
				<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="product-image">
					<?php
                        /**
                         * woocommerce_before_shop_loop_item_title hook.
                         *
                         * @hooked woocommerce_show_product_loop_sale_flash - 10
                         * @hooked woocommerce_template_loop_product_thumbnail - 10
                         */
                        do_action('woocommerce_before_shop_loop_item_title');
                    ?>
				</a>

				<?php
                    /**
                     * nika_tbay_after_shop_loop_item_title hook.
                     */
                    do_action('nika_tbay_after_shop_loop_item_title');
                ?>
				<?php
                    /**
                     * tbay_woocommerce_before_content_product hook.
                     *
                     * @hooked woocommerce_show_product_loop_sale_flash - 10
                     */
                    do_action('tbay_woocommerce_before_content_product');
                ?>
				
			</figure>
		</div>
		<div class="caption col-lg-9 col-8">
			<div class="caption-left">
				<?php
                    do_action('nika_woo_before_shop_list_caption');
                ?>
				<?php nika_the_product_name(); ?>
				<?php
                    /**
                     * nika_after_title_tbay_subtitle hook.
                     *
                     * @hooked nika_woo_get_subtitle - 0
                     */
                    do_action('nika_after_title_tbay_subtitle');
                ?>
				
				<?php
                /**
                 * nika_woo_list_caption_left hook.
                 *
                 * @hooked woocommerce_template_loop_rating - 5
                 */
                    // do_action('nika_woo_list_caption_left');
                ?>
				<?php
                    /**
                     * nika_woo_list_sold hook.
                     *
                     * @hooked nika_tbay_total_sales - 5
                     */
                    do_action('nika_woo_list_sold');
                ?>
				
                <?php
                    /**
                     * Hook: nika_shop_list_sort_description.
                     *
                     * @hooked woocommerce_template_single_excerpt - 5
                     */
                    do_action('nika_shop_list_sort_description');
                ?>
				
				   <?php
                    /**
                     * nika_woo_list_after_short_description hook.
                     *
                     * @hooked the_woocommerce_variable - 5
                     * @hooked nika_tbay_total_sales - 15
                     */
                    do_action('nika_woo_list_after_short_description');
                ?>
				
			</div>
			<div class="caption-right">
				<?php
                    /**
                     * nika_woo_list_caption_right hook.
                     *
                     * @hooked woocommerce_template_loop_price - 5
                     */
                    do_action('nika_woo_list_caption_right');
                ?>
				<div class="group-buttons clearfix">	
					<?php
                        /**
                         * nika_tbay_after_shop_loop_item_title hook.
                         *
                         * @hooked nika_the_yith_wishlist - 20
                         * @hooked nika_the_quick_view - 30
                         * @hooked nika_the_yith_compare - 40
                         */
                        do_action('nika_woocommerce_group_buttons', $product->get_id());
                    ?>
				</div>

			</div>

			<?php
                /**
                 * Hook: woocommerce_after_shop_loop_item.
                 */
                do_action('woocommerce_after_shop_loop_item');
            ?>

		</div>

		
	</div>
	<?php
        do_action('nika_woocommerce_after_shop_list_item');
    ?>
</div>


