<?php
$style           = isset($style) ? $style : 'post-style-1';
$thumbsize       = isset($thumbnail_size_size) ? $thumbnail_size_size : 'full';
$show_title      = nika_switcher_to_boolean($show_title); ;
$show_category   = nika_switcher_to_boolean($show_category);
$show_author     =  nika_switcher_to_boolean($show_author);
$author_out_meta_list     =  nika_switcher_to_boolean($author_out_meta_list);
$show_date       =  nika_switcher_to_boolean($show_date);
$show_comments   =  nika_switcher_to_boolean($show_comments);
$show_comments_text   =  nika_switcher_to_boolean($show_comments_text);
$post_title_tag       = isset($post_title_tag) ? $post_title_tag : 'h3';
$show_excerpt    =  nika_switcher_to_boolean($show_excerpt);
$excerpt_length  = isset($excerpt_length) ? $excerpt_length : 15;
$show_read_more  =  nika_switcher_to_boolean($show_read_more);
$read_more_text  = isset($read_more_text) ? $read_more_text : esc_html__('Continue Reading', 'nika');


$text_domain               = esc_html__(' comments', 'nika');
if (get_comments_number() == 1) {
    $text_domain = esc_html__(' comment', 'nika');
}

?>
<article class="post item-post <?php echo esc_attr($style); ?>">   
    <figure class="entry-thumb <?php echo(!has_post_thumbnail() ? 'no-thumb' : ''); ?>">
        <a href="<?php the_permalink(); ?>"  class="entry-image">
          <?php
            if (nika_elementor_is_activated()) {
                the_post_thumbnail($thumbsize);
            } else {
                the_post_thumbnail();
            }

          ?>
        </a> 
    </figure>
    

    <div class="entry-header">
        <?php if (get_the_category_list() && $show_category == 1): ?>
            <div class="entry-category"><?php nika_the_post_category_full() ?></div>
        <?php endif; ?>

        <?php nika_post_archive_the_title(); ?>


        <?php if ($show_excerpt) : ?>
            <?php nika_post_archive_the_short_description(); ?>
        <?php endif; ?>

        <?php do_action('nika_blog_before_meta_list'); ?>
        <?php nika_post_meta_1(array(
            'author'     => $show_author,
            'date'     => $show_date,
            'tags'     => 0,
            'comments' 		=> $show_comments,
            'comments_text' 		=> $show_comments_text,
            'edit'     => 0,
        )); ?>
         <?php do_action('nika_blog_after_meta_list'); ?>
        <?php if ($show_read_more) : ?>
            <?php nika_post_archive_the_read_more(); ?>
        <?php endif; ?>

    </div>

   
</article>
