<?php

$text_domain               = esc_html__(' comments', 'nika');
$thumbsize       = isset($thumbnail_size_size) ? $thumbnail_size_size : 'thumbnail';
if (get_comments_number() == 1) {
    $text_domain = esc_html__(' comment', 'nika');
}

?>
<div class="post item-post single-reladted">   
    <figure class="entry-thumb <?php echo(!has_post_thumbnail() ? 'no-thumb' : ''); ?>">
        <a href="<?php the_permalink(); ?>"  class="entry-image">
            <?php
                if (nika_elementor_is_activated()) {
                    the_post_thumbnail($thumbsize);
                } else {
                    the_post_thumbnail();
                }
            ?>
        </a> 
    </figure>
    <div class="entry-header">

        <?php if (get_the_title()) : ?>

            <ul class="entry-meta-list">
                
                <?php if (get_the_category_list()) {
                ?>
                    <li class="entry-category"><?php nika_the_post_category_full() ?></li>
                <?php
            } ?>
                <li class="entry-date"><?php echo nika_time_link(); ?></li>
            </ul>
                        
            <h3 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h3>
        <?php endif; ?>
        

    </div>
</div>
