<?php
    $location = 'mobile-menu';
    $tbay_location  = '';
    if (has_nav_menu($location)) {
        $tbay_location = $location;
    }

    
    $mmenu_langue           = nika_tbay_get_config('enable_mmenu_langue', false);
    $mmenu_currency         = nika_tbay_get_config('enable_mmenu_currency', false);
    $mmenu_upload           = nika_tbay_get_config('enable_upload_prescription', false);

    $menu_mobile_select    =  nika_tbay_get_config('menu_mobile_select');

?>
  
<div id="tbay-mobile-smartmenu" data-title="<?php esc_attr_e('Menu', 'nika'); ?>" class="tbay-mmenu d-xl-none"> 


    <div class="tbay-offcanvas-body">
        
        <div id="mmenu-close">
            <button type="button" class="btn btn-toggle-canvas" data-toggle="offcanvas">
                <i class="tb-icon tb-icon-close-01"></i>
            </button>
        </div>

        <?php 

       
        if ( empty($menu_mobile_select) ) {
            $locations  = get_nav_menu_locations();
            $menu_id    = $locations[ $tbay_location ] ;
            $menu_obj   = wp_get_nav_menu_object( $menu_id );
        } else {
            $menu_obj = wp_get_nav_menu_object($menu_mobile_select);
        }

        $menu_name = nika_get_transliterate($menu_obj->slug);
        ?>
        <nav id="tbay-mobile-menu-navbar" class="menu navbar navbar-offcanvas navbar-static" data-id="<?php echo esc_attr($menu_name); ?>" >
            <?php 
                echo nika_get_mobile_menu_mmenu($menu_name);
            ?>
        </nav>


    </div>
    <?php if ($mmenu_langue || $mmenu_currency || $mmenu_upload) {
                ?>
         <div id="mm-tbay-bottom">  
    
            <div class="mm-bottom-track-wrapper">
                <?php if ($mmenu_upload): ?>
                    <?php 
                      $upload_text           = nika_tbay_get_config('upload_prescription_text');      
                      $upload_icon           = nika_tbay_get_config('upload_prescription_icon');      
                      $upload_page_id        = nika_tbay_get_config('upload_prescription_page');      
                    ?>
                    <div class="mm-upload-prescription">
                        <?php 
                            echo '<a class="mm-upload-prescription-item" href="'.get_permalink( $upload_page_id ).'"><i class="'. esc_attr($upload_icon) .'"></i><span>'. $upload_text .'</span></a>';
                        ?>
                    </div>
                <?php endif; ?>

                <div class="mm-bottom-langue-currency ">
                    <?php if ($mmenu_langue): ?>
                        <div class="mm-bottom-langue">
                            <?php do_action('nika_tbay_header_custom_language'); ?>
                        </div>
                    <?php endif; ?>
            
                    <?php if ($mmenu_currency && class_exists('WooCommerce') && class_exists('WOOCS')): ?>
                        <div class="mm-bottom-currency">
                            <div class="tbay-currency">
                            <?php echo do_shortcode('[woocs txt_type = "desc"]'); ?> 
                            </div>
                        </div>
                    <?php endif; ?>
                    
                </div>
            </div>


        </div>
        <?php
            }
    ?>
   
</div>