<?php

if (!nika_is_woo_variation_swatches_pro()) {
    return;
}

if (!function_exists('nika_quantity_swatches_pro_field_archive')) {
    function nika_quantity_swatches_pro_field_archive()
    {
        global $product;
        if (nika_is_quantity_field_archive()) {
            woocommerce_quantity_input(['min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity()]);
        }
    }
}

if (!function_exists('nika_variation_enable_swatches')) {
    add_action('woocommerce_init', 'nika_variation_enable_swatches', 5);
    function nika_variation_enable_swatches()
    {
        $enable = wc_string_to_bool(woo_variation_swatches()->get_option('show_on_archive', 'yes'));
        $position = sanitize_text_field(woo_variation_swatches()->get_option('archive_swatches_position', 'after'));

        if (!$enable) {
            return;
        }

        if ('after' === $position) {
            add_action('nika_woo_after_shop_loop_item_caption', [Woo_Variation_Swatches_Pro_Archive_Page::instance(), 'after_shop_loop_item'], 30);
            add_action('nika_woo_list_after_short_description', [Woo_Variation_Swatches_Pro_Archive_Page::instance(), 'after_shop_loop_item'], 30);
        } else {
            add_action('nika_woo_before_shop_loop_item_caption', [Woo_Variation_Swatches_Pro_Archive_Page::instance(), 'after_shop_loop_item'], 7);
            add_action('nika_woo_before_shop_list_caption', [Woo_Variation_Swatches_Pro_Archive_Page::instance(), 'after_shop_loop_item'], 7);
        }
    }
}

if (class_exists('Woo_Variation_Swatches_Pro_Archive_Page')) {
    remove_action('woocommerce_init', [Woo_Variation_Swatches_Pro_Archive_Page::instance(), 'enable_swatches'], 1);
    remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
}
