<?php

if (! defined('ABSPATH') || function_exists('Nika_Elementor_Testimonials')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;

/**
 * Elementor tabs widget.
 *
 * Elementor widget that displays vertical or horizontal tabs with different
 * pieces of content.
 *
 * @since 1.0.0
 */
class Nika_Elementor_Testimonials extends Nika_Elementor_Carousel_Base
{
    /**
     * Get widget name.
     *
     * Retrieve tabs widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tbay-testimonials';
    }

    /**
     * Get widget title.
     *
     * Retrieve tabs widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('Nika Testimonials', 'nika');
    }

    public function get_script_depends()
    {
        return [ 'nika-custom-slick', 'slick' ];
    }
 
    /**
     * Get widget icon.
     *
     * Retrieve tabs widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-testimonial';
    }

    /**
     * Register tabs widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->register_controls_heading();

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'nika'),
            ]
        );
 
        $this->add_control(
            'layout_type',
            [
                'label'     => esc_html__('Layout Type', 'nika'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'grid',
                'options'   => [
                    'grid'      => esc_html__('Grid', 'nika'),
                    'carousel'  => esc_html__('Carousel', 'nika'),
                ],
            ]
        );
        
        $this->add_responsive_control(
            'testimonial_padding',
            [
                'label' => esc_html__('Padding "Name"', 'nika'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $repeater = $this->register_testimonials_repeater();

        $this->add_control(
            'testimonials',
            [
                'label' => esc_html__('Testimonials Items', 'nika'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => $this->register_set_testimonial_default(),
                'testimonials_field' => '{{{ testimonials_image }}}',
            ]
        );

        $this->end_controls_section();

        $this->add_control_responsive();
        $this->add_control_carousel(['layout_type' => 'carousel']);
    }

    private function register_testimonials_repeater()
    {
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'testimonial_image',
            [
                'label' => esc_html__('Choose Image: Avatar', 'nika'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $repeater->add_control(
            'title_excerpt',
            [
                'label' => esc_html__('Excerpt', 'nika'),
                'type' => Controls_Manager::HEADING,
            ]
        );
        
        $repeater->add_control(
            'testimonial_excerpt',
            [
                'label' => esc_html__('Description', 'nika'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $repeater->add_control(
            'testimonial_name',
            [
                'label' => esc_html__('Name', 'nika'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'testimonial_address',
            [
                'label' => esc_html__('Address', 'nika'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        return $repeater;
    }

    private function register_set_testimonial_default()
    {
        $defaults = [
            [
                
                'testimonial_image' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                
                'testimonial_name' => esc_html__('Name 1', 'nika'),
                'testimonial_address' => esc_html__('Address 1', 'nika'),
                'testimonial_excerpt' => esc_html__('Lorem ipsum dolor sit amet, in mel unum delicatissimi conclusionemque', 'nika'),
            ],
            [
                'testimonial_image' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                
                'testimonial_name' => esc_html__('Name 2', 'nika'),
                'testimonial_address' => esc_html__('Address 2', 'nika'),
                'testimonial_excerpt' => esc_html__('Lorem ipsum dolor sit amet, in mel unum delicatissimi conclusionemque', 'nika'),
            ],
            [
                'testimonial_image' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                
                'testimonial_name' => esc_html__('Name 3', 'nika'),
                'testimonial_address' => esc_html__('Address 3', 'nika'),
                'testimonial_excerpt' => esc_html__('Lorem ipsum dolor sit amet, in mel unum delicatissimi conclusionemque', 'nika'),
            ],
            [
                'testimonial_image' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                
                'testimonial_name' => esc_html__('Name 4', 'nika'),
                'testimonial_address' => esc_html__('Address 4', 'nika'),
                'testimonial_excerpt' => 'Lorem ipsum dolor sit amet, in mel unum delicatissimi conclusionemque',
            ],
        ];

        return $defaults;
    }

    protected function render_item($item, $count, $size) {
        
        ?> 
        <?php
            $count = sprintf("%02d", $count);
            $size = sprintf("%02d", $size);
        ?>
        <div class="testimonials-body"> 
                
                
                <div class="testimonial-meta">
                    <?php $this->render_item_excerpt($item); ?>
                </div>
                <div class="wrapper-info-count">
                    <div>
                        <?php echo $this->get_widget_field_img($item['testimonial_image']); ?>
                        <div class="testimonials-info">
                            <?php
                                $this->render_item_name($item);
                                $this->render_item_address($item);
                            ?>
                        </div>
                    </div>
                    <div class="testimonial-count"><?php echo trim($count).'/ '.'<span>'.trim($size).'</span>'; ?></div>
                </div>
                    
                <?php
                ?>
                <?php
            ?>
        </div>
        <?php
    }
    

    private function render_item_name($item)
    {
        $testimonial_name  = $item['testimonial_name'];
        if (isset($testimonial_name) && !empty($testimonial_name)) {
            ?>
                <span class="name"><?php echo trim($testimonial_name) ?></span>
            <?php
        }
    }
    private function render_item_address($item)
    {
        $testimonial_address  = $item['testimonial_address'];

        if (isset($testimonial_address) && !empty($testimonial_address)) {
            ?>
                <span class="address"><?php echo trim($testimonial_address) ?></span>
            <?php
        }
    }
    private function render_item_excerpt($item)
    {
        
        $testimonial_excerpt  = $item['testimonial_excerpt'];

        if ( (isset($testimonial_excerpt) && !empty($testimonial_excerpt)) ) {
            ?>  
                <div class="excerpt"><?php echo trim($testimonial_excerpt) ?></div>
            <?php
        }
    }
}
$widgets_manager->register(new Nika_Elementor_Testimonials());
