<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Nika_Elementor_Addons
{
    public function __construct()
    {
        $this->include_control_customize_widgets();
        $this->include_render_customize_widgets();

        add_action('elementor/elements/categories_registered', array( $this, 'add_category' ));

        add_action('elementor/widgets/register', array( $this, 'include_widgets' ));

        add_action('wp', [ $this, 'regeister_scripts_frontend' ]);

        // frontend
        // Register widget scripts
        add_action('elementor/frontend/after_register_scripts', [ $this, 'frontend_after_register_scripts' ]);
        add_action('elementor/frontend/after_enqueue_scripts', [ $this, 'frontend_after_enqueue_scripts' ]);

        add_action('elementor/editor/after_enqueue_styles', [$this, 'enqueue_editor_icons'], 99);

        // editor
        add_action('elementor/editor/after_register_scripts', [ $this, 'editor_after_register_scripts' ]);
        add_action('elementor/editor/after_enqueue_scripts', [$this, 'editor_after_enqueue_scripts']);

    
        add_action('widgets_init', array( $this, 'register_wp_widgets' ));

        add_action('elementor/widgets/widgets_registered', array( $this, 'unregister_elementor_widgets' ), 15);
    }

    public function editor_after_register_scripts()
    {
        if (nika_is_remove_scripts()) {
            return;
        }

        $suffix = (nika_tbay_get_config('minified_js', false)) ? '.min' : NIKA_MIN_JS;
        // /*slick jquery*/
        wp_register_script('slick', NIKA_SCRIPTS . '/slick' . $suffix . '.js', array(), '1.0.0', true);
        wp_register_script('nika-custom-slick', NIKA_SCRIPTS . '/custom-slick' . $suffix . '.js', array( ), NIKA_THEME_VERSION, true);

        wp_register_script('nika-script', NIKA_SCRIPTS . '/functions' . $suffix . '.js', array(), NIKA_THEME_VERSION, true);


        wp_register_script('popper', NIKA_SCRIPTS . '/popper' . $suffix . '.js', array( ), '1.12.9', true);
        wp_register_script('bootstrap', NIKA_SCRIPTS . '/bootstrap' . $suffix . '.js', array( 'popper' ), '4.0.0', true);

        /*Treeview menu*/
        wp_register_script('jquery-treeview', NIKA_SCRIPTS . '/jquery.treeview' . $suffix . '.js', array( ), '1.4.0', true);
       
        // Add js Sumoselect version 3.0.2
        wp_register_style('sumoselect', NIKA_STYLES . '/sumoselect.css', array(), '1.0.0', 'all');
        wp_register_script('jquery-sumoselect', NIKA_SCRIPTS . '/jquery.sumoselect' . $suffix . '.js', array(), '3.0.2', true);
    }

    public function frontend_after_enqueue_scripts()
    {
    }

    public function editor_after_enqueue_scripts()
    {
    }

    public function enqueue_editor_icons()
    {
        wp_enqueue_style('simple-line-icons', NIKA_STYLES . '/simple-line-icons.css', array(), '2.4.0');
        wp_enqueue_style('nika-font-tbay-custom', NIKA_STYLES . '/font-tbay-custom.css', array(), '1.0.0');
        wp_enqueue_style('material-design-iconic-font', NIKA_STYLES . '/material-design-iconic-font.css', false, '2.2.0');

        if (nika_elementor_is_edit_mode() || nika_elementor_is_preview_page() || nika_elementor_is_preview_mode()) {
            wp_enqueue_style('nika-elementor-editor', NIKA_STYLES . '/elementor-editor.css', array(), NIKA_THEME_VERSION);
            wp_enqueue_style('font-awesome', NIKA_STYLES . '/font-awesome.css', array(), '5.10.2');
        }
    }


    /**
     * @internal Used as a callback
     */
    public function frontend_after_register_scripts()
    {
        $this->editor_after_register_scripts();
    }


    public function register_wp_widgets()
    {
    }

    public function regeister_scripts_frontend()
    {
    }


    public function add_category( $elements_manager )
    {
        $elements_manager->add_category(
            'nika-elements',
            array(
                'title' => esc_html__('Nika Elements', 'nika'),
                'icon'  => 'fa fa-plug',
            )
        );
    }

    /**
     * @param $widgets_manager Elementor\Widgets_Manager
     */
    public function include_widgets($widgets_manager)
    {
        $this->include_abstract_widgets($widgets_manager);
        $this->include_general_widgets($widgets_manager);
        $this->include_header_widgets($widgets_manager);
        $this->include_woocommerce_widgets($widgets_manager);
    }


    /**
     * Widgets General Theme
     */
    public function include_general_widgets($widgets_manager)
    {

        $elements = nika_elementor_general_widgets();

        foreach ( $elements as $file ) {
            $path   = NIKA_ELEMENTOR .'/elements/general/' . $file . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }

    }

    /** 
     * Widgets WooComerce Theme
     */
    public function include_woocommerce_widgets($widgets_manager)
    {
        if (!nika_is_Woocommerce_activated()) return;

        $woo_elements = nika_elementor_woocommerce_widgets();

        foreach ( $woo_elements as $file ) {
            $path   = NIKA_ELEMENTOR .'/elements/woocommerce/' . $file . '.php';
            if( file_exists( $path ) ) {
                require_once $path;
            }
        }
    }

    /**
     * Widgets Header Theme
     */
    public function include_header_widgets($widgets_manager)
    {

        $elements = nika_elementor_header_widgets();

        foreach ( $elements as $file ) {
            $path   = NIKA_ELEMENTOR .'/elements/header/' . $file . '.php';
            if( file_exists( $path ) ) {
                require_once $path;
            }
        }
    }


    /**
     * Widgets Abstract Theme
     */
    public function include_abstract_widgets($widgets_manager)
    {
        $abstracts = array(
            'image',
            'base',
            'responsive',
            'carousel',
        );

        $abstracts = apply_filters('nika_abstract_elements_array', $abstracts);

        foreach ($abstracts as $file) {
            $path   = NIKA_ELEMENTOR .'/abstract/' . $file . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    }

    public function include_control_customize_widgets()
    {
        $widgets = array(
            'sticky-header',
            'column',
            'settings-layout',
            'global-typography',
        );

        $widgets = apply_filters('nika_customize_elements_array', $widgets);
 
        foreach ($widgets as $file) {
            $control   = NIKA_ELEMENTOR .'/elements/customize/controls/' . $file . '.php';
            if (file_exists($control)) {
                require_once $control;
            }
        }
    }

    public function include_render_customize_widgets()
    {
        $widgets = array(
            'sticky-header',
        );

        $widgets = apply_filters('nika_customize_elements_array', $widgets);
 
        foreach ($widgets as $file) {
            $render    = NIKA_ELEMENTOR .'/elements/customize/render/' . $file . '.php';
            if (file_exists($render)) {
                require_once $render;
            }
        }
    }

    public function unregister_elementor_widgets($widgets_manager)
    {
        $elementor_widget_blacklist = array(
            'nika_custom_menu',
            'nika_list_categories',
            'nika_popular_post',
            'nika_popup_newsletter',
            'nika_posts',
            'nika_recent_comment',
            'nika_recent_post',
            'nika_single_image',
            'nika_socials_widget',
            'nika_featured_video_widget',
            'nika_template_elementor',
            'nika_top_rate_widget',
            'nika_woo_carousel',
            'nika_product_brand'
        );

        foreach ($elementor_widget_blacklist as $widget_name) {
            $widgets_manager->unregister('wp-widget-'. $widget_name);
        }
    }
}

new Nika_Elementor_Addons();
