<?php

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * @since Nika 1.0
 */
define('NIKA_THEME_VERSION', '1.0');

/**
 * ------------------------------------------------------------------------------------------------
 * Define constants.
 * ------------------------------------------------------------------------------------------------
 */
define('NIKA_THEME_DIR', get_template_directory_uri());
define('NIKA_THEMEROOT', get_template_directory());
define('NIKA_IMAGES', NIKA_THEME_DIR . '/images');
define('NIKA_SCRIPTS', NIKA_THEME_DIR . '/js');

define('NIKA_STYLES', NIKA_THEME_DIR . '/css');

define('NIKA_INC', 'inc');
define('NIKA_MERLIN', NIKA_INC . '/merlin');
define('NIKA_CLASSES', NIKA_INC . '/classes');
define('NIKA_VENDORS', NIKA_INC . '/vendors');
define('NIKA_ELEMENTOR', NIKA_THEMEROOT . '/inc/vendors/elementor');
define('NIKA_ELEMENTOR_TEMPLATES', NIKA_THEMEROOT . '/elementor_templates');
define('NIKA_PAGE_TEMPLATES', NIKA_THEMEROOT . '/page-templates');
define('NIKA_WIDGETS', NIKA_INC . '/widgets');

define('NIKA_ASSETS', NIKA_THEME_DIR . '/inc/assets');
define('NIKA_ASSETS_IMAGES', NIKA_ASSETS    . '/images');

define('NIKA_MIN_JS', '');

if (! isset($content_width)) {
    $content_width = 660;
}

function nika_tbay_get_config($name, $default = '')
{
    global $nika_options;
    if (isset($nika_options[$name])) {
        return $nika_options[$name];
    }
    return $default;
}

function nika_tbay_get_global_config($name, $default = '')
{
    $options = get_option('nika_tbay_theme_options', array());
    if (isset($options[$name])) {
        return $options[$name];
    }
    return $default;
}
