<?php
/**
 * nika functions and definitions.
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @see https://codex.wordpress.org/Theme_Development
 * @see https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 * @since Nika 1.0
 */
require get_theme_file_path('inc/function-global.php');

/*Start Class Main*/
require get_theme_file_path('inc/classes/class-main.php');

/*
 Include Required Plugins
*/
require get_theme_file_path('inc/function-plugins.php');

require_once get_parent_theme_file_path(NIKA_INC.'/classes/class-tgm-plugin-activation.php');

/**Include Merlin Import Demo**/
require_once get_parent_theme_file_path(NIKA_MERLIN.'/vendor/autoload.php');
require_once get_parent_theme_file_path(NIKA_MERLIN.'/class-merlin.php');
require_once get_parent_theme_file_path(NIKA_INC.'/merlin-config.php');

require_once get_parent_theme_file_path(NIKA_INC.'/functions-helper.php');
require_once get_parent_theme_file_path(NIKA_INC.'/functions-frontend.php');
require_once get_parent_theme_file_path(NIKA_INC.'/functions-mobile.php');

require_once get_parent_theme_file_path(NIKA_INC.'/customizer/functions.php');

/**
 * Customizer.
 */
require_once get_parent_theme_file_path(NIKA_INC.'/customizer/custom-header.php');
require_once get_parent_theme_file_path(NIKA_INC.'/customizer/customizer.php');
require_once get_parent_theme_file_path(NIKA_INC.'/customizer/custom-styles.php');
/**
 * Classess file.
 */

/**
 * Implement the Custom Styles feature.
 */
require_once get_parent_theme_file_path(NIKA_CLASSES.'/megamenu.php');
require_once get_parent_theme_file_path(NIKA_CLASSES.'/custommenu.php');
require_once get_parent_theme_file_path(NIKA_CLASSES.'/mmenu.php');

/**
 * Custom template tags for this theme.
 */
require_once get_parent_theme_file_path(NIKA_INC.'/template-tags.php');
require_once get_parent_theme_file_path(NIKA_INC.'/template-hooks.php');

if (nika_is_cmb2()) {
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/cmb2/page.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/cmb2/post.php');
}

if (nika_wpml_is_activated()) {
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/compatible/wpml.php');
}

if (class_exists('WooCommerce')) {
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/wc-admin.php');

    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/classes/class-wc.php');

    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/wc-template-functions.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/wc-template-hooks.php');

    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/wc-recently-viewed.php');

    /*compatible*/
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/wc_vendors.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/wc-dokan.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/wcfm_multivendor.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/mvx_vendor.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/wc-germanized.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/wc-advanced-free-shipping.php');

    require_once get_parent_theme_file_path(NIKA_VENDORS.'/woocommerce/compatible/woo-variation-swatches-pro.php');
}

if (defined('TBAY_ELEMENTOR_ACTIVED')) {
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/custom_menu.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/list-categories.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/popular_posts.php');

    if (function_exists('mc4wp_show_form')) {
        require_once get_parent_theme_file_path(NIKA_WIDGETS.'/popup_newsletter.php');
    }

    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/posts.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/recent_comment.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/recent_post.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/single_image.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/socials.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/top_rate.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/video.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/woo-carousel.php');
    require_once get_parent_theme_file_path(NIKA_WIDGETS.'/yith-brand-image.php');

    if (nika_elementor_is_activated()) {
        require_once get_parent_theme_file_path(NIKA_WIDGETS.'/template_elementor.php');
    }

    /*Redux FrameWork*/
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/redux-framework/class-redux.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/redux-framework/redux-config.php');
}

if (nika_elementor_is_activated()) {
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/elementor/class-elementor.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/elementor/class-elementor-pro.php');
    require_once get_parent_theme_file_path(NIKA_VENDORS.'/elementor/icons/icons.php');
}
