<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Nika
 * @since Nika 1.0
 */
/*

*Template Name: 404 Page
*/
get_header();
$image = nika_tbay_get_config('img_404');
if (isset($image['url']) && !empty($image['url'])) {
    $image = $image['url'];
} else {
    $image = NIKA_IMAGES . '/img-404.jpg';
}
?>

<section id="main-container" class=" container inner page-404">
	<div id="main-content" class="main-page">

		<section class="error-404">
			<div class="nika-img-404">
				<img src="<?php echo esc_attr($image); ?>" alt="<?php esc_attr_e('Img 404', 'nika'); ?>">
			</div>
			<div class="nika-content-404">
				<h1 class="title-404"><?php esc_html_e('404. Page not found', 'nika') ?></h1>
				<p class="sub-title"><?php esc_html_e('Page does not exist or some other error occured. Go to our Home page or go back to Previous page Home page', 'nika') ?> </p>
				<a href="<?php echo esc_url(home_url('/')) ?>" class="back"><?php esc_html_e('Visit Homepage', 'nika') ?></a>
			</div>
			
			
		</section><!-- .error-404 -->
	</div>
</section>

<?php get_footer(); ?>