<?php
/**
 * Plugin shortcodes
 *
 * @package NewsPlus
 * @subpackage NewsPlus_Shortcodes
 * @version 3.1.4
 */

/**
 * Generate thumbnail from Video embeds
 * http://wordpress.stackexchange.com/questions/40846/generating-thumbnails-for-video
 */

if ( ! function_exists ( 'newsplus_video_thumb' ) ) :
	function newsplus_video_thumb( $url = '' ) {
		require_once( ABSPATH . 'wp-includes/class-oembed.php' );
		$oembed = new WP_oEmbed;

		$provider = $oembed->discover( $url );
		//$provider = 'http://www.youtube.com/oembed';
		$video = $oembed->fetch( $provider, $url, array() );
		if ( $video ) {
			$title = $video->title;
			$thumb = $video->thumbnail_url;
			return array( 'url' => $thumb, 'title' => $title );
		}
	}
endif;

if ( ! function_exists ( 'newsplus_create_list_items' ) ) :
	function newsplus_create_list_items( $list_main = '', $list_other = '', $schema_prop = '', $link = false ) {

		$rcu = $rcuo = $rcat = $rcato = $temp = array();
		$rcu_out = $rcato = $tag = $tag_link = '';

		$rcu = explode( ',', $list_main );
		if ( '' !== $list_other ) {
			$rcuo = explode( ',', $list_other );
		}
		$temp = array_merge( $rcu, $rcuo );
		if ( is_array( $temp ) ) {
			foreach( $temp as $rcu_item ) {
				if ( '' != $rcu_item ) {
					if ( $link ) {
						$tag_link = get_term_by( 'name', $rcu_item, 'post_tag' );
						$cat_link = get_term_by( 'name', $rcu_item, 'category' );
						
						if ( isset( $tag_link->term_id ) ) {
							$rcu_out .= sprintf( '<li class="cm-value link-enabled" itemprop="%1$s"><a href="%2$s" title="%3$s" target="_blank">%4$s</a></li>',
								$schema_prop,
								get_term_link( $tag_link->term_id, 'post_tag' ),
								sprintf( __( 'View all recipies tagged %s', 'newsplus' ), $rcu_item ),
								$rcu_item
							);
						}
						
						// Check if a category is available
						elseif ( isset( $cat_link->term_id ) ) {
							$rcu_out .= sprintf( '<li class="cm-value link-enabled" itemprop="%1$s"><a href="%2$s" title="%3$s" target="_blank">%4$s</a></li>',
								$schema_prop,
								get_term_link( $cat_link->term_id, 'category' ),
								sprintf( __( 'View all recipies in %s', 'newsplus' ), $rcu_item ),
								$rcu_item
							);
						}
											
						else {
							$rcu_out .= '<li class="cm-value" itemprop="' . $schema_prop . '">' . $rcu_item . '</li>';
						}
					}
					else {
						$rcu_out .= '<li class="cm-value" itemprop="' . $schema_prop . '">' . $rcu_item . '</li>';
					}
				}
			}
		}

		return array( 'html' => $rcu_out, 'arr' => $temp );

	}
endif;

if ( ! function_exists ( 'newsplus_create_diet_items' ) ) :
	function newsplus_create_diet_items( $list_main = '', $link = false ) {

		$rcu = $list_main !== '' ? explode( ',', $list_main ) : '';
		$rcu_out = '';
		$protocol = is_ssl() ? 'https' : 'http';

		if ( is_array( $rcu ) && ! empty( $rcu ) ) {
			foreach( $rcu as $rcu_item ) {
				$sfd = str_replace( ' ', '', $rcu_item );

				if ( $link ) {
					$tag_link = get_term_by( 'name', $rcu_item, 'post_tag' );
					$cat_link = get_term_by( 'name', $rcu_item, 'category' );
					
					// Check if a tag is available
					if ( isset( $tag_link->term_id ) ) {
						$rcu_out .= sprintf( '<li class="cm-value link-enabled"><link itemprop="suitableForDiet" href="' . $protocol . '://schema.org/%1$sDiet" /><a href="%2$s" title="%3$s" target="_blank">%4$s</a></li>',
							$sfd,
							get_term_link( $tag_link->term_id, 'post_tag' ),
							sprintf( __( 'View all recipies tagged %s', 'newsplus' ), $rcu_item ),
							$rcu_item
						);
					}
					
					// Check if a category is available
					elseif ( isset( $cat_link->term_id ) ) {
						$rcu_out .= sprintf( '<li class="cm-value link-enabled"><link itemprop="suitableForDiet" href="' . $protocol . '://schema.org/%1$sDiet" /><a href="%2$s" title="%3$s" target="_blank">%4$s</a></li>',
							$sfd,
							get_term_link( $cat_link->term_id, 'category' ),
							sprintf( __( 'View all recipies in %s', 'newsplus' ), $rcu_item ),
							$rcu_item
						);
					}
					
					// Else no link
					else {
						$rcu_out .= sprintf( '<li class="cm-value"><link itemprop="suitableForDiet" href="' . $protocol . '://schema.org/%1$sDiet" />%2$s</li>',
							$sfd,
							$rcu_item
						);
					}
				}
				else {
					$rcu_out .= sprintf( '<li class="cm-value"><link itemprop="suitableForDiet" href="' . $protocol . '://schema.org/%1$sDiet" />%2$s</li>',
						$sfd,
						$rcu_item
					);
				}
			}
		}

		return array( 'html' => $rcu_out, 'arr' => $rcu );

	}
endif;

if ( ! function_exists ( 'newsplus_nutrient_items' ) ) :
	function newsplus_nutrient_items( $nutrition = array() ) {

		$nu_out = '';
		$schema_prop = '';

		if ( is_array( $nutrition ) ) {
			foreach( $nutrition as $nu ) {
				$nu_out .= '<li><span class="label">' . $nu->nutrient_label . '</span><span itemprop="' . $nu->nutrient. '">' . $nu->amount . '</span></li>';
			}
		}

		return $nu_out;

	}
endif;

if ( ! function_exists ( 'newsplus_time_convert' ) ) :
	function newsplus_time_convert( $time_in_min = '' ) {
		$hr = $min = 0;
		$arr = array( 'schema' => '', 'readable' => '' );
		$readable = $out = '';
		if ( isset( $time_in_min ) ) {
			if ( (int)$time_in_min >= 60 ) {
				$hr = floor( $time_in_min / 60 );
				$min = $time_in_min % 60;
			}

			else {
				$min = $time_in_min % 60;
			}

			if ( (int)$hr > 0 && (int)$min <= 0 ) {
				$out = $hr . 'H';
				$readable = sprintf( _x( '%s hr', 'xx hours', 'newsplus' ), number_format_i18n( $hr ) );
			}

			elseif ( (int)$hr <= 0 && (int)$min > 0 ) {
				$out = $min . 'M';
				$readable = sprintf( _x( '%s min', 'xx minutes', 'newsplus' ), number_format_i18n( $min ) );
			}

			elseif ( (int)$hr > 0 && (int)$min > 0 ) {
				$out = $hr . 'H' . $min . 'M';
				$readable = sprintf( _x( '%1$s hr %2$s min', 'xx hour yy minutes', 'newsplus' ), number_format_i18n( $hr ), number_format_i18n( $min ) );
			}

			$arr[ 'schema' ] = 'PT' . $out;
			$arr[ 'readable' ] = $readable;
		}
		return $arr;
	}
endif;


// Return parameters for BFI image resize
if ( ! function_exists ( 'newsplus_image_resize' ) ) :
	function newsplus_image_resize( $src, $imgwidth, $imgheight, $imgcrop, $imgquality, $imgcolor, $imggrayscale ) {
		$params = array();

		// Validate boolean params
		$crop = ( '' == $imgcrop || 'false' == $imgcrop ) ? false : true;
		$grayscale = ( '' == $imggrayscale || 'false' == $imggrayscale ) ? false : true;

		// Params array
		if ( $crop ) {
			$params['crop'] = true;
		}

		if ( $grayscale ) {
			$params['grayscale'] = true;
		}

		if ( '' != $imgquality ) {
			if ( (int)$imgquality < 1 ) {
				$quality = 1;
			} elseif ( (int)$imgquality > 100 ) {
				$quality = 100;
			} else {
				$quality = $imgquality;
			}
			$params['quality'] = (int)$quality;
		}

		if ( '' != $imgcolor ) {
			$color = preg_match( '/#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?\b/', $imgcolor ) ? $imgcolor : '';
			$params['color'] = $color;
		}

		// Validate width and height
		if ( isset( $imgwidth ) && (int)$imgwidth > 4 && '' != $imgwidth ) {
			$params['width'] = $imgwidth;
		}

		if ( isset( $imgheight ) && (int)$imgheight > 4 && '' != $imgheight ) {
			$params['height'] = $imgheight;
		}

		if ( function_exists( 'bfi_thumb' ) && ! empty( $params ) ) {
			return bfi_thumb( $src, $params );
		} else {
			return $src;
		}
	}
endif;

// Helper function for removing automatic p and br tags from nested short codes
if ( ! function_exists ( 'newsplus_return_clean' ) ) :
function newsplus_return_clean( $content, $p_tag = false, $br_tag = false ) {
	$content = preg_replace( '#^<\/p>|^<br \/>|<p>$#', '', $content );

	if ( $br_tag )
		$content = preg_replace( '#<br \/>#', '', $content );

	if ( $p_tag )
		$content = preg_replace( '#<p>|</p>#', '', $content );

	return do_shortcode( shortcode_unautop( trim( $content ) ) );
}
endif;

/**
 * Function to shorten any text by character length
 */
if ( ! function_exists( 'newsplus_short' ) ) :
	function newsplus_short( $text, $limit ) {
		$chars_limit = intval( $limit );
		$chars_text = strlen( $text );
		if ( $chars_text > $chars_limit ) {
			$text = strip_tags( $text );
			$text = $text . " ";
			$text = substr( $text, 0, $chars_limit );
			$text = substr( $text, 0, strrpos( $text, ' ' ) );
			return $text . "&hellip;";
		}
		else {
			return $text;
		}
	}
endif;

/**
 * Function to shorten any text by word length
 */
if ( ! function_exists( 'newsplus_short_by_word' ) ) :
	function newsplus_short_by_word( $phrase, $max_words ) {
		if ( '' == $max_words ) {
			$max_words = 20;
		}
		$phrase_array = explode( ' ', $phrase );
		if ( count( $phrase_array ) > $max_words && $max_words > 0 ) {
			$phrase = implode( ' ', array_slice( $phrase_array, 0, $max_words ) ) . '&hellip;';
		}
		return $phrase;
	}
endif;

// Generate schema
if ( ! function_exists( 'newsplus_schema' ) ) :
	function newsplus_schema( $enable_schema, $imgwidth = 200, $imgheight = 200 ) {
		$sc_arr = array(
			'html'	=> '',
			'container' => '',
			'heading' => '',
			'heading_alt' => '',
			'text' => '',
			'img_cont' => '',
			'img' => '',
			'img_size' => '',
			'url' => ''	,
			'nav' => '',
			'bclist' => '',
			'bcelement' => '',
			'item' => '',
			'name' => '',
			'position' => ''
		);

		 // Is single post
		if ( is_single() || is_home() || is_archive() || is_category() ) {
			$html_type = "Blog";
		}
		// Is static front page
		elseif ( is_front_page() ) {
			$html_type = "Website";
		}
		// Is a general page
		 else {
			$html_type = 'WebPage';
		}

		if ( 'true' == $enable_schema ) {
			$protocol = is_ssl() ? 'https' : 'http';
			$schema = $protocol . '://schema.org/';


			$sc_arr['html'] = 'itemscope="itemscope" itemtype="' . $schema . $html_type . '" ';
			$sc_arr['container'] = ' itemscope="" itemtype="' . $schema . 'BlogPosting" itemprop="blogPost"';
			$sc_arr['heading'] = ' itemprop="headline mainEntityOfPage"';
			$sc_arr['heading_alt'] = ' itemprop="headline"';
			$sc_arr['text'] = ' itemprop="text"';

			$sc_arr['img_cont'] = ' itemprop="image" itemscope="" itemtype="' . $schema . 'ImageObject"';
			$sc_arr['img'] = ' itemprop="url"';

			$sc_arr['img_size'] = sprintf( ' <meta itemprop="width" content="%s"><meta itemprop="height" content="%s">', $imgwidth, $imgheight );
			$sc_arr['url'] = ' itemprop="url"';
			$sc_arr['nav'] = ' itemscope="itemscope" itemtype="' . $schema . 'SiteNavigationElement"';

			$sc_arr['bclist'] = ' itemscope="itemscope" itemtype="' . $schema . 'BreadcrumbList"';
			$sc_arr['bcelement'] = ' itemscope="itemscope" itemtype="' . $schema . 'ListItem" itemprop="itemListElement"';
			$sc_arr['item'] = ' itemprop="item"';
			$sc_arr['name'] = ' itemprop="name"';
			$sc_arr['position'] = ' itemprop="position"';

		}
		return $sc_arr;
	}
endif;

// Post meta for post modules
if ( ! function_exists( 'newsplus_meta' ) ) :
	function newsplus_meta( $args = array() ) {
		global $post;
		$custom_link = get_post_meta( $post->ID, 'np_custom_link', true );
			$defaults = array(
				'template'	=> 'grid',
				'date_format' => get_option( 'date_format' ),
				'enable_schema' => false,
				'hide_cats' => false,
				'hide_reviews' => false,
				'show_cats' => false,
				'show_reviews' => false,
				'hide_date' => false,
				'hide_author' => false,
				'show_avatar' => false,
				'hide_views' => false,
				'hide_comments' => false,
				'readmore' => false,
				'ext_link' => false,
				'readmore_text' => esc_attr__( 'Read more', 'newsplus' ),
				'publisher_logo' => get_template_directory_uri() . '/images/logo.png',
				'sharing'	=> false,
				'share_btns' => ''
			);

			$args = wp_parse_args( $args, $defaults );

			extract( $args );

			$protocol = is_ssl() ? 'https' : 'http';
			$schema = $protocol . '://schema.org/';
			// Date format
			$date = get_the_time( get_option( 'date_format' ) );

			if ( ! empty( $date_format ) ) {
				if ( $date_format == 'human' ) {
					$date = sprintf( _x( '%s ago', 'human time difference. E.g. 10 days ago', 'newsplus' ), human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) );
				}
				else {
					$date = get_the_time( esc_attr( $date_format ) );
				}
			}

			$post_id = get_the_ID();

			$post_class_obj = get_post_class( $post_id );
			$post_classes = '';

			// Post classes
			if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
				$post_classes = implode( ' ', $post_class_obj );
			}

			// Category and review stars
			$review_meta = '';
			
			// Create category list
			$cat_list = '<ul class="post-categories">';			
			$hasmore = false;
			$i = 0;
			$cats = get_the_category();
			$cat_limit = apply_filters( 'newsplus_cat_list_limit', 3 );
			$cat_count = intval( count( $cats ) - $cat_limit );
			if ( isset( $cats ) ) {
				foreach( $cats as $cat ) {
					if ( $i == $cat_limit ) {
						$hasmore = true;
						$cat_list .= '<li class="submenu-parent"><a class="cat-toggle" href="#">' . sprintf( esc_attr_x( '+ %d more', 'more count for category list', 'newsplus' ), number_format_i18n( $cat_count ) ) . '</a><ul class="cat-sub submenu">';
					}
					$cat_list .= '<li><a href="' . get_category_link( $cat->cat_ID ) . '">' . $cat->cat_name . '</a></li>';
					$i++;
				}
				$cat_list .= $hasmore ? '</ul></li></ul>' : '</ul>';	
			}		
			
			if ( 'list-small' == $template ) {
				$cat_meta = ( 'true' == $show_cats ) ? $cat_list : '';

				/**
				 * Post reviews
				 * Requires https://wordpress.org/plugins/wp-review/
				 */
				$review_meta = ( function_exists( 'wp_review_show_total' ) && 'true' == $show_reviews ) ? wp_review_show_total( $echo = false ) : '';
			} else {
				$cat_meta = ( 'true' != $hide_cats ) ? $cat_list : '';
				if ( function_exists( 'wp_review_show_total' ) && 'true' !== $hide_reviews ) {
					$review_meta = wp_review_show_total( $echo = false );
				}
			}

			// Author and date meta
			$meta_data = '';

			//if ( ! $hide_author || ! $hide_date ) {
				$author = get_the_author();
				if ( $show_avatar ) {
					$meta_data .= sprintf( '<div%s%s class="author-avatar-32%s"><a%s href="%s" title="%s">%s%s</a></div>',
						$enable_schema ? ' itemscope itemtype="' . $schema . 'Person"' : '',
						$enable_schema ? ' itemprop="author"' : '',
						$hide_author && $hide_date ? ' avatar-only' : '',
						$enable_schema ? ' itemprop="name"' : '',
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						sprintf( esc_html__( 'More posts by %s', 'newsplus' ), esc_attr( $author ) ),
						$enable_schema ? '<span itemprop="image">' . get_avatar( get_the_author_meta( 'user_email' ), 32 ) . '</span>' : get_avatar( get_the_author_meta( 'user_email' ), 32 ),
						$enable_schema ? '<span class="hidden" itemprop="name">' . esc_attr( $author ) . '</span>' : ''

					);
				}

				$meta_data .= sprintf( '<ul class="entry-meta%s">',
					$show_avatar ? ' avatar-enabled' : ''
				);

				// Publisher Schema
				if ( $enable_schema ) {
					$meta_data .= '<li class="publisher-schema" itemscope itemtype="' . $schema . 'Organization" itemprop="publisher"><meta itemprop="name" content="' . esc_attr( get_bloginfo( 'name' ) ) . '"/><div itemprop="logo" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"><img itemprop="url" src="' . esc_url( $publisher_logo ) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '"/></div></li>';
				}

				//if ( ! $hide_date ) {
					$modified_date_format = 'human' == $date_format ? get_option( 'date_format' ) : $date_format;
					$meta_data .= sprintf( '<li class="post-time%1$s"><time%2$s class="entry-date" datetime="%3$s">%4$s</time>%5$s</li>',
						$hide_date ? ' hidden' : '',
						$enable_schema ? ' itemprop="datePublished"' : '',
						esc_attr( get_the_date( 'c' ) ),
						esc_html( $date ),
						$enable_schema ? '<meta itemprop="dateModified" content="' . esc_attr( the_modified_date( $modified_date_format, '', '', false ) ) . '"/>' : ''
					);
				//}

				//if ( ! $hide_author ) {
					$meta_data .= sprintf( '<li%1$s%2$s class="post-author%3$s"><span class="screen-reader-text">%4$s </span><a href="%5$s">%6$s</a></li>',
						$enable_schema ? ' itemscope itemtype="' . $schema . 'Person"' : '',
						$enable_schema ? ' itemprop="author"' : '',
						$hide_author ? ' hidden' : '',
						esc_html_x( 'Author', 'Used before post author name.', 'newsplus' ),
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						$enable_schema ? '<span itemprop="name">' . esc_attr( $author ) . '</span>' : esc_attr( $author )
					);
				//}

				$meta_data .= '</ul>';
			//}
			
			/**
			 * Social share buttons
			 * Uses newsplus_share_btns() function
			 */
			$share_btns_output =  $sharing ? newsplus_share_btns( $share_btns ) : '';

			// Comment link
			$num_comments = get_comments_number();
			$comment_meta = '';
			if ( comments_open() && ( $num_comments >= 1 ) && ! $hide_comments ) {
				$comment_meta = sprintf( '<a href="%1$s" class="post-comment" title="%2$s">%3$s%4$s</a>',
					esc_url( get_comments_link() ),
					sprintf( __( 'Comment on %s', 'newsplus' ), esc_attr( get_the_title() ) ),
					$enable_schema ? '<meta itemprop="discussionUrl" content="' . esc_url( get_comments_link() ) . '" />' : '',
					$enable_schema ? '<span itemprop="commentCount">' . $num_comments . '</span>' : $num_comments
				);
			}

			/**
			 * Post views
			 * Requires Plugin https://wordpress.org/plugins/post-views-counter/
			 */
			$views_meta = '';
			if ( function_exists( 'pvc_get_post_views' ) && ! $hide_views ) {
				$views_meta = sprintf( '<span class="post-views">%s</span>',
					pvc_get_post_views()
				);
			}

			// Generate rows of content
			$row_1 = '';
			$row_2 = '';
			$row_3 = '';
			$row_4 = '';
			if ( $review_meta != '' || $cat_meta != '' ) {
				$row_1 .= '<aside class="meta-row cat-row">';
				if ( $cat_meta != '' ) {
					$row_1 .= sprintf( '<div%s class="meta-col%s">%s</div>',
						$enable_schema ? ' itemprop="about"' : '',
						$review_meta != '' ? ' col-60' : '',
						$cat_meta
					);
				}

				if ( $review_meta != '' ) {
					$row_1 .= sprintf( '<div class="meta-col%s">%s</div>',
						$cat_meta != '' ? ' col-40 text-right' : '',
						$review_meta
					);
				}
				$row_1 .= '</aside>';
			}

			//if ( $meta_data || $views_meta || $comment_meta ) {
				$row_4 .= sprintf( '<aside class="meta-row row-3%s">',
					( $hide_date && $hide_author && $hide_views && $hide_comments && 'true' !== $sharing ) ? ' hidden' : ''
				);
				
				if ( '' == $views_meta && '' == $comment_meta && 'true' !== $sharing ) {
					$row_4 .= sprintf( '<div class="meta-col">%s</div>', $meta_data );
				}

				elseif ( '' == $meta_data ) {
					$row_4 .= sprintf( '<div class="meta-col">%s%s%s</div>', $views_meta, $comment_meta, $share_btns_output );
				}

				else {
					$row_4 .= sprintf( '<div class="meta-col col-60">%s</div><div class="meta-col col-40 text-right">%s%s%s</div>', $meta_data, $views_meta, $comment_meta, $share_btns_output );
				}
				$row_4 .= '</aside>';
			//}

			if ( $readmore ) {
				if ( $meta_data ) {
					$row_2 = sprintf( '<aside class="meta-row row-2%s"><div class="meta-col">%s</div></aside>',
						( $hide_date && $hide_author && $hide_views && $hide_comments && 'true' !== $sharing ) ? ' hidden' : '',
						$meta_data
					);
				}

				if ( $readmore || $views_meta || $comment_meta || $sharing ) {
					$row_3 = sprintf( '<aside class="meta-row row-3"><div class="meta-col col-50"><a class="readmore-link" href="%s">%s</a></div><div class="meta-col col-50 text-right">%s%s%s</div></aside>',
						$ext_link && $custom_link ? esc_url( $custom_link) : esc_url( get_permalink() ),
						esc_attr( $readmore_text ),
						$views_meta,
						$comment_meta,
						$share_btns_output
					);
				}
			}

			else {
				$row_3 = $row_4;
			}

		$meta_arr = array();
		$meta_arr['row_1'] = $row_1;
		$meta_arr['row_2'] = $row_2;
		$meta_arr['row_3'] = $row_3;
		$meta_arr['row_4'] = $row_4;
		return $meta_arr;
	}
endif;

/**
 * Social Sharing feature on single posts
 */
if ( ! function_exists( 'newsplus_share_btns' ) ) :
	function newsplus_share_btns( $share_btns ) {
		global $post;
		setup_postdata( $post );
		$share_btns = ( $share_btns ) ? explode( ',', $share_btns ) : '';

		// Set variables
		$out = '';
		$list = '';
		$share_image = '';
		$protocol = is_ssl() ? 'https' : 'http';

		if ( has_post_thumbnail( $post->ID ) ) {
			$share_image = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) );
		}

		$share_content = strip_tags( get_the_excerpt() );

		$out .= sprintf( '<div class="np-inline-sharing-container"><a class="share-trigger" title="%1$s"><span class="sr-only">%1$s</span></a><ul class="np-inline-sharing">', __( 'Share this post', 'newsplus' ) );

		if ( ! empty( $share_btns ) && is_array( $share_btns ) ) {
			foreach ( $share_btns as $button ) {
	
				switch( $button ) {
	
					case 'twitter':
						$list .= sprintf( '<li class="newsplus-twitter"><a href="%s://twitter.com/home?status=%s" target="_blank" title="%s">%s</a></li>', esc_attr( $protocol ), urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share on twitter', 'newsplus' ), esc_attr__( 'Twitter', 'newsplus' ) );
					break;
	
					case 'facebook':
						$list .= sprintf( '<li class="newsplus-facebook"><a href="%s://www.facebook.com/sharer/sharer.php?u=%s" target="_blank" title="%s">%s</a></li>', esc_attr( $protocol ), urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share on facebook', 'newsplus' ), esc_attr__( 'Facebook', 'newsplus' ) );
					break;
					
					case 'whatsapp':
						if ( wp_is_mobile() ) {
							$list .= sprintf( '<li class="newsplus-whatsapp"><a href="whatsapp://send?text=%s" title="%s" data-action="share/whatsapp/share">%s</a></li>', urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share on Whatsapp', 'newsplus' ), esc_attr__( 'Whatsapp', 'newsplus' ) );
						}
					break;				
	
					case 'googleplus':
						$list .= sprintf( '<li class="newsplus-googleplus"><a href="%s://plus.google.com/share?url=%s" target="_blank" title="%s">%s</a></li>', esc_attr( $protocol ), urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share on Google+', 'newsplus' ), esc_attr__( 'Google+', 'newsplus' ) );
					break;								
	
					case 'linkedin':
						$list .= sprintf( '<li class="newsplus-linkedin"><a href="%s://www.linkedin.com/shareArticle?mini=true&amp;url=%s" target="_blank" title="%s">%s</a></li>', esc_attr( $protocol ), urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share on LinkedIn', 'newsplus' ), esc_attr__( 'LinkedIn', 'newsplus' ) );
					break;
	
					case 'pinterest':
						$list .= sprintf( '<li class="newsplus-pinterest"><a href="%s://pinterest.com/pin/create/button/?url=%s&amp;media=%s" target="_blank" title="%s">%s</a></li>',
							esc_attr( $protocol ),
							urlencode( esc_url( get_permalink() ) ),
							esc_url( $share_image ),
							esc_attr__( 'Pin it', 'newsplus' ),
							esc_attr__( 'Pinterest', 'newsplus' )
						);
					break;
	
					case 'vkontakte':
						$list .= sprintf( '<li class="newsplus-vkontakte"><a href="%s://vkontakte.ru/share.php?url=%s" target="_blank" title="%s">%s</a></li>', esc_attr( $protocol ), urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share via VK', 'newsplus' ), esc_attr__( 'VKOntakte', 'newsplus' ) );
					break;
	
					case 'reddit':
						$list .= sprintf( '<li class="newsplus-reddit"><a href="//www.reddit.com/submit?url=%s" title="%s">%s</a></li>', urlencode( esc_url( get_permalink() ) ), esc_attr__( 'Share on Reddit', 'newsplus' ), esc_attr__( 'Reddit', 'newsplus' ) );
					break;					
	
					case 'email':
						$list .= sprintf( '<li class="newsplus-email no-popup"><a href="mailto:someone@example.com?Subject=%s" title="%s">%s</a></li>', urlencode( esc_attr( get_the_title() ) ), esc_attr__( 'Email this', 'newsplus' ), esc_attr__( 'Email', 'newsplus' ) );
	
					break;					
				} // switch
	
			} // foreach
		} // if

		// Support extra meta items via action hook
		ob_start();
		do_action( 'newsplus_sharing_buttons_li' );
		$out .= ob_get_contents();
		ob_end_clean();

		$out .= $list . '</ul></div>';

		return $out;
	}
endif;


if ( ! function_exists ( 'col' ) ) :
	function col( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'type' => 'full',
			'xclass' => false
		), $atts ) );
		$out = sprintf( '<div class="column%s%s">%s</div>',
			' ' . esc_attr( $type ),
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content )
		);
		if ( strpos( $type, 'last' ) ) {
			$out .= '<div class="clear"></div>';
		}
		return $out;
	}
endif;

if ( ! function_exists ( 'row' ) ) :
	function row( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'xclass' => false
		), $atts ) );
		$out = sprintf( '<div class="row%s">%s</div>',
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content )
		);
		return $out;
	}
endif;

if ( ! function_exists ( 'tabs' ) ) :
	function tabs( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'xclass' => false
		), $atts ) );
		$out = sprintf( '<div class="tabber%s">%s</div>',
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content )
		);
		return $out;
	}
endif;

if ( ! function_exists ( 'tab' ) ) :
	function tab( $atts, $content = null ) {
	   extract( shortcode_atts( array(
		  'title' => 'mytab',
		  'xclass' => false
		  ), $atts ) );
		$tab_id = 'tab-' . rand( 2, 20000 );
		$out = sprintf( '<div class="tabbed%s" id="%s"><h4 class="tab_title">%s</h4>%s</div>',
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			esc_attr( $tab_id ),
			esc_attr( $title ),
			newsplus_return_clean( $content )
		);
		return $out;
	}
endif;

if ( ! function_exists ( 'toggle' ) ) :
	function toggle( $atts, $content = null ) {
	   extract( shortcode_atts( array(
		  'title' => 'mytoggle'
		  ), $atts ) );
		$out = '<h5 class="toggle">' . $title . '</h5><div class="toggle-content">' . newsplus_return_clean( $content ) . '</div>';
		return $out;
	}
endif;

if ( ! function_exists ( 'accordion' ) ) :
	function accordion( $atts, $content = null ) {
	   extract( shortcode_atts( array(
		  'xclass' => false
		  ), $atts ) );
		$out = sprintf( '<div class="accordion%s">%s</div>',
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content )
		);
		return $out;
	}
endif;

if ( ! function_exists ( 'acc_item' ) ) :
	function acc_item( $atts, $content = null ) {
	   extract( shortcode_atts( array(
		  'title' => 'myaccordion'
		  ), $atts ) );
		$out = '<h5 class="handle">' . $title . '</h5><div class="acc-content"><div class="acc-inner">' . newsplus_return_clean( $content ) . '</div></div>';
		return $out;
	}
endif;

if ( ! function_exists ( 'box' ) ) :
	function box( $atts, $content = null ) {
	   extract( shortcode_atts( array(
		  'style' 		=> '0',
		  'close_btn'	=> false,
		  'xclass'		=> false
		  ), $atts ) );

		$out = sprintf( '<div class="box box%s%s">%s%s</div>',
			esc_attr( $style ),
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content ),
			$close_btn ? '<span class="hide-box"></span>' : ''
		);
		return $out;
	}
endif;

if ( ! function_exists ( 'btn' ) ) :
	function btn( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'link'		=> false,
			'color'		=> false,
			'size'		=> false,
			'target'	=> false,
			'xclass'	=> false
		), $atts ) );

		return sprintf( '<a href="%s" class="ss-button%s%s"%s>%s</a>',
			$link ? esc_url( $link ) : '#',
			$color ? ' ' . esc_attr( $color ) : ' default',
			$size ? ' ' . esc_attr( $size ) : '',
			$target ? ' target="' . esc_attr( $target ) . '"' : '',
			newsplus_return_clean( $content )
		);
	}
endif;

if ( ! function_exists ( 'hr' ) ) :
	function hr( $atts, $content = null ) {
	   extract( shortcode_atts( array(
		  'style' => 'single',
		  'xclass' => false
		  ), $atts ) );
		$class = '';
		if ( $style == 'single' ) $class = 'hr';
		if ( $style == 'double' ) $class = 'hr-double';
		if ( $style == '3d' ) $class = 'hr-3d';
		if ( $style == 'bar' ) $class = 'hr-bar';
		if ( $style == 'dashed' ) $class = 'hr-dashed';

		return sprintf( '<div class="hr%s%s"></div>',
			' ' . esc_attr( $class ),
			$xclass ? ' ' . esc_attr( $xclass ) : ''
		);
	}
endif;

if ( ! function_exists ( 'indicator' ) ) :
	function indicator( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'label'	=> 'Label here',
			'bg'	=> '#ffcc00',
			'value'	=> '75',
		), $atts ) );
		if ( $value < 0 )
			$value = 0;
		elseif ( $value > 100 )
			$value = 100;
		return '<div class="p_bar"><div class="p_label">' . esc_attr( $label ) . '</div><div class="p_indicator"><div class="p_active" style="width:' . esc_attr( $value ) . '%; background:' . esc_attr( $bg ) . '"></div></div><div class="p_value">' . esc_attr( $value ) . '%</div></div>';
	}
endif;

if ( ! function_exists ( 'slider' ) ) :
	function slider( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'effect'			=> 'fade',
			'easing'			=> 'swing',
			'speed'				=> '400',
			'timeout'			=> '4000',
			'animationloop'		=> 'false',
			'slideshow'			=> 'true',
			'smoothheight'		=> 'false',
			'controlnav'		=> 'true',
			'directionnav'		=> 'true',
			'items'				=> 1,
			'margin'			=> 24,
			'margin_mobile'		=> 16,
			'animatein'			=> '',
			'animateout'		=> '',
			'xclass'			=> false
		), $atts ) );

		$slider_id = 'slider-' . rand( 2, 400000 );

		$params = array(
				'items'				=> esc_attr( $items ),
				'margin'			=> esc_attr( $margin ),
				'margin_mobile'		=> esc_attr( $margin_mobile ),
				'speed'				=> esc_attr( $speed ),
				'timeout'			=> esc_attr( $timeout ),
				'autoheight'		=> esc_attr( $smoothheight ),
				'dots'				=> esc_attr( $controlnav ),
				'nav'				=> esc_attr( $directionnav ),
				'loop'				=> esc_attr( $animationloop ),
				'autoplay'			=> esc_attr( $slideshow ),
				'animatein'			=> esc_attr( $animatein ),
				'animateout'		=> esc_attr( $animateout )
			);

		$json = json_encode( $params );

		$out = sprintf( '<div class="owl-wrap np-posts-slider%s" data-params=\'%s\'><div class="owl-carousel owl-loading" id="%s">%s</div></div>',
				$xclass ? ' ' . esc_attr( $xclass ) : '',
				$json,
				esc_attr( $slider_id ),
				newsplus_return_clean( $content, false, true )
				//$container_markup
			);

		return newsplus_return_clean($out, 0, 1);
	}
endif;

if ( ! function_exists ( 'slide' ) ) :
	function slide( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'xclass' => false
		), $atts ) );
		return sprintf( '<div class="slide%s">%s</div>',
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content )
		);
	}
endif;

if ( ! function_exists ( 'slide_text' ) ) :
	function slide_text( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'xclass' => false
		), $atts ) );

		return sprintf( '<div class="slide-content%s">%s</div>',
			$xclass ? ' ' . esc_attr( $xclass ) : '',
			newsplus_return_clean( $content )
		);
	}
endif;

if ( ! function_exists ( 'posts_carousel' ) ) :
	function posts_carousel( $atts ) {
		$params = shortcode_atts( array(
			'query_type'		=> 'category',
			'cats'				=> null,
			'posts'				=> null,
			'pages'				=> null,
			'post__not_in'		=> null,
			'post__in'			=> null,
			'tags'				=> null,
			'post_type'			=> null,
			'taxonomy'			=> null,
			'terms'				=> null,
			'blog_id'			=> null,
			'operator'			=> 'IN',
			'order'				=> 'desc',
			'orderby'			=> 'date',
			'num'				=> '6',
			'offset'			=> '0',
			'ignore_sticky'		=> 0,
			'excerpt_length'	=> '140',
			'use_word_length' 	=> 'false',
			'hide_excerpt'		=> 'false',
			'hide_meta'			=> 'false',
			'hide_image'		=> 'false',
			'hide_video'		=> 'true',
			'imgwidth'			=> '',
			'imgheight'			=> '',
			'imgcrop'			=> false,
			'imgupscale'		=> 'true',
			'imgquality'		=> '',
			'effect'			=> 'fade',
			'easing'			=> 'swing',
			'speed'				=> '400',
			'timeout'			=> '4000',
			'animationloop'		=> 'false',
			'slideshow'			=> 'true',
			'smoothheight'		=> 'false',
			'controlnav'		=> 'true',
			'directionnav'		=> 'true',
			'items'				=> 3,
			'margin'			=> 24,
			'margin_mobile'		=> 16,
			'animatein'			=> '',
			'animateout'		=> '',
			'xclass'			=> false,
			'ptclass'			=> false,
			'htag'				=> 'h2',
			'hsize'				=> '',
			'ptag'				=> 'p',
			'enable_schema'		=> false,
			'use_short_title'	=> false,
			'ext_link'			=> false
		), $atts );

		$sc_params = '';

		foreach( $params as $key => $value ) {
			if ( null !== $value ) {
				$sc_params .= $key . '="' . $value . '" ';
			}
		}

		return do_shortcode( '[posts_slider ' . $sc_params . ']' );

	}
endif;

if ( ! function_exists ( 'posts_slider' ) ) :
	function posts_slider( $atts ) {
		extract( shortcode_atts( array(

			// Deprecated params
			'query_type'		=> 'category',
			'cats'				=> null,
			'posts'				=> null,
			'pages'				=> null,
			'tags'				=> null,

			// New WP Query params
			'author_name' 			=> null,
			'author__in' 			=> null,
			'cat' 					=> null,
			'category_name' 		=> null,
			'tag' 					=> null,
			'tag_id' 				=> null,
			'taxonomy' 				=> null,
			'terms'					=> null,
			'p' 					=> null,
			'name' 					=> null,
			'page_id' 				=> null,
			'pagename' 				=> null,
			'post__in' 				=> null,
			'post__not_in' 			=> null,
			'post_type' 			=> null,
			'post_status' 			=> 'publish',
			'num' 					=> 5,
			'offset' 				=> 0,
			'ignore_sticky_posts' 	=> false,
			'order' 				=> 'DESC',
			'orderby' 				=> 'date',
			'year' 					=> null,
			'monthnum' 				=> null,
			'w' 					=> null,
			'day'					=> null,
			'meta_key' 				=> null,
			'meta_value'			=> null,
			'meta_value_num' 		=> null,
			'meta_compare' 			=> '=',
			's' 					=> null,
			'blog_id'				=> null,

			'substyle'			=> 'grid',
			'excerpt_length'	=> '140',
			'use_word_length' 	=> 'false',
			'use_short_title'	=> false,
			'ext_link'			=> false,
			'hide_excerpt'		=> false,
			'hide_meta'			=> false,
			'hide_image'		=> false,
			'hide_video'		=> 'true',
			'imgcrop'			=> false,
			'imgupscale'		=> 'true',
			'imgquality'		=> '',

			// Slider params
			'effect'			=> 'slide', // fade
			'easing'			=> 'swing',
			'speed'				=> '400',
			'timeout'			=> '4000',
			'animationloop'		=> 'false',
			'slideshow'			=> 'true',
			'smoothheight'		=> 'false',
			'controlnav'		=> 'true',
			'directionnav'		=> 'true',
			'items'				=> 1,
			'margin'			=> 24,
			'margin_mobile'		=> 16,
			'animatein'			=> 'fadeIn',
			'animateout'		=> 'fadeOut',
			'imgwidth'			=> '',
			'imgheight'			=> '',
			'imgcrop'			=> false,
			'imgupscale'		=> 'true',
			'imgquality'		=> '',
			'enable_schema'		=> false,
			'date_format'		=> get_option( 'date_format' ),
			'hide_cats' 		=> false,
			'hide_reviews'		=> false,
			'hide_date' 		=> false,
			'hide_author' 		=> false,
			'hide_excerpt' 		=> false,
			'show_avatar' 		=> false,
			'hide_views' 		=> false,
			'hide_comments' 	=> false,
			'readmore' 			=> false,
			'readmore_text' 	=> false,
			'publisher_logo' 	=> get_template_directory_uri() . '/images/logo.png',
			'excerpt_length' 	=> 140,
			'htag'				=> 'h2',
			'hsize'				=> '',
			'ptag' 				=> 'p',
			'psize' 			=> '',
			'video_custom_field' => 'pf_video',
			'template'			=> 'grid',
			'xclass'			=> false,
			'ptclass'			=> false,
			'overlay_style'		=> 'default',
			'sharing'			=> false,
			'share_btns'		=> ''
		), $atts ) );

		// Sanitize WP Query args
		$author__in 				= $author__in ? explode( ',', $author__in ) : null;
		$post__in 					= $post__in ? explode( ',', $post__in ) : ( $posts ? explode( ',', $posts ) : ( $pages ? explode( ',', $pages ) : null ) );
		$post__not_in 				= $post__not_in ? explode( ',', $post__not_in ) : null;
		$terms 						= ( $terms ) ? explode( ',', $terms ) : null;
		$post_type					= ( $post_type ) ? explode( ',', $post_type ) : null;
		$taxonomy					= ( $taxonomy ) ? explode( ',', $taxonomy ) : null;
		$tax_query 					= null;

		if ( $taxonomy && $terms ) {
			$tax_query = array( 'relation' => 'OR' );

			if ( is_array( $taxonomy ) ) {
				foreach( $taxonomy as $tax ) {
					$tax_query[] = array(
						'taxonomy'	=> $tax,
						'field'		=> 'slug',
						'terms'		=> $terms,
						'operator' 	=> 'IN' // Allowed values AND, IN, NOT IN
					);
				}
			}
		}

		// Allowed args in WP Query
		$custom_args = array(
			'author_name' 			=> $author_name,
			'author__in' 			=> $author__in,
			'cat' 					=> $cat ? $cat : ( $cats ? $cats : null ),
			'category_name' 		=> $category_name,
			'tag' 					=> $tag ? $tag : ( $tags ? $tags : null ),
			'tag_id' 				=> $tag_id,
			'tax_query' 			=> $tax_query,
			'p' 					=> $p,
			'name' 					=> $name,
			'page_id' 				=> $page_id,
			'pagename' 				=> $pagename,
			'post__in' 				=> $post__in,
			'post__not_in' 			=> $post__not_in,
			'post_type' 			=> $post_type,
			'post_status' 			=> $post_status,
			'posts_per_page' 		=> $num,
			'offset' 				=> $offset,
			'ignore_sticky_posts' 	=> $ignore_sticky_posts,
			'order' 				=> $order,
			'orderby' 				=> $orderby,
			'year' 					=> $year,
			'monthnum' 				=> $monthnum,
			'w' 					=> $w,
			'day'					=> $day,
			'meta_key' 				=> $meta_key,
			'meta_value'			=> $meta_value,
			'meta_value_num' 		=> $meta_value_num,
			's' 					=> $s,
		);

		$new_args = array();

		// Set args which are provided by user
		foreach ( $custom_args as $key => $value ) {
			if ( isset( $value ) )
				$new_args[ $key ] = $value;
		}

		if ( is_multisite() ) {
			switch_to_blog( $blog_id );
		}
		
		// Get master class of King Composer
		$master_class = apply_filters( 'kc-el-class', $atts );

		$custom_query = new WP_Query( $new_args );

		if ( $custom_query->have_posts() ) :

			ob_start();

			$template_path = apply_filters( 'newsplus_template_path',  '/newsplus-post-templates/' );
			
			if ( locate_template( $template_path . 'slider-' . $substyle . '.php' ) ) {
				require( get_stylesheet_directory() . $template_path . 'slider-' . $substyle . '.php' );
			}
			
			else {
				require( dirname( __FILE__ ) . $template_path . 'slider-' . $substyle . '.php' );
			}

			$out = ob_get_contents();

			ob_end_clean();

			wp_reset_query();
			wp_reset_postdata(); // Restore global post data
			if ( is_multisite() ) {
				restore_current_blog(); // Restore current blog
			}
			return $out;
		else :
			return esc_attr__( 'No posts found matching your query. Please try again by changing post parameters.', 'newsplus' );
		endif;
	}
endif;

if ( ! function_exists ( 'insert_posts' ) ) :
	function insert_posts( $atts ) {
		extract( shortcode_atts( array(

			// Deprecated params
			'query_type'		=> 'category',
			'cats'				=> null,
			'posts'				=> null,
			'pages'				=> null,
			'tags'				=> null,
			'display_style'		=> '',
			'hide_meta'			=> 'false',

			// New WP Query params
			'author_name' 			=> null,
			'author__in' 			=> null,
			'cat' 					=> null,
			'category_name' 		=> null,
			'tag' 					=> null,
			'tag_id' 				=> null,
			'taxonomy' 				=> null,
			'terms'					=> null,
			'p' 					=> null,
			'name' 					=> null,
			'page_id' 				=> null,
			'pagename' 				=> null,
			'post__in' 				=> null,
			'post__not_in' 			=> null,
			'post_type' 			=> null,
			'post_status' 			=> 'publish',
			'num' 					=> 5,
			'offset' 				=> 0,
			'ignore_sticky_posts' 	=> false,
			'order' 				=> 'DESC',
			'orderby' 				=> 'date',
			'year' 					=> null,
			'monthnum' 				=> null,
			'w' 					=> null,
			'day'					=> null,
			'meta_key' 				=> null,
			'meta_value'			=> null,
			'meta_value_num' 		=> null,
			'meta_compare' 			=> '=',
			's' 					=> null,
			'blog_id'				=> null,

			// Display specific
			'template'			=> 'grid', // list, gallery
			'col'				=> 1, // for grid and gallery
			'excerpt_length'	=> '140',
			'use_word_length'	=> 'false',
			'use_short_title'	=> false,
			'ext_link'			=> false,
			'hide_image'		=> 'false',
			'hide_video'		=> 'false',
			'enable_masonry'	=> false,
			'imgwidth'			=> '',
			'imgheight'			=> '',
			'imgcrop'			=> false,
			'imgupscale'		=> 'true',
			'imgquality'		=> '80',
			'enable_schema'		=> false,
			'date_format'		=> get_option( 'date_format' ),
			'hide_cats' 		=> false,
			'hide_reviews'		=> false,
			'show_cats'			=> false, // For list small
			'show_reviews'		=> false, // For list small
			'hide_date' 		=> false,
			'hide_author' 		=> false,
			'hide_excerpt' 		=> false,
			'show_excerpt'		=> false, // For list small
			'show_avatar' 		=> false,
			'hide_views' 		=> false,
			'hide_comments' 	=> false,
			'readmore' 			=> false,
			'readmore_text' 	=> esc_attr__( 'Read more', 'newsplus' ),
			'publisher_logo' 	=> get_template_directory_uri() . '/images/logo.png',
			'excerpt_length' 	=> 140,
			'htag'				=> 'h2',
			'hsize'				=> '',
			'ptag' 				=> 'p',
			'psize' 			=> '',
			'video_custom_field' => 'pf_video',
			'split'				=> '33-67',
			'lightbox'			=> false, // Used for gallery display type
			'show_title'		=> false, // Gallery specific
			'xclass'			=> false,
			'ptclass'			=> false,
			'overlay_style'		=> 'default',
			'sharing'			=> false,
			'share_btns'		=> ''
		), $atts ) );

		// Sanitize WP Query args
		$author__in 				= $author__in ? explode( ',', $author__in ) : null;
		$post__in 					= $post__in ? explode( ',', $post__in ) : ( $posts ? explode( ',', $posts ) : ( $pages ? explode( ',', $pages ) : null ) );
		$post__not_in 				= $post__not_in ? explode( ',', $post__not_in ) : null;
		$terms 						= ( $terms ) ? explode( ',', $terms ) : null;
		$post_type					= ( $post_type ) ? explode( ',', $post_type ) : null;
		$taxonomy					= ( $taxonomy ) ? explode( ',', $taxonomy ) : null;
		$tax_query 					= null;

		if ( $taxonomy && $terms ) {
			$tax_query = array( 'relation' => 'OR' );

			if ( is_array( $taxonomy ) ) {
				foreach( $taxonomy as $tax ) {
					$tax_query[] = array(
						'taxonomy'	=> $tax,
						'field'		=> 'slug',
						'terms'		=> $terms,
						'operator' 	=> 'IN' // Allowed values AND, IN, NOT IN
					);
				}
			}
		}

		// Allowed args in WP Query
		$custom_args = array(
			'author_name' 			=> $author_name,
			'author__in' 			=> $author__in,
			'cat' 					=> $cat ? $cat : ( $cats ? $cats : null ),
			'category_name' 		=> $category_name,
			'tag' 					=> $tag ? $tag : ( $tags ? $tags : null ),
			'tag_id' 				=> $tag_id,
			'tax_query' 			=> $tax_query,
			'p' 					=> $p,
			'name' 					=> $name,
			'page_id' 				=> $page_id,
			'pagename' 				=> $pagename,
			'post__in' 				=> $post__in,
			'post__not_in' 			=> $post__not_in,
			'post_type' 			=> $post_type,
			'post_status' 			=> $post_status,
			'posts_per_page' 		=> $num,
			'offset' 				=> $offset,
			'ignore_sticky_posts' 	=> $ignore_sticky_posts,
			'order' 				=> $order,
			'orderby' 				=> $orderby,
			'year' 					=> $year,
			'monthnum' 				=> $monthnum,
			'w' 					=> $w,
			'day'					=> $day,
			'meta_key' 				=> $meta_key,
			'meta_value'			=> $meta_value,
			'meta_value_num' 		=> $meta_value_num,
			's' 					=> $s,
		);

		$new_args = array();

		// Set args which are provided by user
		foreach ( $custom_args as $key => $value ) {
			if ( isset( $value ) )
				$new_args[ $key ] = $value;
		}

		if ( is_multisite() ) {
			switch_to_blog( $blog_id );
		}
		
		// Get master class of King Composer
		$master_class = apply_filters( 'kc-el-class', $atts );

		$custom_query = new WP_Query( $new_args );

		if ( $custom_query->have_posts() ) :

			if ( $display_style == 'two-col' ) {
				$col = 2;
			}
			elseif ( $display_style == 'three-col' ) {
				$col = 3;
			}
			elseif ( $display_style == 'four-col' ) {
				$col = 4;
			}

			if ( $display_style == 'one-col' || $display_style == 'two-col' || $display_style == 'three-col' || $display_style == 'four-col' ) {
				$template = 'grid';
			}

			elseif ( $display_style == 'list-big' ) {
				$template = 'list-big';
			}

			elseif ( $display_style == 'list-small' || $display_style == 'list-plain' ) {
				$template = 'list-small';
			}

			elseif ( $display_style == 'gallery' ) {
				$template = 'gallery';
			}

			$template = ( '' == $template ) ? 'grid' : $template;

			ob_start();

			$template_path = apply_filters( 'newsplus_template_path',  '/newsplus-post-templates/' );
			
			if ( locate_template( $template_path . esc_attr( $template ) . '.php' ) ) {
				require( get_stylesheet_directory() . $template_path . esc_attr( $template ) . '.php' );
			}
			
			else {
				require( dirname( __FILE__ ) . $template_path . esc_attr( $template ) . '.php' );
			}

			$out = ob_get_contents();

			ob_end_clean();

			wp_reset_query();
			wp_reset_postdata(); // Restore global post data
			if ( is_multisite() ) {
				restore_current_blog(); // Restore current blog
			}
		return $out;

		else :
			return esc_attr__( 'No posts found matching your query. Please try again by changing post parameters.', 'newsplus' );
		endif;
	}
endif;

if ( ! function_exists( 'newsplus_sidebar' ) ) :
	function newsplus_sidebar( $atts ) {
		extract( shortcode_atts( array(
			'id'				=> 'default-sidebar',
			'xclass'			=> false
		), $atts ) );

		$id = sanitize_title($id);

		ob_start();
		printf( '<div class="widget-area%s">',
			( $xclass ) ? ' ' . esc_attr( $xclass ) : ''
		);

		if ( is_active_sidebar( $id ) ) :
			dynamic_sidebar( $id );
		endif;

		printf( '</div>' );

		$out = ob_get_contents();
		ob_end_clean();
		return $out;
	}
endif;

if ( ! function_exists ( 'newsplus_grid_list' ) ) :
	function newsplus_grid_list( $atts ) {
		extract( shortcode_atts( array(

			// Deprecated params
			'query_type'		=> 'category',
			'cats'				=> null,
			'posts'				=> null,
			'pages'				=> null,
			'tags'				=> null,
			'hide_meta'			=> 'false',

			// New WP Query params
			'author_name' 			=> null,
			'author__in' 			=> null,
			'cat' 					=> null,
			'category_name' 		=> null,
			'tag' 					=> null,
			'tag_id' 				=> null,
			'taxonomy' 				=> null,
			'terms'					=> null,
			'p' 					=> null,
			'name' 					=> null,
			'page_id' 				=> null,
			'pagename' 				=> null,
			'post__in' 				=> null,
			'post__not_in' 			=> null,
			'post_type' 			=> null,
			'post_status' 			=> 'publish',
			'num' 					=> 5,
			'offset' 				=> 0,
			'ignore_sticky_posts' 	=> false,
			'order' 				=> 'DESC',
			'orderby' 				=> 'date',
			'year' 					=> null,
			'monthnum' 				=> null,
			'w' 					=> null,
			'day'					=> null,
			'meta_key' 				=> null,
			'meta_value'			=> null,
			'meta_value_num' 		=> null,
			'meta_compare' 			=> '=',
			's' 					=> null,
			'blog_id'				=> null,

			// Display Specific
			'display_style'		=> 's1',
			'use_word_length'	=> 'false',
			'use_short_title'	=> false,
			'ext_link'			=> false,
			'hide_excerpt'		=> 'false',
			'imgquality'		=> '',
			'viewport_width'	=> 1192,
			'gutter'			=> 4,
			'aspect_ratio'		=> .75,
			'featured_label'	=> false,
			'xclass'			=> false,
			'htag'				=> 'h2',
			'hsize'				=> '',
			'htag_sub'			=> 'h2',
			'hsize_sub'			=> '14',
			'enable_schema'		=> false,
			'date_format'		=> get_option( 'date_format' ),
			'hide_cats' 		=> false,
			'hide_reviews'		=> false,
			'hide_date' 		=> false,
			'hide_author' 		=> false,
			'hide_excerpt' 		=> false,
			'show_avatar' 		=> false,
			'hide_views' 		=> false,
			'hide_comments' 	=> false,
			'readmore' 			=> false,

			// For sub tiles
			'hide_cats_sub' 		=> 'true',
			'hide_reviews_sub'		=> 'true',
			'hide_date_sub' 		=> false,
			'hide_author_sub' 		=> false,
			'hide_excerpt_sub' 		=> 'true',
			'show_avatar_sub' 		=> false,
			'hide_views_sub' 		=> 'true',
			'hide_comments_sub' 	=> 'true',
			'readmore_sub' 			=> false,
			'readmore_text' 		=> false,
			'publisher_logo' 	=> get_template_directory_uri() . '/images/logo.png',
			'excerpt_length' 	=> 140,
			'ptag' 				=> 'p',
			'psize' 			=> '',
			'xclass'			=> false,
			'sharing'			=> false,
			'share_btns'		=> ''
		), $atts ) );

		// Sanitize WP Query args
		$author__in 				= $author__in ? explode( ',', $author__in ) : null;
		$post__in 					= $post__in ? explode( ',', $post__in ) : ( $posts ? explode( ',', $posts ) : ( $pages ? explode( ',', $pages ) : null ) );
		$post__not_in 				= $post__not_in ? explode( ',', $post__not_in ) : null;
		$terms 						= ( $terms ) ? explode( ',', $terms ) : null;
		$post_type					= ( $post_type ) ? explode( ',', $post_type ) : null;
		$taxonomy					= ( $taxonomy ) ? explode( ',', $taxonomy ) : null;
		$tax_query 					= null;

		if ( $taxonomy && $terms ) {
			$tax_query = array( 'relation' => 'OR' );

			if ( is_array( $taxonomy ) ) {
				foreach( $taxonomy as $tax ) {
					$tax_query[] = array(
						'taxonomy'	=> $tax,
						'field'		=> 'slug',
						'terms'		=> $terms,
						'operator' 	=> 'IN' // Allowed values AND, IN, NOT IN
					);
				}
			}
		}

		// Allowed args in WP Query
		$custom_args = array(
			'author_name' 			=> $author_name,
			'author__in' 			=> $author__in,
			'cat' 					=> $cat ? $cat : ( $cats ? $cats : null ),
			'category_name' 		=> $category_name,
			'tag' 					=> $tag ? $tag : ( $tags ? $tags : null ),
			'tag_id' 				=> $tag_id,
			'tax_query' 			=> $tax_query,
			'p' 					=> $p,
			'name' 					=> $name,
			'page_id' 				=> $page_id,
			'pagename' 				=> $pagename,
			'post__in' 				=> $post__in,
			'post__not_in' 			=> $post__not_in,
			'post_type' 			=> $post_type,
			'post_status' 			=> $post_status,
			'posts_per_page' 		=> $num,
			'offset' 				=> $offset,
			'ignore_sticky_posts' 	=> $ignore_sticky_posts,
			'order' 				=> $order,
			'orderby' 				=> $orderby,
			'year' 					=> $year,
			'monthnum' 				=> $monthnum,
			'w' 					=> $w,
			'day'					=> $day,
			'meta_key' 				=> $meta_key,
			'meta_value'			=> $meta_value,
			'meta_value_num' 		=> $meta_value_num,
			's' 					=> $s,
		);

		$new_args = array();

		// Set args which are provided by user
		foreach ( $custom_args as $key => $value ) {
			if ( isset( $value ) )
				$new_args[ $key ] = $value;
		}

		if ( is_multisite() ) {
			switch_to_blog( $blog_id );
		}
		
		// Get master class of King Composer
		$master_class = apply_filters( 'kc-el-class', $atts );

		$custom_query = new WP_Query( $new_args );

		if ( $custom_query->have_posts() ) :
			$allowed_styles = array( 's1', 's2', 's3', 's4', 's5', 's6' );

			if ( ! in_array( $display_style, $allowed_styles ) ) {
				$display_style = 's1';
			}
			ob_start();

			$template_path = apply_filters( 'newsplus_template_path',  '/newsplus-post-templates/' );
			
			if ( locate_template( $template_path . 'tile.php' ) ) {
				require( get_stylesheet_directory() . $template_path . 'tile.php' );
			}
			
			else {
				require( dirname( __FILE__ ) . $template_path . 'tile.php' );
			}

			$out = ob_get_contents();

			ob_end_clean();


			wp_reset_query();
			wp_reset_postdata(); // Restore global post data
			if ( is_multisite() ) {
				restore_current_blog(); // Restore current blog
			}
		return $out;
		endif;
	}
endif;

if ( ! function_exists ( 'newsplus_news_ticker' ) ) :
	function newsplus_news_ticker( $atts ) {
		extract( shortcode_atts( array(
			// Deprecated params
			'query_type'		=> 'category',
			'cats'				=> null,
			'posts'				=> null,
			'pages'				=> null,
			'tags'				=> null,

			// New WP Query params
			'author_name' 			=> null,
			'author__in' 			=> null,
			'cat' 					=> null,
			'category_name' 		=> null,
			'tag' 					=> null,
			'tag_id' 				=> null,
			'taxonomy' 				=> null,
			'terms'					=> null,
			'p' 					=> null,
			'name' 					=> null,
			'page_id' 				=> null,
			'pagename' 				=> null,
			'post__in' 				=> null,
			'post__not_in' 			=> null,
			'post_type' 			=> null,
			'post_status' 			=> 'publish',
			'num' 					=> 5,
			'offset' 				=> 0,
			'ignore_sticky_posts' 	=> false,
			'order' 				=> 'DESC',
			'orderby' 				=> 'date',
			'year' 					=> null,
			'monthnum' 				=> null,
			'w' 					=> null,
			'day'					=> null,
			'meta_key' 				=> null,
			'meta_value'			=> null,
			'meta_value_num' 		=> null,
			'meta_compare' 			=> '=',
			's' 					=> null,
			'blog_id'				=> null,

			// Dislay specific
			'title_length'		=> '10',
			'ticker_label'		=> __( 'Breaking News', 'newsplus' ),
			'use_short_title'	=> false,
			'ext_link'			=> false,
			'duration'			=> 15000,
			'xclass'			=> false
		), $atts ) );

		// Sanitize WP Query args
		$author__in 				= $author__in ? explode( ',', $author__in ) : null;
		$post__in 					= $post__in ? explode( ',', $post__in ) : ( $posts ? explode( ',', $posts ) : ( $pages ? explode( ',', $pages ) : null ) );
		$post__not_in 				= $post__not_in ? explode( ',', $post__not_in ) : null;
		$terms 						= ( $terms ) ? explode( ',', $terms ) : null;
		$post_type					= ( $post_type ) ? explode( ',', $post_type ) : null;
		$taxonomy					= ( $taxonomy ) ? explode( ',', $taxonomy ) : null;
		$tax_query 					= null;

		if ( $taxonomy && $terms ) {
			$tax_query = array( 'relation' => 'OR' );

			if ( is_array( $taxonomy ) ) {
				foreach( $taxonomy as $tax ) {
					$tax_query[] = array(
						'taxonomy'	=> $tax,
						'field'		=> 'slug',
						'terms'		=> $terms,
						'operator' 	=> 'IN' // Allowed values AND, IN, NOT IN
					);
				}
			}
		}

		// Allowed args in WP Query
		$custom_args = array(
			'author_name' 			=> $author_name,
			'author__in' 			=> $author__in,
			'cat' 					=> $cat ? $cat : ( $cats ? $cats : null ),
			'category_name' 		=> $category_name,
			'tag' 					=> $tag ? $tag : ( $tags ? $tags : null ),
			'tag_id' 				=> $tag_id,
			'tax_query' 			=> $tax_query,
			'p' 					=> $p,
			'name' 					=> $name,
			'page_id' 				=> $page_id,
			'pagename' 				=> $pagename,
			'post__in' 				=> $post__in,
			'post__not_in' 			=> $post__not_in,
			'post_type' 			=> $post_type,
			'post_status' 			=> $post_status,
			'posts_per_page' 		=> $num,
			'offset' 				=> $offset,
			'ignore_sticky_posts' 	=> $ignore_sticky_posts,
			'order' 				=> $order,
			'orderby' 				=> $orderby,
			'year' 					=> $year,
			'monthnum' 				=> $monthnum,
			'w' 					=> $w,
			'day'					=> $day,
			'meta_key' 				=> $meta_key,
			'meta_value'			=> $meta_value,
			'meta_value_num' 		=> $meta_value_num,
			's' 					=> $s,
		);

		$new_args = array();

		// Set args which are provided by user
		foreach ( $custom_args as $key => $value ) {
			if ( isset( $value ) )
				$new_args[ $key ] = $value;
		}

		if ( is_multisite() ) {
			switch_to_blog( $blog_id );
		}
		
		// Get master class of King Composer
		$master_class = apply_filters( 'kc-el-class', $atts );

		$custom_query = new WP_Query( $new_args );

		if ( $custom_query->have_posts() ) :

			$out = sprintf( '<div class="np-news-ticker-container%s%s">%s<div class="np-news-ticker" data-duration="%s">',
					isset( $master_class ) ? ' ' . implode( ' ', $master_class ) : '',
					$xclass ? ' ' . esc_attr( $xclass ) : '',
					$ticker_label ? '<div class="ticker-label">' . esc_attr( $ticker_label ) . '</div>' : '',				
					(int)$duration
			);

			while ( $custom_query->have_posts() ) :
				$custom_query->the_post();
				global $multipage;
				$multipage = 0;

				$permalink = get_permalink();
				$title = newsplus_short_by_word( get_the_title(), $title_length );

				$postID = get_the_ID();

				$post_class_obj = get_post_class( $postID );
				$post_classes = '';

				if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
					foreach( $post_class_obj as $post_class ) {
						$post_classes .= ' ' . $post_class;
					}
				}

				$format = apply_filters( 'news_ticker_list_output', '<span><a href="%1$s" title="%2$s">%2$s</a></span>' );
				$out .= sprintf ( $format, $permalink, $title );

			endwhile;
			$out .= '</div></div>';
			wp_reset_query();
			wp_reset_postdata(); // Restore global post data
			if ( is_multisite() ) {
				restore_current_blog(); // Restore current blog
			}
		return $out;
		endif;
	}
endif;

if ( ! function_exists ( 'newsplus_recipe' ) ) :
	function newsplus_recipe( $atts, $content = null ) {
		extract( shortcode_atts( array(
			// Image specific
			'img_src'			=> 'featured', //media_lib, ext
			'img_lib'			=> '',
			'img_ext'			=> '',
			'img_alt'			=> '',
			'img_caption'		=> '',
			'imgwidth'			=> '',
			'imgheight'			=> '',
			'imgcrop'			=> '',
			'imgquality'		=> '',
			'img_align'			=> 'none',
			'hide_img'			=> false,
			'json_ld'			=> false, // Whether to include JSON LD microdata

			// Recipe name and summary
			'name_src'			=> 'post_title', // custom
			'name_txt'			=> '',
			'hide_name'			=> false,
			'summary'			=> '',
			'hide_summary'		=> false,
			'author_src'		=> 'post_author',
			'author_name'		=> '',
			'author_url'		=> '',
			'hide_author'		=> false,
			'hide_date'			=> false,

			// Recipe meta
			'prep_time'			=> '', // in minutes
			'cook_time'			=> '', // in minutes
			'cooking_method'	=> '',
			'recipe_category'	=> '',
			'recipe_category_other'	=> '',
			'recipe_cuisine'	=> '',
			'recipe_cuisine_other'	=> '',
			'ingredients'		=> '', // base64 and json encoded data
			'ing_heading'		=> __( 'Ingredients', 'newsplus' ),
			'method_heading'		=> __( 'Method', 'newsplus' ),
			'enable_numbering'  => 'true',
			'other_notes'		=> '',

			// Nutrition facts
			'recipe_yield'		=> '',
			'serving_size'		=> '',
			'calories'			=> '',
			'suitable_for_diet'	=> '',
			'nutrition'			=> '', // base64 and json encoded data
			'nutri_heading'		=> __( 'Nutrition Facts', 'newsplus' ),
			'hide_nutrition'  	=> false,

			// Nutrients
			'total_fat'			=> '',
			'saturated_fat'		=> '',
			'trans_fat'			=> '',
			'polyunsat_fat'		=> '',
			'monounsat_fat'		=> '',
			'cholesterol'		=> '',
			'sodium'			=> '',
			'carbohydrate'		=> '',
			'fiber'				=> '',
			'sugar'				=> '',
			'added_sugar'		=> '',
			'sugar_alcohal'		=> '',
			'protein'			=> '',
			'vitamin_d'			=> '',
			'calcium'			=> '',
			'iron'				=> '',
			'potassium'			=> '',
			'vitamin_a'			=> '',
			'vitamin_c'			=> '',
			'vitamin_e'			=> '',
			'vitamin_k'			=> '',
			'vitamin_b1'		=> '',
			'vitamin_b2'		=> '',
			'vitamin_b3'		=> '',
			'vitamin_b6'		=> '',
			'folate'			=> '',
			'vitamin_b12'		=> '',
			'biotin'			=> '',
			'vitamin_b5'		=> '',
			'phosphorus'		=> '',
			'iodine'			=> '',
			'magnesium'			=> '',
			'zinc'				=> '',
			'selenium'			=> '',
			'copper'			=> '',
			'manganese'			=> '',
			'chromium'			=> '',
			'molybdenum'		=> '',
			'chloride'			=> ''
		), $atts ) );

		ob_start();

		$template_path = apply_filters( 'newsplus_template_path', '/newsplus-post-templates/' );
		
		if ( locate_template( $template_path . 'recipe.php' ) ) {
			require( get_stylesheet_directory() . $template_path . 'recipe.php' );
		}
		
		else {
			require( dirname( __FILE__ ) . $template_path . 'recipe.php' );
		}

		$out = ob_get_contents();

		ob_end_clean();

		return $out;

	}
endif;

if ( ! function_exists ( 'newsplus_recipe_method' ) ) :
	function newsplus_recipe_method( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'method_title' => '',
			'xclass' => false,
		), $atts ) );

		$out = '';
		$num_box = '<span class="step-num step-%1$s">%1$s</span>';

		if ( isset( $GLOBALS['np_recipe_method_count'] ) )
			$GLOBALS['np_recipe_method_count']++;
		else
			$GLOBALS['np_recipe_method_count'] = 1;

		if ( '' !== $method_title ) {
			$out .= '<p class="inst-subhead"><strong>' . esc_attr( $method_title ) . '</strong></p>';
		}

		$out .= sprintf( '<div id="recipe_step_%s" class="recipe-instruction%s" itemprop="recipeInstructions">%s%s</div>',
				$GLOBALS['np_recipe_method_count'],
				$xclass ? ' ' . esc_attr( $xclass ) : '',
				sprintf( $num_box, number_format_i18n( $GLOBALS['np_recipe_method_count'] ) ),
				newsplus_return_clean( $content )
			);

		return $out;
	}
endif;

// Return parameters for BFI image resize
if ( ! function_exists ( 'newsplus_image' ) ) :
	function newsplus_image( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'src'				=> '', //media_lib, ext
			'alt'				=> '',
			'caption'			=> '',
			'align'				=> 'none',
			'imgwidth'			=> '',
			'imgheight'			=> '',
			'imgcrop'			=> '',
			'imgquality'		=> '80',
			'imgcolor'			=> '',
			'imggrayscale'		=> '',
			'linkrel'			=> '', // prettyPhoto
			'linkto'			=> 'none', // media, custom,
			'custom_url'		=> '',
			'imgtitle'			=> '',
			'target'			=> false,
			'xclass'			=> ''			
		), $atts ) );
			
		$img = newsplus_image_resize( $src, $imgwidth, $imgheight, $imgcrop, $imgquality, $imgcolor, $imggrayscale );
		$img_html = '';
		$link_open = $link_close = $div_open = $div_close = $caption_html = '';
		
		if ( isset( $img ) ) {
			
			$img_html = sprintf( '<img%s src="%s"%s />',
				( 'none' !== $align && '' == $caption ) ? ' class="align' . esc_attr( $align ) . '"' : '',
				$img,
				$alt ? ' alt="' . esc_attr( $alt ) . '"' : ''
			);
			
			if ( '' !== $caption ) {
				$div_open = sprintf( '<div class="wp-caption%s%s">',
					( 'none' !== $align ) ? ' align' . esc_attr( $align ) : '',
					$xclass ? ' ' . esc_attr( $xclass ) : ''
				);
				
				$div_close = '</div>';
				
				$caption_html = '<p class="wp-caption-text">' . $caption . '</p>';
			}		
			
			if ( 'none' !== $linkto ) {
				$link_open = sprintf( '<a href="%s"%s%s%s>',
					( 'media' == $linkto ) ? esc_url( $src ) : ( '' !== $custom_url ? esc_url( $custom_url ) : '' ),
					( '' !== $linkrel ) ? ' rel="' . esc_attr( $linkrel ) . '"' : '',
					( '' != $imgtitle ) ? ' title="' . esc_attr ( $imgtitle ) . '"' : '',
					$target ? ' target="_blank"' : ''
				);
				
				$link_close = '</a>';
			}
			
			return $div_open . $link_open . $img_html . $link_close . $caption_html . $div_close;					
			
		} //img	
	}
endif;

if ( ! function_exists ( 'newsplus_theme_url' ) ) :
	function newsplus_theme_url( $atts ) {
		extract( shortcode_atts( array(
			'child' => false
		), $atts ) );

		return ( $child ) ? get_stylesheet_directory_uri() : get_template_directory_uri();
	}
endif;

// Title Shortcode
if ( ! function_exists ( 'newsplus_title' ) ) :
	function newsplus_title( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'htag' 				=> 'h2',
			'hsize'				=> '14',
			'style'				=> 'plain',
			'margin_btm'		=> 'theme_defined',
			'color'				=> '',
			'text'				=> '',
			'link'				=> '',
			'link_title'		=> '',
			'target'			=> false,
			'sub_text'			=> '',
			'sub_link'			=> '',
			'sub_link_title'	=> '',
			'sub_target'		=> false,
			'round_corner'		=> false,
			'xclass'			=> ''
		), $atts ) );
		
		// Get master class of King Composer
		$master_class = apply_filters( 'kc-el-class', $atts );

		$main = $text ? '<span class="main-text">' . esc_attr( $text ) . '</span>' : '';
		$sub = $sub_text ? '<span class="sub-text">' . esc_attr( $sub_text ) . '</span>' : '';

		if ( $link && $text ) {
			$main = sprintf( '<a class="main-text" href="%s"%s%s>%s</a>',
						esc_url( $link ),
						$target ? ' target="_blank"' : '',
						$link_title ? ' title="' . esc_attr( $link_title ) . '"' : '',
						esc_attr( $text )
					);
		}

		if ( $sub_link && $sub_text ) {
			$sub = sprintf( '<a class="sub-text" href="%s"%s%s>%s</a>',
						esc_url( $sub_link ),
						$sub_target ? ' target="_blank"' : '',
						$sub_link_title ? ' title="' . esc_attr( $sub_link_title ) . '"' : '',
						esc_attr( $sub_text )
					);
		}

		return sprintf( '<%1$s class="newsplus-title%2$s%3$s%4$s%5$s%6$s%7$s%8$s">%9$s%10$s</%1$s>',
					$htag,
					' st-' . esc_attr( $style ),
					$color ? ' ' . esc_attr( $color ) : '',
					$hsize ? ' fs-' . esc_attr( $hsize ) : '',
					$round_corner ? ' rounded' : '',
					isset( $master_class ) ? ' ' . implode( ' ', $master_class ) : '',
					$xclass ? ' ' . esc_attr( $xclass ) : '',
					'theme_defined' !== $margin_btm ? ' btm-' . esc_attr( $margin_btm ) : '',
					$main,
					$sub
				);
	}
endif;

// Register and initialize short codes
if ( ! function_exists( 'newsplus_add_shortcodes' ) ) :
	function newsplus_add_shortcodes() {
		add_shortcode( 'col', 'col' );
		add_shortcode( 'row', 'row' );
		add_shortcode( 'tabs', 'tabs' );
		add_shortcode( 'tab', 'tab' );
		add_shortcode( 'toggle', 'toggle' );
		add_shortcode( 'accordion', 'accordion' );
		add_shortcode( 'acc_item', 'acc_item' );
		add_shortcode( 'box', 'box' );
		add_shortcode( 'hr', 'hr' );
		add_shortcode( 'btn', 'btn' );
		add_shortcode( 'indicator', 'indicator' );
		add_shortcode( 'slider', 'slider' );
		add_shortcode( 'slide', 'slide' );
		add_shortcode( 'slide_video', 'slide_text' );
		add_shortcode( 'slide_text', 'slide_text' );
		add_shortcode( 'posts_slider', 'posts_slider' );
		add_shortcode( 'posts_carousel', 'posts_carousel' );
		add_shortcode( 'insert_posts', 'insert_posts' );
		add_shortcode( 'newsplus_sidebar', 'newsplus_sidebar' );
		add_shortcode( 'newsplus_grid_list', 'newsplus_grid_list' );
		add_shortcode( 'newsplus_news_ticker', 'newsplus_news_ticker' );
		add_shortcode( 'newsplus_recipe', 'newsplus_recipe' );
		add_shortcode( 'recipe_method', 'newsplus_recipe_method' );
		add_shortcode( 'newsplus_image', 'newsplus_image' );
		add_shortcode( 'newsplus_theme_url', 'newsplus_theme_url' );
		add_shortcode( 'newsplus_title', 'newsplus_title' );
	}
endif;
add_action( 'init', 'newsplus_add_shortcodes' );
?>