<?php
/*
 Plugin Name: NewsPlus Shortcodes
 Version: 3.1.4
 Author: Saurabh Sharma
 Author URI: http://themeforest.net/user/SaurabhSharma
 Description: Shortcodes and widgets for the NewsPlus WordPress theme
*/

class NewsPlus_Shortcodes {

	function __construct() {
		require_once( 'shortcodes/shortcodes.php' );
		require_once( 'shortcodes/visual-shortcodes.php' );
		require_once( 'widgets/widgets.php' );
		require_once( 'includes/BFI_Thumb.php' );
		require_once( 'includes/kc_shortcode_map.php' );
		add_action( 'init', array(&$this, 'init') );
	}

	function init() {

		// Translation
		load_plugin_textdomain( 'newsplus', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

		if ( ! is_admin() ) {

				// CSS files
				wp_enqueue_style( 'newsplus-fontawesome', plugin_dir_url( __FILE__ ) . 'assets/css/font-awesome.min.css' );
				wp_enqueue_style( 'newsplus-shortcodes', plugin_dir_url( __FILE__ ) . 'assets/css/newsplus-shortcodes.css' );
				wp_enqueue_style( 'newsplus-owl-carousel', plugin_dir_url( __FILE__ ) . 'assets/css/owl.carousel.css', array(), null );
				wp_enqueue_style( 'newsplus-prettyphoto', plugin_dir_url( __FILE__ ) . 'assets/css/prettyPhoto.css', array(), null );
				if ( is_rtl() ) {
					wp_enqueue_style( 'newsplus-shortcodes-rtl', plugin_dir_url( __FILE__ ) . 'assets/css/rtl-newsplus-shortcodes.css' );
				}

				// JavaScript files
				wp_enqueue_script( 'jquery' );
				wp_enqueue_script( 'jquery-masonry' );
				wp_enqueue_script( 'newsplus-custom-js', plugin_dir_url( __FILE__ ) . 'assets/js/custom.js', array( 'jquery' ), '', true );
				wp_enqueue_script( 'jq-easing', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.easing.min.js', array(), '', true );
				wp_enqueue_script( 'newsplus-jq-owl-carousel', plugin_dir_url( __FILE__ ) . 'assets/js/owl.carousel.min.js', array( 'jquery' ), '', true );
				wp_enqueue_script( 'newsplus-prettyphoto-js', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.prettyPhoto.js', array(), '', true );
				wp_enqueue_script( 'jq-marquee', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.marquee.min.js', array(), '', true );
		}

	}
}
$newsplus_shortcodes = new NewsPlus_Shortcodes();
?>