<?php
/**
 * Theme options
 *
 * @package NewsPlus
 * @since 1.0.0
 * @version 3.1.4
 */
 
// Load text domain for translation.
load_theme_textdomain( 'newsplus', get_template_directory() . '/languages' );
$newsplus_google_font_list = newsplus_google_font_list();

$newsplus_options = array(
		array( 'type'	=> 'wrap_start' ),

		array( 'type'	=> 'tabs_start' ),

		array(
			'name'		=> __( 'General', 'newsplus' ),
			'id'		=> 'pls_general',
			'type'		=> 'heading'
		),

		array(
			'name'		=> __( 'Header', 'newsplus' ),
			'id'		=> 'pls_header_area',
			'type'		=> 'heading'
		),

		array(
			'name'		=> __( 'Archives', 'newsplus' ),
			'id'		=> 'pls_blog',
			'type'		=> 'heading'
		),
		
		array(
			'name'		=> __( 'Single Post', 'newsplus' ),
			'id'		=> 'pls_single',
			'type'		=> 'heading'
		),

		array(
			'name'		=> __( 'Contact', 'newsplus' ),
			'id'		=> 'pls_contact',
			'type'		=> 'heading'
		),

		array(
			'name'		=> __( 'Footer', 'newsplus' ),
			'id'		=> 'pls_footer',
			'type'		=> 'heading'
		),

		array(
			'name'		=> __( 'Custom Font', 'newsplus' ),
			'id'		=> 'pls_custom_font',
			'type'		=> 'heading'
		),

		array(
			'name'		=> __( 'Image Sizes', 'newsplus' ),
			'id'		=> 'pls_image_sizes',
			'type'		=> 'heading'
		),
		
		array(
			'name'		=> __( 'Custom Menus', 'newsplus' ),
			'id'		=> 'pls_custom_menus',
			'type'		=> 'heading'
		),
		
		array(
			'name'		=> __( 'Import / Export', 'newsplus' ),
			'id'		=> 'pls_import_export',
			'type'		=> 'heading'
		),		

		array( 'type'	=> 'tabs_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_general'
		),

		array(
			'name'		=> __( 'General Settings for the theme', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_color_scheme' => array(
			'name'		=> __( 'Color scheme', 'newsplus' ),
			'desc'		=> __( 'Select a color scheme for theme highlights like main menu and footer widget area.', 'newsplus' ),
			'id'		=> 'pls_color_scheme',
			'std'		=> 'customizer',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Use customizer', 'newsplus' ) => 'customizer',
							__( 'Default', 'newsplus' ) => 'default',							
							__( 'Blue', 'newsplus' ) => 'blue',
							__( 'Brown', 'newsplus' ) => 'brown',
							__( 'Cyan', 'newsplus' ) => 'cyan',
							__( 'Green', 'newsplus' ) => 'green',
							__( 'Grey', 'newsplus' ) => 'grey',
							__( 'Magenta', 'newsplus' ) => 'magenta',
							__( 'Red', 'newsplus' ) => 'red',
							__( 'Orange', 'newsplus' ) => 'orange',
							__( 'Teal', 'newsplus' ) => 'teal'						
						)
		),		

		'pls_layout' => array(
			'name'		=> __( 'Layout Style:', 'newsplus' ),
			'desc'		=> __( 'Select a layout style for the theme.', 'newsplus' ),
			'id'		=> 'pls_layout',
			'std'		=> 'boxed',
			'type'		=> 'select',
			'options'	=> array( 'Boxed' => 'boxed', 'Stretched' => 'stretched' )
		),
		
		'pls_layout_width' => array(
			'name'		=> __( 'Layout Width:', 'newsplus' ),
			'desc'		=> __( 'Enter a layout width in px (without unit). Min: 800, Max: 1600', 'newsplus' ),
			'id'		=> 'pls_layout_width',
			'std'		=> '1160',
			'type'		=> 'number',
			'min'		=> '800',
			'max'		=> '1600'
		),
		
		'pls_base_font_size' => array(
			'name'		=> __( 'Base font size:', 'newsplus' ),
			'desc'		=> __( 'Enter a base font size in px (without unit). Min: 11, Max: 18', 'newsplus' ),
			'id'		=> 'pls_base_font_size',
			'std'		=> '13',
			'type'		=> 'number',
			'min'		=> '11',
			'max'		=> '18'
		),
		
		'pls_sb_pos' => array(
			'name'		=> __( 'Global Site layout', 'newsplus' ),
			'desc'		=> __( 'Select a global site layout.', 'newsplus' ),
			'id'		=> 'pls_sb_pos',
			'std'		=> 'ca',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Content + Sidebar A', 'newsplus' ) => 'ca',
							__( 'Sidebar A + Content', 'newsplus' ) => 'ac',
							__( 'Content + Sidebar B + Sidebar A', 'newsplus' ) => 'cab',
							__( 'Sidebar A + Content + Sidebar B', 'newsplus' ) => 'acb',
							__( 'Sidebar B + Content + Sidebar A', 'newsplus' ) => 'bca',
							__( 'Sidebar A + Sidebar B + Content', 'newsplus' ) => 'abc',
							__( 'No Sidebars', 'newsplus' ) => 'no-sb'
						)
		),
		
		'pls_sb_ratio' => array(
			'name'		=> __( 'Main Content + Sidebar A ratio', 'newsplus' ),
			'desc'		=> __( 'Select a split ratio (in %) for main content and sidebar A column.', 'newsplus' ),
			'id'		=> 'pls_sb_ratio',
			'std'		=> '70-30',
			'type'		=> 'select',
			'options'	=> array( '70-30', '75-25', '66-33', '60-40', '50-50' )
		),				

		'pls_custom_head_code' => array(
			'name'		=> __( 'Custom head markup:', 'newsplus' ),
			'desc'		=> __( 'Use this section for inserting any custom CSS or script inside head node of the site. For example, Google Analytics code, Google font CSS, or custom scripts.', 'newsplus' ),
			'id'		=> 'pls_custom_head_code',
			'std'		=> '',
			'type'		=> 'textarea'
		),
		
		'pls_schema' => array(
			'name'		=> __( 'Schema Markup', 'newsplus' ),
			'label'		=> __( 'Enable Schema Microdata on entire site.', 'newsplus' ),
			'desc'		=> __( 'When using shortcodes, you can enable or disable schema using enable_schema=\'true\' parameter inside shortcodes.', 'newsplus' ),
			'id'		=> 'pls_schema',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_date_format' => array(
			'name'		=> __( 'Date format', 'newsplus' ),
			'desc'		=> __( 'Select a date format for archives and posts', 'newsplus' ),
			'id'		=> 'pls_date_format',
			'std'		=> 'global',
			'type'		=> 'select',
			'options'	=> array( 'Global' => 'global', 'Human Time Difference' => 'human' )
		),		

		'pls_hide_crumbs' => array(
			'name'		=> __( 'Breadcrumbs', 'newsplus' ),
			'label'		=> __( 'Hide breadcrumbs on all pages', 'newsplus' ),
			'id'		=> 'pls_hide_crumbs',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_collapse_lists' => array(
			'name'		=> __( 'Collapsible widget lists', 'newsplus' ),
			'label'		=> __( 'Enable collapsible list items in widgets', 'newsplus' ),
			'desc'		=> __( 'If enabled, sub-lists in widgets like category, pages and custom menu will be converted into accordion like collapsible items.', 'newsplus' ),
			'id'		=> 'pls_collapse_lists',
			'type'		=> 'checkbox',
			'std'		=> false
		),		
		
		'pls_disable_resp_css' => array(
			'name'		=> __( 'Responsive CSS', 'newsplus' ),
			'label'		=> __( 'Disable responsive.css file', 'newsplus' ),
			'id'		=> 'pls_disable_resp_css',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_disable_resp_menu' => array(
			'name'		=> __( 'Responsive menu', 'newsplus' ),
			'label'		=> __( 'Disable responsive menu', 'newsplus' ),
			'desc'		=> __( 'Check to disable only the responsive menu. This option is useful when using mega menu plugins which add their own responsive menu. In that case theme menu shall be disabled.', 'newsplus' ),
			'id'		=> 'pls_disable_resp_menu',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_disable_user_css' => array(
			'name'		=> __( 'User CSS', 'newsplus' ),
			'label'		=> __( 'Disable user.css file', 'newsplus' ),
			'desc'		=> __( 'Check to disable user.css file. Located as <code>newsplus/user.css</code> This file can be used to add your custom styles without modifying actual style.css file.', 'newsplus' ),
			'id'		=> 'pls_disable_user_css',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_enable_rtl_css' => array(
			'name'		=> __( 'RTL CSS', 'newsplus' ),
			'label'		=> __( 'Enable rtl.css file', 'newsplus' ),
			'desc'		=> __( 'Check to enable rtl.css file. Located as <code>newsplus/rtl.css</code> If using RTL installation of WordPress, this file is automatically loaded. You can also load it forcefully by enabling this option.', 'newsplus' ),
			'id'		=> 'pls_enable_rtl_css',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_hide_secondary' => array(
			'name'		=> __( 'Secondary Widget Area', 'newsplus' ),
			'label'		=> __( 'Hide Secondary Widget Area', 'newsplus' ),
			'desc'		=> __( 'Hide secondary widget area on archives, category, search, author etc. You can control individual setting for Pages and Posts inside their options panel.', 'newsplus' ),
			'id'		=> 'pls_hide_secondary',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_page_titles' => array(
			'name'		=> __( 'Page Titles', 'newsplus' ),
			'label'		=> __( 'Hide page titles', 'newsplus' ),
			'desc'		=> __( 'Hide page titles globally across entire site.<br/> You can also hide page titles per page using page options panel.', 'newsplus' ),
			'id'		=> 'pls_hide_page_titles',
			'type'		=> 'checkbox',
			'std'		=> false
		),		

		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_header_area'
		),		
		
		array(
			'name'		=> __( 'Header Area Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),		
		
		'pls_header_style' => array(
			'name'		=> __( 'Header Style', 'newsplus' ),
			'desc'		=> __( 'Select a header style for the site.', 'newsplus' ),
			'id'		=> 'pls_header_style',
			'std'		=> 'default',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Default', 'newsplus' ) => 'default',
							__( 'Three columnar', 'newsplus' ) => 'three-col',
							__( 'Full width', 'newsplus' ) => 'full-width',
							__( 'Slim inline', 'newsplus' ) => 'slim'
						)
		),
		
		'pls_top_bar_sticky' => array(
			'name'		=> __( 'Top sticky nav', 'newsplus' ),
			'label'		=> __( 'Enable sticky top utility bar', 'newsplus' ),
			'id'		=> 'pls_top_bar_sticky',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_main_bar_sticky' => array(
			'name'		=> __( 'Main sticky nav', 'newsplus' ),
			'label'		=> __( 'Enable sticky main navigation bar', 'newsplus' ),
			'id'		=> 'pls_main_bar_sticky',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_disable_sticky_on_mobile' => array(
			'name'		=> __( 'Sticky nav on mobile', 'newsplus' ),
			'label'		=> __( 'Disable sticky navbars on mobile', 'newsplus' ),
			'id'		=> 'pls_disable_sticky_on_mobile',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_inline_search_box' => array(
			'name'		=> __( 'Search box in main menu', 'newsplus' ),
			'label'		=> __( 'Enable search box in main navigation bar', 'newsplus' ),
			'id'		=> 'pls_inline_search_box',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		array(
			'name'		=> __( 'Site Name/Logo Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_logo_check' => array(
			'name'		=> __( 'Site logo', 'newsplus' ),
			'label'		=> __( 'Show logo as image', 'newsplus' ),
			'desc'		=> __( 'Check to display logo image instead of site name and description', 'newsplus' ),
			'id'		=> 'pls_logo_check',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_desc' => array(
			'name'		=> __( 'Hide site description', 'newsplus' ),
			'label'		=> __( 'Hide site description', 'newsplus' ),
			'desc'		=> __( 'Check to hide site description.', 'newsplus' ),
			'id'		=> 'pls_hide_desc',
			'type'		=> 'checkbox',
			'std'		=> false
		),		

		'pls_logo' => array(
			'name'		=> __( 'Custom Logo URL', 'newsplus' ),
			'desc'		=> __( 'Enter full URL of your Logo image. You can upload logo to media library or theme images folder and paste file URL here.', 'newsplus' ),
			'id'		=> 'pls_logo',
			'std'		=> '',
			'type'		=> 'image_uploader'
		),

		'pls_custom_title' => array(
			'name'		=> __( 'Custom Site Title', 'newsplus' ),
			'desc'		=> __( 'Enter custom site title other than your default site title. This is used to allow HTML in site title. This title will be shown when not using logo image.', 'newsplus' ),
			'id'		=> 'pls_custom_title',
			'std'		=> '',
			'type'		=> 'text'
		),
		
		'pls_logo_align' => array(
			'name'		=> __( 'Logo Placement', 'newsplus' ),
			'desc'		=> __( 'Select a logo placement in header area. If chosen none, logo will be replaced by widget area. The \'center\' alignment is applied only to full width or three columnar header style.', 'newsplus' ),
			'id'		=> 'pls_logo_align',
			'std'		=> 'left',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Left', 'newsplus' ) => 'left',
							__( 'Center', 'newsplus' ) => 'center',
							__( 'Right', 'newsplus' ) => 'right',
							__( 'None', 'newsplus' ) => 'none'
						)
		),
		
		'pls_menu_align' => array(
			'name'		=> __( 'Menu alignment', 'newsplus' ),
			'desc'		=> __( 'Select a menu alignment. The center align is not applicable on Slim header style.', 'newsplus' ),
			'id'		=> 'pls_menu_align',
			'std'		=> 'default',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Default', 'newsplus' ) => 'default',
							__( 'Center', 'newsplus' ) => 'center'
						)
		),		
		
		array(
			'name'		=> __( 'News Ticker Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_ticker_placement' => array(
			'name'		=> __( 'News Ticker Placement', 'newsplus' ),
			'desc'		=> __( 'Choose where to display news ticker automatically. (You can use the [newsplus_news_ticker] shortcode on individual pages as well).', 'newsplus' ),
			'id'		=> 'pls_ticker_placement',
			'std'		=> 'none',
			'type'		=> 'select',
			'options'	=> array(
							__( 'None', 'newsplus' ) => 'none',
							__( 'Below Top Menu', 'newsplus' ) => 'below_top_menu',
							__( 'Below Main Menu', 'newsplus' ) => 'below_main_menu'
						)
		),
		
		'pls_ticker_cats' => array(
			'name'		=> __( 'Category IDs for news ticker', 'newsplus' ),
			'desc'		=> __( 'Provide numeric category IDs, separated by comma, from which posts shall be displayed in news ticker. E.g. 3,15,24', 'newsplus' ),
			'id'		=> 'pls_ticker_cats',
			'std'		=> '',
			'type'		=> 'text'
		),
		
		'pls_ticker_num' => array(
			'name'		=> __( 'Number of posts in ticker', 'newsplus' ),
			'desc'		=> __( 'Enter number of posts to be shown in ticker. E.g. 5', 'newsplus' ),
			'id'		=> 'pls_ticker_num',
			'std'		=> '5',
			'type'		=> 'number',
			'min'		=> '1',
			'max'		=> '999'
		),
		
		'pls_ticker_label' => array(
			'name'		=> __( 'News Ticker Label', 'newsplus' ),
			'desc'		=> __( 'Provide a ticker label text. Default is \'Breaking News\'.', 'newsplus' ),
			'id'		=> 'pls_ticker_label',
			'std'		=> '',
			'type'		=> 'text'
		),
		
		'pls_ticker_home_check' => array(
			'name'		=> __( 'Limit to Home page', 'newsplus' ),
			'label'		=> __( 'Show news ticker only on Home page', 'newsplus' ),
			'id'		=> 'pls_ticker_home_check',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		array(
			'name'		=> __( 'Top Navbar Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_cb_item_left' => array(
			'name'		=> __( 'Top Left callout section', 'newsplus' ),
			'desc'		=> __( 'Choose what to display inside top-left callout section. Optional menu, or custom text.', 'newsplus' ),
			'id'		=> 'pls_cb_item_left',
			'std'		=> 'menu',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Nav Menu', 'newsplus' ) => 'menu',
							__( 'Text Content', 'newsplus' ) => 'text'
						)
		),

		'pls_cb_text_left' => array(
			'name'		=> __( 'Top left Callout Text:', 'newsplus' ),
			'desc'		=> __( 'Enter custom text that should appear on left side of top utility bar.', 'newsplus' ),
			'id'		=> 'pls_cb_text_left',
			'std'		=> 'Optional callout text left side.',
			'type'		=> 'textarea'
		),

		'pls_cb_item_right' => array(
			'name'		=> __( 'Top Right callout section', 'newsplus' ),
			'desc'		=> __( 'Choose what to display inside top-right callout section. Searchform, custom text, or shopping cart.', 'newsplus' ),
			'id'		=> 'pls_cb_item_right',
			'std'		=> 'searchform',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Searchform', 'newsplus' ) => 'searchform',
							__( 'Text Content', 'newsplus' ) => 'text',
							__( 'WooCommerce Cart', 'newsplus' ) => 'cart'
						)
		),

		'pls_cb_text_right' => array(
			'name'		=> __( 'Top Right Callout Text:', 'newsplus' ),
			'desc'		=> __( 'Enter custom text that should appear on right side of top utility bar.', 'newsplus' ),
			'id'		=> 'pls_cb_text_right',
			'std'		=> 'Optional callout text right side.',
			'type'		=> 'textarea'
		),
		
		'pls_top_bar_hide' => array(
			'name'		=> __( 'Disable top bar', 'newsplus' ),
			'label'		=> __( 'Disable top utility bar', 'newsplus' ),
			'id'		=> 'pls_top_bar_hide',
			'type'		=> 'checkbox',
			'std'		=> false
		),


		
		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_blog'
		),

		array(
			'name'		=> __( 'Archive Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_archive_template' => array(
			'name'		=> __( 'Global Archives Template', 'newsplus' ),
			'desc'		=> __( 'Select a template for default blog and archives.', 'newsplus' ),
			'id'		=> 'pls_archive_template',
			'std'		=> 'grid',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Grid', 'newsplus' ) => 'grid',
							__( 'List Big', 'newsplus' ) => 'list',
							__( 'Classic', 'newsplus' ) => 'classic',
							__( 'Full Posts', 'newsplus' ) => 'full',
							__( 'Card', 'newsplus' ) => 'card',
						)
		),
		
		'pls_grid_col' => array(
			'name'		=> __( 'Grid columns', 'newsplus' ),
			'desc'		=> __( 'Select number of grid columns for grid style archives.', 'newsplus' ),
			'id'		=> 'pls_grid_col',
			'std'		=> '2',
			'type'		=> 'select',
			'options'	=> array( '2', '3', '4')
		),
		
		'pls_list_split' => array(
			'name'		=> __( 'List split ratio', 'newsplus' ),
			'desc'		=> __( 'Select split ratio for thumbnail + content inside list style archives.', 'newsplus' ),
			'id'		=> 'pls_list_split',
			'std'		=> '33-67',
			'type'		=> 'select',
			'options'	=> array(
				'33% - 67%' => '33-67',
				'20% - 80%' => '20-80',
				'25% - 75%' => '25-75',
				'40% - 60%' => '40-60',
				'50% - 50%' => '50-50',
			)
		),		
		
		'pls_archive_fw' => array(
			'name'		=> __( 'Archive full width', 'newsplus' ),
			'label'		=> __( 'Enable full width on archive templates', 'newsplus' ),
			'desc'		=> __( 'This option will hide sidebar on all archives.', 'newsplus' ),
			'id'		=> 'pls_archive_fw',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_enable_masonry' => array(
			'name'		=> __( 'Masonry layout', 'newsplus' ),
			'label'		=> __( 'Enable masonry layout on grid archive templates', 'newsplus' ),
			'id'		=> 'pls_enable_masonry',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_short_title' => array(
			'name'		=> __( 'Short titles', 'newsplus' ),
			'label'		=> __( 'Enable short title support in post archives.', 'newsplus' ),
			'desc'		=> __( 'It will be required to add a custom field \'np_short_title\' to the post with the value as your short title.', 'newsplus' ),
			'id'		=> 'pls_short_title',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_ext_link' => array(
			'name'		=> __( 'Custom links', 'newsplus' ),
			'label'		=> __( 'Enable custom links support in post archives.', 'newsplus' ),
			'desc'		=> __( 'It will be required to add a custom field \'np_custom_link\' to the post with the value as your custom link. This option is useful to show affiliate links in post archives.', 'newsplus' ),
			'id'		=> 'pls_ext_link',
			'type'		=> 'checkbox',
			'std'		=> false
		),		
		
		'pls_hide_blog_full_images' => array(
			'name'		=> __( 'Auto featured images', 'newsplus' ),
			'label'		=> __( 'Disable auto insertion of featured images in Blog - full style', 'newsplus' ),
			'id'		=> 'pls_hide_blog_full_images',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_disable_video' => array(
			'name'		=> __( 'Video embeds', 'newsplus' ),
			'label'		=> __( 'Disable video embed in post archives', 'newsplus' ),
			'desc'		=> __( 'If checked, a featured image with video icon will be shown.', 'newsplus' ),
			'id'		=> 'pls_disable_video',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_use_word_length' => array(
			'name'		=> __( 'Excerpt shortening', 'newsplus' ),
			'label'		=> __( 'Enable word length in archive excerpts', 'newsplus' ),
			'desc'		=> __( 'Check to enable word length in archive excerpts. By default character length is used which may not work well in Chinese characters. So use word length for Chinese language.', 'newsplus' ),
			'id'		=> 'pls_use_word_length',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_word_length' => array(
			'name'		=> __( 'Word length for archive excerpts', 'newsplus' ),
			'desc'		=> __( 'Enter a word length for archive excerpts.', 'newsplus' ),
			'id'		=> 'pls_word_length',
			'std'		=> '20',
			'type'		=> 'number',
			'min'		=> '1',
			'max'		=> '999'
		),
		
		'pls_char_length' => array(
			'name'		=> __( 'Character length for archive excerpts', 'newsplus' ),
			'desc'		=> __( 'Enter a character length for archive excerpts. This will be used if Word length option is disabled.', 'newsplus' ),
			'id'		=> 'pls_char_length',
			'std'		=> '180',
			'type'		=> 'number',
			'min'		=> '1',
			'max'		=> '9999'
		),
		
		array(
			'name'		=> __( 'Post meta settings', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_hide_cats' => array(
			'name'		=> __( 'Category links', 'newsplus' ),
			'label'		=> __( 'Hide category links', 'newsplus' ),
			'id'		=> 'pls_hide_cats',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_reviews' => array(
			'name'		=> __( 'Review Stars', 'newsplus' ),
			'label'		=> __( 'Hide review stars', 'newsplus' ),
			'id'		=> 'pls_hide_reviews',
			'desc'		=> __( 'This feature requires WP Review plugin.', 'newsplus' ),
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_views' => array(
			'name'		=> __( 'Post Views', 'newsplus' ),
			'label'		=> __( 'Hidepost views', 'newsplus' ),
			'id'		=> 'pls_hide_views',
			'desc'		=> __( 'This feature requires Post Views Counter plugin.', 'newsplus' ),
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_date' => array(
			'name'		=> __( 'Post Date', 'newsplus' ),
			'label'		=> __( 'Hide post date', 'newsplus' ),
			'id'		=> 'pls_hide_date',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_author' => array(
			'name'		=> __( 'Author link', 'newsplus' ),
			'label'		=> __( 'Hide author link', 'newsplus' ),
			'id'		=> 'pls_hide_author',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_show_avatar' => array(
			'name'		=> __( 'Author Avatar', 'newsplus' ),
			'label'		=> __( 'Show author avatar', 'newsplus' ),
			'id'		=> 'pls_show_avatar',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_excerpt' => array(
			'name'		=> __( 'Post excerpt', 'newsplus' ),
			'label'		=> __( 'Hide post excerpt', 'newsplus' ),
			'id'		=> 'pls_hide_excerpt',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_comments' => array(
			'name'		=> __( 'Comments link', 'newsplus' ),
			'label'		=> __( 'Hide comments link', 'newsplus' ),
			'id'		=> 'pls_hide_comments',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_readmore' => array(
			'name'		=> __( 'Readmore link', 'newsplus' ),
			'label'		=> __( 'Show a readmore link', 'newsplus' ),
			'id'		=> 'pls_readmore',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_inline_sharing' => array(
			'name'		=> __( 'Social Sharing', 'newsplus' ),
			'label'		=> __( 'Show social sharing per post in archives', 'newsplus' ),
			'id'		=> 'pls_inline_sharing',
			'type'		=> 'checkbox',
			'std'		=> false
		),
        
        'pls_inline_social_btns' => array(
			'name'		=> __( 'Buttons to show', 'newsplus' ),
			'desc'		=> __( 'Select social buttons to show on archive posts', 'newsplus' ),
			'id'		=> 'pls_inline_social_btns',
			'std'		=> '',
			'type'		=> 'multiselect',
			'options'	=> array(
							'Twitter' => 'twitter',
							'Facebook' => 'facebook',
							'Whatsapp' => 'whatsapp',
							'GooglePlus' => 'googleplus',
							'LinkedIn' => 'linkedin',							
							'Pinterest' => 'pinterest',
							'VKOntakte' => 'vkontakte',
							'Email' => 'email',
							'Reddit' => 'reddit'
						)
		),

		array( 'type' 	=> 'tabbed_end' ),
		
		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_single'
		),
		
		array(
			'name'		=> __( 'Single post settings', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_author' => array(
			'name'		=> __( 'Author Bio', 'newsplus' ),
			'label'		=> __( 'Hide author bio on single post', 'newsplus' ),
			'id'		=> 'pls_author',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_post_navigation' => array(
			'name'		=> __( 'Posts navigation', 'newsplus' ),
			'label'		=> __( 'Hide posts navigation on single post', 'newsplus' ),
			'id'		=> 'pls_post_navigation',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_hide_feat_image' => array(
			'name'		=> __( 'Single post image', 'newsplus' ),
			'label'		=> __( 'Disable auto insertion of featured images in single posts', 'newsplus' ),
			'id'		=> 'pls_hide_feat_image',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_disable_single_video' => array(
			'name'		=> __( 'Single post video', 'newsplus' ),
			'label'		=> __( 'Disable auto insertion of video embed in single posts', 'newsplus' ),
			'id'		=> 'pls_disable_single_video',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_hide_tags' => array(
			'name'		=> __( 'Tag list', 'newsplus' ),
			'label'		=> __( 'Hide tag list in single posts', 'newsplus' ),
			'id'		=> 'pls_hide_tags',
			'type'		=> 'checkbox',
			'std'		=> false
		),		
		
		array(
			'name'		=> __( 'Post meta settings for Single posts', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_sng_hide_cats' => array(
			'name'		=> __( 'Category links', 'newsplus' ),
			'label'		=> __( 'Hide category links', 'newsplus' ),
			'id'		=> 'pls_sng_hide_cats',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_sng_hide_reviews' => array(
			'name'		=> __( 'Review Stars', 'newsplus' ),
			'label'		=> __( 'Hide review stars', 'newsplus' ),
			'id'		=> 'pls_sng_hide_reviews',
			'desc'		=> __( 'This feature requires WP Review plugin.', 'newsplus' ),
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_sng_hide_views' => array(
			'name'		=> __( 'Post Views', 'newsplus' ),
			'label'		=> __( 'Hidepost views', 'newsplus' ),
			'id'		=> 'pls_sng_hide_views',
			'desc'		=> __( 'This feature requires Post Views Counter plugin.', 'newsplus' ),
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_sng_hide_date' => array(
			'name'		=> __( 'Post Date', 'newsplus' ),
			'label'		=> __( 'Hide post date', 'newsplus' ),
			'id'		=> 'pls_sng_hide_date',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_sng_hide_author' => array(
			'name'		=> __( 'Author link', 'newsplus' ),
			'label'		=> __( 'Hide author link', 'newsplus' ),
			'id'		=> 'pls_sng_hide_author',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_sng_show_avatar' => array(
			'name'		=> __( 'Author Avatar', 'newsplus' ),
			'label'		=> __( 'Show author avatar', 'newsplus' ),
			'id'		=> 'pls_sng_show_avatar',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_sng_hide_comments' => array(
			'name'		=> __( 'Comments link', 'newsplus' ),
			'label'		=> __( 'Hide comments link', 'newsplus' ),
			'id'		=> 'pls_sng_hide_comments',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		array(
			'name'		=> __( 'Related posts settings', 'newsplus' ),
			'type'		=> 'subheading'
		),		

		'pls_rp' => array(
			'name'		=> __( 'Related posts', 'newsplus' ),
			'label'		=> __( 'Hide related posts on single post', 'newsplus' ),
			'id'		=> 'pls_rp',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_rp_taxonomy' => array(
			'name'		=> __( 'Related posts taxonomy', 'newsplus' ),
			'desc'		=> __( 'Select a taxonomy for related posts.', 'newsplus' ),
			'id'		=> 'pls_rp_taxonomy',
			'std'		=> 'category',
			'type'		=> 'select',
			'options'	=> array(
							'Category' => 'category',
							'Tags' => 'tags'
						)
		),

		'pls_rp_style' => array(
			'name'		=> __( 'Related posts display style:', 'newsplus' ),
			'desc'		=> __( 'Select a display style for related posts.', 'newsplus' ),
			'id'		=> 'pls_rp_style',
			'std'		=> 'thumbnail',
			'type'		=> 'select',
			'options'	=> array(
							__( 'Thumbnail', 'newsplus' ) => 'thumbnail',
							__( 'List', 'newsplus' ) => 'list'
						)
		),

		'pls_rp_num' => array(
			'name'		=> __( 'Number of related posts to show:', 'newsplus' ),
			'desc'		=> __( 'Enter a number for posts to show.', 'newsplus' ),
			'id'		=> 'pls_rp_num',
			'std'		=> '3',
			'type'		=> 'number',
			'min'		=> '1',
			'max'		=> '999'
		),
		
		'pls_rp_grid_col' => array(
			'name'		=> __( 'Grid columns', 'newsplus' ),
			'desc'		=> __( 'Select number of grid columns for grid style related posts.', 'newsplus' ),
			'id'		=> 'pls_rp_grid_col',
			'std'		=> '3',
			'type'		=> 'select',
			'options'	=> array( '2', '3', '4')
		),			
		
		array(
			'name'		=> __( 'Post meta settings for related posts', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_rp_hide_cats' => array(
			'name'		=> __( 'Category links', 'newsplus' ),
			'label'		=> __( 'Hide category links', 'newsplus' ),
			'id'		=> 'pls_rp_hide_cats',
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		'pls_rp_hide_reviews' => array(
			'name'		=> __( 'Review Stars', 'newsplus' ),
			'label'		=> __( 'Hide review stars', 'newsplus' ),
			'id'		=> 'pls_rp_hide_reviews',
			'desc'		=> __( 'This feature requires WP Review plugin.', 'newsplus' ),
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		'pls_rp_hide_views' => array(
			'name'		=> __( 'Post Views', 'newsplus' ),
			'label'		=> __( 'Hide post views', 'newsplus' ),
			'id'		=> 'pls_rp_hide_views',
			'desc'		=> __( 'This feature requires Post Views Counter plugin.', 'newsplus' ),
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		'pls_rp_hide_date' => array(
			'name'		=> __( 'Post Date', 'newsplus' ),
			'label'		=> __( 'Hide post date', 'newsplus' ),
			'id'		=> 'pls_rp_hide_date',
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		'pls_rp_hide_author' => array(
			'name'		=> __( 'Author link', 'newsplus' ),
			'label'		=> __( 'Hide author link', 'newsplus' ),
			'id'		=> 'pls_rp_hide_author',
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		'pls_rp_show_avatar' => array(
			'name'		=> __( 'Author Avatar', 'newsplus' ),
			'label'		=> __( 'Show author avatar', 'newsplus' ),
			'id'		=> 'pls_rp_show_avatar',
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		'pls_rp_hide_excerpt' => array(
			'name'		=> __( 'Excerpt', 'newsplus' ),
			'label'		=> __( 'Hide post excerpt', 'newsplus' ),
			'id'		=> 'pls_rp_hide_excerpt',
			'type'		=> 'checkbox',
			'std'		=> ''
		),		
		
		'pls_rp_hide_comments' => array(
			'name'		=> __( 'Comments link', 'newsplus' ),
			'label'		=> __( 'Hide comments link', 'newsplus' ),
			'id'		=> 'pls_rp_hide_comments',
			'type'		=> 'checkbox',
			'std'		=> ''
		),
		
		array(
			'name'		=> __( 'Social Sharing Counters Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_ss_sharing' => array(
			'name'		=> __( 'Social sharing counters', 'newsplus' ),
			'label'		=> __( 'Show social sharing counters on single posts', 'newsplus' ),
			'id'		=> 'pls_ss_sharing',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_ss_fb' => array(
			'name'		=> __( 'Facebook', 'newsplus' ),
			'label'		=> __( 'Enable Facebook Like button', 'newsplus' ),
			'id'		=> 'pls_ss_fb',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_ss_tw' => array(
			'name'		=> __( 'Twitter', 'newsplus' ),
			'label'		=> __( 'Enable Twitter button', 'newsplus' ),
			'id'		=> 'pls_ss_tw',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_ss_tw_usrname' => array(
			'name'		=> __( 'Twitter Username (optional)', 'newsplus' ),
			'desc'		=> __( 'Write your twitter username without @', 'newsplus' ),
			'id'		=> 'pls_ss_tw_usrname',
			'std'		=> '',
			'type'		=> 'text'
		),

		'pls_ss_gp' => array(
			'name'		=> __( 'Google Plus', 'newsplus' ),
			'label'		=> __( 'Enable Google Plus button', 'newsplus' ),
			'id'		=> 'pls_ss_gp',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_ss_pint' => array(
			'name'		=> __( 'Pinterest', 'newsplus' ),
			'label'		=> __( 'Enable Pinterest button.', 'newsplus' ),
			'id'		=> 'pls_ss_pint',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_ss_ln' => array(
			'name'		=> __( 'LinkedIn', 'newsplus' ),
			'label'		=> __( 'Enable LinkedIn button.', 'newsplus' ),
			'id'		=> 'pls_ss_ln',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_ss_vk' => array(
			'name'		=> __( 'VK', 'newsplus' ),
			'label'		=> __( 'Enable VK button.', 'newsplus' ),
			'id'		=> 'pls_ss_vk',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_ss_yandex' => array(
			'name'		=> __( 'Yandex', 'newsplus' ),
			'label'		=> __( 'Enable Yandex button.', 'newsplus' ),
			'id'		=> 'pls_ss_yandex',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_ss_reddit' => array(
			'name'		=> __( 'Reddit', 'newsplus' ),
			'label'		=> __( 'Enable Reddit button.', 'newsplus' ),
			'id'		=> 'pls_ss_reddit',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		array(
			'name'		=> __( 'Social sharing buttons settings', 'newsplus' ),
			'type'		=> 'subheading'
		),		
		
		'pls_show_social_btns' => array(
			'name'		=> __( 'Social share buttons', 'newsplus' ),
			'label'		=> __( 'Show social sharing buttons on single posts', 'newsplus' ),
			'id'		=> 'pls_show_social_btns',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		'pls_social_sticky' => array(
			'name'		=> __( 'Sticky buttons on mobile', 'newsplus' ),
			'label'		=> __( 'Make social share buttons sticky on mobile', 'newsplus' ),
			'id'		=> 'pls_social_sticky',
			'type'		=> 'checkbox',
			'std'		=> false
		),		
		
		'pls_social_btns' => array(
			'name'		=> __( 'Buttons to show', 'newsplus' ),
			'desc'		=> __( 'Select social buttons to show on single posts.', 'newsplus' ),
			'id'		=> 'pls_social_btns',
			'std'		=> '',
			'type'		=> 'multiselect',
			'options'	=> array(
							'Twitter' => 'twitter',
							'Facebook' => 'facebook',
							'Whatsapp' => 'whatsapp',
							'GooglePlus' => 'googleplus',
							'LinkedIn' => 'linkedin',							
							'Pinterest' => 'pinterest',
							'VKOntakte' => 'vkontakte',
							'Email' => 'email',
							'Print' => 'print',
							'Reddit' => 'reddit'
						)
		),			

		array(
			'name'		=> __( 'Global Single Post Advertisements', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_ad_above' => array(
			'name'		=> __( 'Advertisement above the post', 'newsplus' ),
			'desc'		=> __( 'Enter custom HTML or advertisement code that should appear above the post. Short codes are supported. The markup used here will apply to all posts globally.<br/>You can override or hide this ad on individual posts.', 'newsplus' ),
			'id'		=> 'pls_ad_above',
			'std'		=> '',
			'type'		=> 'textarea'
		),

		'pls_ad_below' => array(
			'name'		=> __( 'Advertisement below the post', 'newsplus' ),
			'desc'		=> __( 'Enter custom HTML or advertisement code that should appear below the post. Short codes are supported. The markup used here will apply to all posts globally.<br/>You can override or hide this ad on individual posts.', 'newsplus' ),
			'id'		=> 'pls_ad_below',
			'std'		=> '',
			'type'		=> 'textarea'
		),
		
		array( 'type' 	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_contact'
		),

		array(
			'name'		=> __( 'Contact page template settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_email' => array(
			'name'		=> __( 'Contact e-mail', 'newsplus' ),
			'desc'		=> __( 'Enter an e-mail address to which mail should be received from contact page. If left blank, your blog admin email is used.', 'newsplus' ),
			'id'		=> 'pls_email',
			'std'		=> '',
			'type'		=> 'text'
		),

		'pls_google_map' => array(
			'name'		=> __( 'Contact Page custom Markup<br/>(Can be used for Google Maps)', 'newsplus' ),
			'desc'		=> __( 'Visit maps.google.com and copy your map location iFrame code. Paste it here. This will be shown on contact page template.<br/>Tip: You can also use any custom markup or HTML here instead of Google Maps.', 'newsplus' ),
			'id'		=> 'pls_google_map',
			'std'		=> '',
			'type'		=> 'textarea'
		),

		'pls_success_msg' => array(
			'name'		=> __( 'Mail Sent Message:', 'newsplus' ),
			'desc'		=> __( 'Enter a message that should be displayed when the mail is successfully sent.', 'newsplus' ),
			'id'		=> 'pls_success_msg',
			'std'		=> __( '<h4>Thank You! Your message has been sent.</h4>', 'newsplus' ),
			'type'		=> 'textarea'
		),

		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_footer'
		),

		array(
			'name'		=> __( 'Footer settings', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_footer_cols' => array(
			'name'		=> __( 'Footer columns', 'newsplus' ),
			'desc'		=> __( 'Select number of columns in secondary widget area.', 'newsplus' ),
			'id'		=> 'pls_footer_cols',
			'std'		=> '4',
			'type'		=> 'select',
			'options'	=> array( '1','2','3','4','5','6')
		),
		
		'pls_footer_left' => array(
			'name'		=> __( 'Custom Footer Text (Left):', 'newsplus' ),
			'desc'		=> __( 'Enter custom text for left side of the footer. You can use <code>HTML</code> here.', 'newsplus' ),
			'id'		=> 'pls_footer_left',
			'std'		=> '&copy; 2016 CompanyName. All rights reserved.',
			'type'		=> 'textarea'
		),

		'pls_footer_right' => array(
			'name'		=> __( 'Custom Footer Text (Right):', 'newsplus' ),
			'desc'		=> __( 'Enter custom text for right side of the footer. You can use <code>HTML</code> here.', 'newsplus' ),
			'id'		=> 'pls_footer_right',
			'std'		=> 'Optional footer notes.',
			'type'		=> 'textarea'
		),

		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_custom_font'
		),

		array(
			'name'		=> __( 'Custom Font Settings', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'pls_disable_custom_font' => array(
			'name'		=> __( 'Disable Google fonts', 'newsplus' ),
			'label'		=> __( 'Disable custom Google font', 'newsplus' ),
			'id'		=> 'pls_disable_custom_font',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		'pls_global_font' => array(
			'name'		=> __( 'Global font family', 'newsplus' ),
			'desc'		=> __( 'Select global font family for entire site.', 'newsplus' ),
			'id'		=> 'pls_global_font',
			'std'		=> '',
			'type'		=> 'select',
			'options'	=> $newsplus_google_font_list
		),
		
		'pls_heading_font' => array(
			'name'		=> __( 'Heading font family', 'newsplus' ),
			'desc'		=> __( 'Select font family for headings.', 'newsplus' ),
			'id'		=> 'pls_heading_font',
			'std'		=> '',
			'type'		=> 'select',
			'options'	=> $newsplus_google_font_list
		),
		
		'pls_menu_font' => array(
			'name'		=> __( 'Navigation menu font family', 'newsplus' ),
			'desc'		=> __( 'Select font family for main navigation.', 'newsplus' ),
			'id'		=> 'pls_menu_font',
			'std'		=> '',
			'type'		=> 'select',
			'options'	=> $newsplus_google_font_list
		),
		
		'pls_font_subset' => array(
			'name'		=> __( 'Subsets', 'newsplus' ),
			'desc'		=> __( 'Enter Google font subsets values, separated by comma. E.g. <code>cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese</code>', 'newsplus' ),
			'id'		=> 'pls_font_subset',
			'std'		=> 'latin,latin-ext',
			'type'		=> 'textarea'
		),
		
		'pls_font_family' => array(
			'name'		=> __( 'Font family (Deprecated)', 'newsplus' ),
			'desc'		=> __( 'This option is deprecated. Use Google fonts from the options above.', 'newsplus' ),
			'id'		=> 'pls_font_family',
			'std'		=> '',
			'type'		=> 'textarea'
		),			
		
		'pls_user_css' => array(
			'name'		=> __( 'Additional CSS', 'newsplus' ),
			'desc'		=> __( 'You can add any custom CSS in this field, but it is strongly recommended to use child theme\'s style.css for any custom CSS changes. Example for font CSS:<br/> <pre>body.custom-font-enabled {<br/>  font-family: \'Open Sans\';<br/>}</pre>', 'newsplus' ),
			'id'		=> 'pls_user_css',
			'std'		=> '',
			'type'		=> 'textarea'
		),

		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_image_sizes'
		),

		array(
			'type'		=> 'subdescription',
			'desc'		=> __( 'Use this section for specifying custom image sizes for archives. You can set width, height and crop mode. For auto height, use 9999 in height and uncheck the hard crop mode.', 'newsplus' ),
		),


		array(
			'name'		=> __( 'Grid style blog images', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'grid_width' => array(
			'name'		=> __( 'Width', 'newsplus' ),
			'desc'		=> __( 'Enter a width for one columnar grid images.', 'newsplus' ),
			'id'		=> 'grid_width',
			'std'		=> '640',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'grid_height' => array(
			'name'		=> __( 'Height', 'newsplus' ),
			'desc'		=> __( 'Enter a height for one columnar grid images.', 'newsplus' ),
			'id'		=> 'grid_height',
			'std'		=> '360',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),
		
		'grid_quality' => array(
			'name'		=> __( 'Image quality', 'newsplus' ),
			'desc'		=> __( 'Provide image quality in range [1-100]. E.g. 80', 'newsplus' ),
			'id'		=> 'grid_quality',
			'std'		=> '80',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'grid_crop' => array(
			'name'		=> __( 'Hard Crop', 'newsplus' ),
			'label'		=> __( 'Enable hard crop', 'newsplus' ),
			'id'		=> 'grid_crop',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		
		array(
			'name'		=> __( 'Classic style blog images', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'classic_width' => array(
			'name'		=> __( 'Width', 'newsplus' ),
			'desc'		=> __( 'Enter a width for list style big images.', 'newsplus' ),
			'id'		=> 'classic_width',
			'std'		=> '960',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'classic_height' => array(
			'name'		=> __( 'Height', 'newsplus' ),
			'desc'		=> __( 'Enter a height for list style big images.', 'newsplus' ),
			'id'		=> 'classic_height',
			'std'		=> '540',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),
		
		'classic_quality' => array(
			'name'		=> __( 'Image quality', 'newsplus' ),
			'desc'		=> __( 'Provide image quality in range [1-100]. E.g. 80', 'newsplus' ),
			'id'		=> 'classic_quality',
			'std'		=> '80',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),		

		'classic_crop' => array(
			'name'		=> __( 'Hard Crop', 'newsplus' ),
			'label'		=> __( 'Enable hard crop', 'newsplus' ),
			'id'		=> 'classic_crop',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		array(
			'name'		=> __( 'List style blog images', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'list_big_width' => array(
			'name'		=> __( 'Width', 'newsplus' ),
			'desc'		=> __( 'Enter a width for list style big images.', 'newsplus' ),
			'id'		=> 'list_big_width',
			'std'		=> '640',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'list_big_height' => array(
			'name'		=> __( 'Height', 'newsplus' ),
			'desc'		=> __( 'Enter a height for list style big images.', 'newsplus' ),
			'id'		=> 'list_big_height',
			'std'		=> '360',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),
		
		'list_big_quality' => array(
			'name'		=> __( 'Image quality', 'newsplus' ),
			'desc'		=> __( 'Provide image quality in range [1-100]. E.g. 80', 'newsplus' ),
			'id'		=> 'list_big_quality',
			'std'		=> '80',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'list_big_crop' => array(
			'name'		=> __( 'Hard Crop', 'newsplus' ),
			'label'		=> __( 'Enable hard crop', 'newsplus' ),
			'id'		=> 'list_big_crop',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		array(
			'name'		=> __( 'Related Posts Images', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'rp_width' => array(
			'name'		=> __( 'Width', 'newsplus' ),
			'desc'		=> __( 'Enter a width for related posts images on Single post.', 'newsplus' ),
			'id'		=> 'rp_width',
			'std'		=> '400',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'rp_height' => array(
			'name'		=> __( 'Height', 'newsplus' ),
			'desc'		=> __( 'Enter a height for related posts images on Single post.', 'newsplus' ),
			'id'		=> 'rp_height',
			'std'		=> '225',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),
		
		'rp_quality' => array(
			'name'		=> __( 'Image quality', 'newsplus' ),
			'desc'		=> __( 'Provide image quality in range [1-100]. E.g. 80', 'newsplus' ),
			'id'		=> 'rp_quality',
			'std'		=> '80',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'rp_crop' => array(
			'name'		=> __( 'Crop', 'newsplus' ),
			'label'		=> __( 'Enable hard crop', 'newsplus' ),
			'id'		=> 'rp_crop',
			'type'		=> 'checkbox',
			'std'		=> false
		),

		array(
			'name'		=> __( 'Single Post Image', 'newsplus' ),
			'type'		=> 'subheading'
		),

		'sng_width' => array(
			'name'		=> __( 'Width', 'newsplus' ),
			'desc'		=> __( 'Enter a width for single post featured image.', 'newsplus' ),
			'id'		=> 'sng_width',
			'std'		=> '960',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'sng_height' => array(
			'name'		=> __( 'Height', 'newsplus' ),
			'desc'		=> __( 'Enter a height for single post featured image.', 'newsplus' ),
			'id'		=> 'sng_height',
			'std'		=> '540',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),
		
		'sng_quality' => array(
			'name'		=> __( 'Image quality', 'newsplus' ),
			'desc'		=> __( 'Provide image quality in range [1-100]. E.g. 80', 'newsplus' ),
			'id'		=> 'sng_quality',
			'std'		=> '80',
			'type'		=> 'number',
			'min'		=> '',
			'max'		=> ''
		),

		'sng_crop' => array(
			'name'		=> __( 'Hard Crop', 'newsplus' ),
			'label'		=> __( 'Enable hard crop', 'newsplus' ),
			'id'		=> 'sng_crop',
			'type'		=> 'checkbox',
			'std'		=> false
		),
		
		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_custom_menus'
		),
		
		array(
			'name'		=> __( 'Custom HTML menus', 'newsplus' ),
			'type'		=> 'subheading'
		),		
		
		'pls_html_main_menu' => array(
			'name'		=> __( 'HTML Primary Menu', 'newsplus' ),
			'desc'		=> __( 'Use custom HTML menu markup in this field. It reduces load time by 0.2s as compared to WP menu. You can copy source code of main menu from front end and paste here. The code should include parent ul list and it\'s children.', 'newsplus' ),
			'id'		=> 'pls_html_main_menu',
			'type'		=> 'textarea',
			'std'		=> false
		),
		
		'pls_html_top_menu' => array(
			'name'		=> __( 'HTML Top Menu', 'newsplus' ),
			'desc'		=> __( 'Use custom HTML menu markup in this field. It reduces load time by 0.2s as compared to WP menu. You can copy source code of main menu from front end and paste here. The code should include parent ul list and it\'s children.', 'newsplus' ),
			'id'		=> 'pls_html_top_menu',
			'type'		=> 'textarea',
			'std'		=> false
		),

		array( 'type'	=> 'tabbed_end' ),

		array(
			'type'		=> 'tabbed_start',
			'id'		=> 'pls_import_export'
		),
		
		array(
			'name'		=> __( 'Import or export theme settings', 'newsplus' ),
			'type'		=> 'subheading'
		),
		
		'pls_curr_settings' => array(
			'name'		=> __( 'Your current settings', 'newsplus' ),
			'desc'		=> __( 'Copy contents of above textarea and save in a text file for keeping a backup of current settings. You can copy them from file again and paste inside the \'Import new settings\' textarea below.', 'newsplus' ),
			'id'		=> 'pls_curr_settings',
			'type'		=> 'export_textarea',
			'std'		=> false
		),
		
		'pls_new_settings' => array(
			'name'		=> __( 'Import new settings', 'newsplus' ),
			'desc'		=> __( 'Paste new settings inside this textarea. Then click on \'Save Settings\' and then click \'Update imported settings\' button. Once settings are updated, you can delete contents of this textarea.', 'newsplus' ),
			'id'		=> 'pls_new_settings',
			'type'		=> 'import_textarea',
			'std'		=> false
		),									

		array( 'type'	=> 'tabbed_end' ),

		array( 'type' 	=> 'wrap_end' )
);

function newsplus_add_admin() {
	global $shortname, $newsplus_options;
	ob_start();
	if ( isset( $_GET['page'] ) && ( $_GET['page'] == basename(__FILE__) ) ) {
	
		// Nonce values
		$save_nonce		= isset( $_REQUEST['_np_save_settings_nonce'] ) ? $_REQUEST['_np_save_settings_nonce'] : '';
		$reset_nonce 	= isset( $_REQUEST['_np_reset_settings_nonce'] ) ? $_REQUEST['_np_reset_settings_nonce'] : '';
		$import_nonce 	= isset( $_REQUEST['_np_import_settings_nonce'] ) ? $_REQUEST['_np_import_settings_nonce'] : '';
		
		if ( isset( $_REQUEST['action'] ) && ( 'save' == $_REQUEST['action'] ) ) {
			if ( ! wp_verify_nonce( $save_nonce, 'save_settings' ) ) {
				print __( 'Sorry, your nonce did not verify.', 'newsplus' );
				exit;
			}
			
			else {
				foreach ( $newsplus_options as $value ) {
					if ( isset( $value['id'] ) ) {
						if ( isset( $_REQUEST[ $value['id'] ] ) ) {
							update_option( $value['id'], $_REQUEST[ $value['id'] ] );
						}
						else {
							delete_option( $value['id'] );
						}
					}
				}
				header( 'Location:themes.php?page=theme-admin-options.php&saved=true&_np_save_settings_nonce=' . $_REQUEST['_np_save_settings_nonce'] );
				die;
			}
		}
		elseif ( isset( $_REQUEST['action'] ) && ( 'reset' == $_REQUEST['action'] ) ) {
		
			if ( ! wp_verify_nonce( $reset_nonce, 'reset_settings' ) ) {
				print __( 'Sorry, your nonce did not verify.', 'newsplus' );
				exit;
			}
			else {
				foreach ( $newsplus_options as $value ) {
					if ( isset( $value['id'] ) ) {
						delete_option( $value['id'] );
						update_option( $value['id'], $value['std'] );
					}
				}
				header( 'Location:themes.php?page=theme-admin-options.php&reset=true&_np_reset_settings_nonce=' . $_REQUEST['_np_reset_settings_nonce'] );
				die;
			}
		}
		
		elseif ( isset( $_REQUEST['action'] ) && ( 'import' == $_REQUEST['action'] ) ) {
		
			if ( ! wp_verify_nonce( $import_nonce, 'import_settings' ) ) {
				print __( 'Sorry, your nonce did not verify.', 'newsplus' );
				exit;
			}
			else {
				// Check if there are any settings to import
				if ( '' != get_option( 'pls_new_settings', '' ) ) {
					$new_settings = json_decode( stripslashes( get_option( 'pls_new_settings', '' ) ), true );
					if ( is_array( $new_settings ) ) {				
						foreach ( $new_settings as $key => $value ) {
							if ( isset( $value['id'] ) && 'pls_new_settings' != $key ) {
								update_option( $key, $value['id'] );
							}
						}				
					
					}
					
					header( 'Location:themes.php?page=theme-admin-options.php&import=true&_np_import_settings_nonce=' . $_REQUEST['_np_import_settings_nonce'] );
					die;				
				
				}
				
				else {
					header( 'Location:themes.php?page=theme-admin-options.php&import=false&_np_import_settings_nonce=' . $_REQUEST['_np_import_settings_nonce'] );
					die;			
				}
			}
		}
	}
	$hookname = add_theme_page( __( 'Theme Options', 'newsplus' ), __( 'Theme Options', 'newsplus' ), 'edit_theme_options', basename( __FILE__ ), 'newsplus_admin' );
	add_action( 'admin_print_scripts-' . $hookname, 'newsplus_admin_scripts' );
	ob_end_clean();
}
function newsplus_admin_scripts() {
	global $shortname, $newsplus_options;

	// Load scripts required by Theme Options page
	wp_enqueue_style( 'theme-admin-css', get_template_directory_uri() . '/css/admin.css', false, '', 'all' );
	wp_enqueue_script( 'theme-admin-js', get_template_directory_uri() . '/js/admin.js', false, '' );
	
	// WP media uplaoder
	if ( ! did_action( 'wp_enqueue_media' ) )
		wp_enqueue_media();

	// Localize text strings and variables used in media uploader code
	$localization = array(
		'media_upload_text' => esc_html__( 'Select or upload image' , 'newsplus' ),
		'media_button_text' => esc_html__( 'Use image' , 'newsplus' ),
	);

	wp_localize_script( 'theme-admin-js', 'np_localize', $localization );	
}

function newsplus_theme_options_notices() {
	// Get nonce values
	$save_nonce = isset( $_REQUEST['_np_save_settings_nonce'] ) ? $_REQUEST['_np_save_settings_nonce'] : '';
	$reset_nonce = isset( $_REQUEST['_np_reset_settings_nonce'] ) ? $_REQUEST['_np_reset_settings_nonce'] : '';
	$import_nonce = isset( $_REQUEST['_np_import_settings_nonce'] ) ? $_REQUEST['_np_import_settings_nonce'] : '';
    
	if ( isset( $_REQUEST['saved'] ) && $_REQUEST['saved'] ) {
		?>
		<div class="notice notice-success is-dismissible">
			<p><?php _e( 'Theme settings saved.', 'newsplus' ); ?></p>
		</div>
		<?php
	}
	
    if ( isset( $_REQUEST['reset'] ) && $_REQUEST['reset'] ) { ?>
		<div class="notice notice-success is-dismissible">
            <p><?php _e( 'Theme settings reset.', 'newsplus' ); ?></p>
        </div>
	<?php }
	
	 if ( isset( $_REQUEST['import'] ) && $_REQUEST['import'] ) {
		$new_settings = json_decode( stripslashes( get_option( 'pls_new_settings', '' ) ), true );
		if ( is_array( $new_settings ) ) {
			?>
			<div class="notice notice-success is-dismissible">
                <p> <?php _e( 'Theme settings imported and updated successfully.', 'newsplus' ); ?></p>
			</div>
			<?php
		}
		else {
			?>
			<div class="notice notice-error is-dismissible">
                <p> <?php _e( 'Unable to import settings. Either import field is empty or the data is invalid.', 'newsplus' ); ?></p>
			</div>
			<?php
		}
	}	
}
add_action( 'admin_notices', 'newsplus_theme_options_notices' );

function newsplus_admin() {
    global $shortname, $newsplus_options;
	?>  
    <div class="wrap">
    <div id="icon-themes" class="icon32"></div>
        <h2 class="settings-title ss-settings-title"><?php _e( 'Theme Options', 'newsplus' ); ?></h2>
        <form method="post">
		<?php foreach ( $newsplus_options as $value ) {
                switch ( $value['type'] ) {

                    case 'wrap_start': ?>
                    <div class="ss_wrap">
                    <?php break;

                    case 'wrap_end': ?>
                    </div>
                    <?php break;

                    case 'tabs_start': ?>
                    <nav class="nav-tab-wrapper ss-nav-tab-wrapper">
                    <?php break;

                    case 'tabs_end': ?>
                    </nav>
                    <?php break;

                    case 'tabbed_start': ?>
                    <div class="tabbed" id="<?php echo $value['id']; ?>">
                    <?php break;

                    case 'tabbed_end': ?>
                    </div>
                    <?php break;

                    case 'heading': ?>
                    <a class="nav-tab" href="#<?php echo $value['id']; ?>"><?php echo $value['name']; ?></a>
                    <?php break;

                    case 'subheading': ?>
                    <h2><?php echo $value['name']; ?></h2>
                    <?php break;

                    case 'subdescription': ?>
                    <p><?php echo $value['desc']; ?></p>
                    <?php break;

                    case 'select': ?>
                    <ul class="item_row">
                        <li class="left_col"><?php echo $value['name']; ?></li>
                        <li class="right_col">
                            <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
                                <?php
                                
								
							foreach ( $value['options'] as $index => $data ) {
							
								if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
									$option_label = $data;
									$option_value = $data;
								} elseif ( is_numeric( $index ) && is_array( $data ) ) {
									$option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
									$option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
								} else {
									$option_value = $data;
									$option_label = $index;
								}
								$selected = '';
								//$option_value_string = (string) $option_value;
								//$value_string = (string) get_option( $value['id'] );
								if ( get_option( $value['id'] ) && get_option( $value['id'] ) == $option_value ) {
									$selected = ' selected="selected"';
								}

								echo '<option value="' . esc_attr( $option_value ) . '"' . $selected . '>'
										   . htmlspecialchars( $option_label ) . '</option>';
							}
							?>							

                            </select>
                           <?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
                        </li>
                    </ul>
                    <?php break;
					
					case 'multiselect' : ?>
                        <ul class="item_row">
                            <li class="left_col"><?php echo $value['name']; ?></li>
                            <li class="right_col">
						
						<?php
                        $output = '<select class="multiselect" name="' . $value['id'] . '[]" id="' . $value['id'] . '" multiple="multiple" size="5">';
						$value_arr = ( null !== get_option( $value['id'] ) ) ? get_option( $value['id'] ) : array();
						if ( ! empty( $value['options'] ) ) {
					
							foreach ( $value['options'] as $index => $data ) {
							
								if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
									$option_label = $data;
									$option_value = $data;
								} elseif ( is_numeric( $index ) && is_array( $data ) ) {
									$option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
									$option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
								} else {
									$option_value = $data;
									$option_label = $index;
								}
								$selected = '';
								$option_value_string = (string) $option_value;
								//$value_string = (string) get_option( $value['id'] );
								if ( is_array( $value_arr ) && in_array( $data, $value_arr ) ) {
									$selected = ' selected="selected"';
								}

								$output .= '<option value="' . esc_attr( $option_value ) . '"' . $selected . '>'
										   . htmlspecialchars( $option_label ) . '</option>';
							}
						}
						$output .= '</select>';
						echo $output;
						if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
                        </li>
                    </ul>				
					
					<?php
                    break;

                    case 'text':
                    ?>
                    <ul class="item_row">
                        <li class="left_col"><?php echo $value['name']; ?></li>
                        <li class="right_col">
                            <input class="regular-text" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != $value['std'] ) { echo get_option( $value['id'] ); } else { echo $value['std']; } ?>" />
                            <?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
                        </li>
                    </ul>
                    <?php break;
					
					case 'number':
                    ?>
                    <ul class="item_row">
                        <li class="left_col"><?php echo $value['name']; ?></li>
                        <li class="right_col">
                            <input class="regular-text" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="number" min="<?php echo $value['min']; ?>" max="<?php echo $value['max']; ?>" value="<?php if ( get_option( $value['id'] ) != $value['std'] ) { echo get_option( $value['id'] ); } else { echo $value['std']; } ?>" />
                            <?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
                        </li>
                    </ul>
                    <?php break;

                    case 'textarea':
                    ?>
                    <ul class="item_row">
                        <li class="left_col"><?php echo $value['name']; ?></li>
                        <li class="right_col">
                            <textarea class="code" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="30" rows="6"><?php if ( get_option( $value['id'] ) != $value['std'] ) { echo stripslashes( get_option( $value['id'] ) ); } else { echo $value['std']; } ?></textarea>
                        <?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
                        </li>
                    </ul>
                    <?php break;

                    case "checkbox":
                    ?>
                    <ul class="item_row">
                        <li class="left_col"><?php echo $value['name']; ?></li>
                        <li class="right_col">
                            <?php
							$label = isset( $value['label'] ) ? $value['label'] : '';
							if ( get_option( $value['id'] ) ){ $checked = 'checked="checked"'; } else { $checked = ''; } ?>
                            <label for="<?php echo $value['id']; ?>"><input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> /><?php echo ' ' . $label; ?></label>                     
                        	<?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
                        </li>
                    </ul>
                    <?php break;
					
                    case 'export_textarea':				
					?>
						<ul class="item_row">
							<li class="left_col"><?php echo $value['name']; ?></li>
							<li class="right_col">
								<textarea class="code" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="100" rows="10" onclick="this.focus();this.select()" readonly ><?php echo newsplus_current_settings(); ?></textarea>
							<?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
							</li>
						</ul>
                    <?php break;
					
                    case 'import_textarea':				
					?>
						<ul class="item_row">
							<li class="left_col"><?php echo $value['name']; ?></li>
							<li class="right_col">
								 <textarea class="code" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="100" rows="10"><?php if ( get_option( $value['id'] ) != $value['std'] ) { echo stripslashes( get_option( $value['id'] ) ); } else { echo stripslashes( $value['std'] ); } ?></textarea>
							<?php if ( isset( $value['desc'] ) ) { echo '<p class="description">' . $value['desc'] . '</p>'; } ?>
							</li>
						</ul>
                     <?php
                     break;
					 
					 case 'image_uploader' :
					 ?>
 						<ul class="item_row">
							<li class="left_col"><?php echo $value['name']; ?></li>
							<li class="right_col">
                                <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" class="code image-url" type="text" size="36" value="<?php if ( get_option( $value['id'] ) != $value['std'] ) { echo get_option( $value['id'] ); } else { echo $value['std']; } ?>" />
                                <input class="upload_image_btn button button-primary<?php if ( get_option( $value['id'] ) ) { echo ' hidden'; } ?>" type="button" value="Upload Image" /> <input class="button delete_image_btn<?php if ( ! get_option( $value['id'] )  ) { echo ' hidden'; } ?>" type="button" value="<?php esc_attr_e( 'Remove image' ); ?>" />
                            </li>
                        </ul>
					 
					 <?php
                     break;									
				}
			}
			?>
			<div class="submit-row">
				<input class="button button-primary" name="save" type="submit" value="<?php _e( 'Save Settings', 'newsplus' ); ?>" />
                <input type="hidden" name="action" value="save" />
                <?php wp_nonce_field( 'save_settings', '_np_save_settings_nonce', false ); ?>
			</div>
        </form>
        <div class="submit-row reset-row">
            <form method="post">
                <input class="button" name="reset" type="submit" value="<?php _e( 'Reset all Settings', 'newsplus' ); ?>" />
                <input type="hidden" name="action" value="reset" />
                <?php wp_nonce_field( 'reset_settings', '_np_reset_settings_nonce', false ); ?>
            </form>
        </div>
        
        <div class="submit-row reset-row">
            <form method="post">
                <input class="button" name="import" type="submit" value="<?php _e( 'Update imported settings', 'newsplus' ); ?>" />
                <input type="hidden" name="action" value="import" />
				<?php wp_nonce_field( 'import_settings', '_np_import_settings_nonce', false ); ?>
            </form>
        </div>        
    </div> <!-- .wrap -->
<?php }

function newsplus_current_settings() {
	global $newsplus_options;
	$new = array();
	
	foreach ( $newsplus_options as $key => $value ) {
		if( isset( $value['id'] ) && isset( $value['std'] ) && 'pls_curr_settings' != $key && 'pls_new_settings' != $key   ) {
			if ( get_option( $value['id'] ) === FALSE )
				$new[ $key ]['id'] = $value['std'];
			else
				$new[ $key ]['id'] = get_option( $value['id'] );
		}
	}
	
	return json_encode( $new, JSON_FORCE_OBJECT );
}
add_action( 'admin_menu', 'newsplus_add_admin' ); ?>